/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.CacheKey;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderCacheStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderCacheStrategy.class);
    private final int delay;
    private final int size;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final Map<CacheKey, RequestWrapper> cache = new HashMap<CacheKey, RequestWrapper>();

    public SenderCacheStrategy(int delay, int size) {
        this.delay = delay;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse putIfAbsent(CacheKey cacheKey, RequestHandlerTCP<FutureResponse> request, ChannelCreator channelCreator) {
        Map<CacheKey, RequestWrapper> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(cacheKey)) {
                RequestWrapper requestWrapper = this.cache.get(cacheKey);
                RequestHandlerTCP<FutureResponse> requestHandlerTCP = requestWrapper.getRequest();
                requestHandlerTCP.getFutureResponse().share();
                int newSize = this.merge(request.getFutureResponse().getRequest(), requestHandlerTCP.getFutureResponse().getRequest());
                if (newSize > this.size) {
                    this.fireMessage(cacheKey, requestWrapper);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("fire request, size reached");
                    }
                } else {
                    SendTimer sendTimer = requestWrapper.getSendTimer();
                    sendTimer.activity();
                    request.getFutureResponse().setResponse();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("caching request");
                    }
                }
                return requestHandlerTCP.getFutureResponse();
            }
            RequestWrapper requestWrapper = new RequestWrapper();
            requestWrapper.setRequest(request);
            requestWrapper.setChannelCreator(channelCreator);
            SendTimer sendTimer = new SendTimer(this.delay, cacheKey, requestWrapper);
            requestWrapper.setSendTimer(sendTimer);
            ScheduledFuture<?> future = this.executor.schedule(sendTimer, (long)this.delay, TimeUnit.MILLISECONDS);
            requestWrapper.setFuture(future);
            this.cache.put(cacheKey, requestWrapper);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("new request to " + cacheKey.getRemotePeer());
            }
        }
        return request.getFutureResponse();
    }

    private void fireMessage(CacheKey cacheKey, RequestWrapper requestWrapper) {
        this.cache.remove(cacheKey);
        ScheduledFuture<?> future = requestWrapper.getFuture();
        future.cancel(false);
        requestWrapper.getRequest().sendTCP(requestWrapper.getChannelCreator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fire message");
        }
    }

    private int merge(Message requestSource, Message requestTarget) {
        Map<Number480, Data> dataMap480;
        if (requestTarget.getDataMap480() == null) {
            dataMap480 = new HashMap<Number480, Data>();
            this.convertDataMap(requestTarget, dataMap480);
        } else {
            dataMap480 = requestTarget.getDataMap480();
        }
        if (requestSource.getDataMap() != null) {
            this.convertDataMap(requestSource, dataMap480);
        }
        if (requestSource.getDataMap480() != null) {
            dataMap480.putAll(requestSource.getDataMap480());
        }
        return dataMap480.size();
    }

    private void convertDataMap(Message requestTarget, Map<Number480, Data> dataMap) {
        Number160 locationKey = requestTarget.getKeyKey1();
        Number160 domainKey = requestTarget.getKeyKey2();
        for (Map.Entry<Number160, Data> entry : requestTarget.getDataMap().entrySet()) {
            dataMap.put(new Number480(locationKey, domainKey, entry.getKey()), entry.getValue());
        }
        requestTarget.replaceDataMap(dataMap);
    }

    private static class RequestWrapper {
        private RequestHandlerTCP<FutureResponse> request;
        private SendTimer sendTimer;
        private ScheduledFuture<?> future;
        private ChannelCreator channelCreator;

        private RequestWrapper() {
        }

        public RequestHandlerTCP<FutureResponse> getRequest() {
            return this.request;
        }

        public void setRequest(RequestHandlerTCP<FutureResponse> request) {
            this.request = request;
        }

        public SendTimer getSendTimer() {
            return this.sendTimer;
        }

        public void setSendTimer(SendTimer sendTimer) {
            this.sendTimer = sendTimer;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public ChannelCreator getChannelCreator() {
            return this.channelCreator;
        }

        public void setChannelCreator(ChannelCreator channelCreator) {
            this.channelCreator = channelCreator;
        }
    }

    private class SendTimer
    implements Runnable {
        private long lastActivity = System.currentTimeMillis();
        private final int delay;
        private final RequestWrapper requestWrapper;
        private final CacheKey cacheKey;

        public SendTimer(int delay, CacheKey cacheKey, RequestWrapper requestWrapper) {
            this.delay = delay;
            this.cacheKey = cacheKey;
            this.requestWrapper = requestWrapper;
        }

        public void activity() {
            this.lastActivity = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("last activity: " + this.lastActivity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Map map = SenderCacheStrategy.this.cache;
            synchronized (map) {
                if (now - this.lastActivity > (long)this.delay && SenderCacheStrategy.this.cache.containsKey(this.cacheKey)) {
                    LOGGER.debug("fire message, as timeout occured, delay: " + (now - this.lastActivity));
                    SenderCacheStrategy.this.fireMessage(this.cacheKey, this.requestWrapper);
                } else {
                    ScheduledFuture<?> future = SenderCacheStrategy.this.executor.schedule(this, (long)this.delay - (now - this.lastActivity), TimeUnit.MILLISECONDS);
                    this.requestWrapper.setFuture(future);
                }
            }
        }
    }
}

