/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplyHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReplyHandler.class);
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private boolean sign = false;

    public ReplyHandler(PeerBean peerBean, ConnectionBean connectionBean) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
    }

    protected void registerIoHandler(Message.Command ... names) {
        this.getConnectionBean().getDispatcherRequest().registerIoHandler(this.getPeerBean().getServerPeerAddress().getID(), this, names);
    }

    public Message createMessage(PeerAddress recipient, Message.Command name, Message.Type type) {
        Message m = new Message();
        m.setRecipient(recipient);
        m.setSender(this.getPeerBean().getServerPeerAddress());
        m.setCommand(name);
        m.setType(type);
        m.setVersion(this.getConnectionBean().getP2PID());
        return m;
    }

    public Message createResponseMessage(Message message, Message.Type type) {
        Message m = new Message();
        m.setRecipient(message.getSender());
        m.setSender(this.getPeerBean().getServerPeerAddress());
        m.setCommand(message.getCommand());
        m.setType(type);
        m.setVersion(this.getConnectionBean().getP2PID());
        m.setMessageId(message.getMessageId());
        return m;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Message message;
        logger.error("error in reply " + e.toString());
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        if ((message = (Message)ctx.getAttachment()) != null) {
            this.getPeerBean().getPeerMap().peerOffline(message.getSender(), true);
        }
        ctx.getChannel().close();
    }

    public Message forwardMessage(Message message) {
        this.getPeerBean().getPeerMap().peerFound(message.getSender(), message.getSender());
        try {
            Message reply = this.handleResponse(message, this.sign);
            return reply;
        }
        catch (Throwable e) {
            this.getPeerBean().getPeerMap().peerOffline(message.getSender(), true);
            logger.error("Exception in custom handler: " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public abstract Message handleResponse(Message var1, boolean var2) throws Exception;

    public void setSignReply(boolean sign) {
        this.sign = sign;
    }

    public PeerBean getPeerBean() {
        return this.peerBean;
    }

    public ConnectionBean getConnectionBean() {
        return this.connectionBean;
    }
}

