/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class CountingBloomFilter<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 3527833617516722215L;
    private final int k;
    private final int[] intSet;
    private final int intArraySize;
    private final int expectedElements;

    public CountingBloomFilter(int expectedElements, int[] intSet) {
        this.intArraySize = intSet.length;
        this.expectedElements = expectedElements;
        this.k = (int)Math.ceil((double)this.intArraySize / (double)expectedElements * Math.log(2.0));
        this.intSet = intSet;
    }

    public double expectedFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * (double)this.expectedElements / (double)this.intArraySize), this.k);
    }

    public int getExpectedElements() {
        return this.expectedElements;
    }

    @Override
    public boolean add(E o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            int index = r.nextInt(this.intArraySize);
            int old = this.intSet[index];
            if (old == Integer.MAX_VALUE) continue;
            this.intSet[index] = old + 1;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return false;
    }

    @Override
    public void clear() {
        for (int x = 0; x < this.intSet.length; ++x) {
            this.intSet[x] = 0;
        }
    }

    @Override
    public boolean contains(Object o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            if (this.intSet[r.nextInt(this.intArraySize)] != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public int[] getIntSet() {
        return this.intSet;
    }

    public int approximateCount(E key) {
        int retVal = Integer.MAX_VALUE;
        Random r = new Random(key.hashCode());
        for (int x = 0; x < this.k; ++x) {
            retVal = Math.min(retVal, this.intSet[r.nextInt(this.intArraySize)]);
        }
        return retVal;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CountingBloomFilter)) {
            return false;
        }
        CountingBloomFilter o = (CountingBloomFilter)obj;
        return o.k == this.k && o.intArraySize == this.intArraySize && this.expectedElements == o.expectedElements && this.intSet.equals(o.intSet);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        int magic = 31;
        hash = 31 * hash + this.intSet.hashCode();
        hash = 31 * hash + this.k;
        hash = 31 * hash + this.expectedElements;
        hash = 31 * hash + this.intArraySize;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.intSet.length;
        for (int i = 0; i < length; ++i) {
            sb.append(this.intSet[i]);
        }
        return sb.toString();
    }
}

