/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.Data;

public class BroadcastRPC
extends ReplyHandler {
    private final BroadcastHandler broadcastHandler;

    public BroadcastRPC(PeerBean peerBean, ConnectionBean connectionBean, BroadcastHandler broadcastHandler) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.BROADCAST_DATA);
        this.broadcastHandler = broadcastHandler;
    }

    public FutureResponse send(PeerAddress remotePeer, Number160 messageKey, Map<Number160, Data> dataMap, ChannelCreator channelCreator, int idleTCPMillis, boolean forceUDP) {
        return this.send(remotePeer, messageKey, dataMap, 0, channelCreator, idleTCPMillis, forceUDP);
    }

    public FutureResponse send(PeerAddress remotePeer, Number160 messageKey, Map<Number160, Data> dataMap, int hopCounter, ChannelCreator channelCreator, int idleTCPMillis, boolean forceUDP) {
        Message message = this.createMessage(remotePeer, Message.Command.BROADCAST_DATA, Message.Type.REQUEST_FF_1);
        message.setDataMap(dataMap);
        message.setInteger(hopCounter);
        message.setKey(messageKey);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.fireAndForgetTCP(channelCreator, idleTCPMillis);
        }
        RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler.fireAndForgetUDP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (message.getType() != Message.Type.REQUEST_FF_1 || message.getCommand() != Message.Command.BROADCAST_DATA) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        this.broadcastHandler.receive(message);
        return message;
    }

    public BroadcastHandler getBroadcastHandler() {
        return this.broadcastHandler;
    }
}

