/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.storage.ReplicationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replication
implements PeerMapChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(Replication.class);
    private final List<ResponsibilityListener> listeners = new ArrayList<ResponsibilityListener>();
    private final PeerMap peerMap;
    private final PeerAddress selfAddress;
    private final ReplicationStorage replicationStorage;
    private int replicationFactor;

    public Replication(ReplicationStorage replicationStorage, PeerAddress selfAddress, PeerMap peerMap, int replicationFactor) {
        this.replicationStorage = replicationStorage;
        this.selfAddress = selfAddress;
        this.peerMap = peerMap;
        this.replicationFactor = replicationFactor;
        peerMap.addPeerMapChangeListener(this);
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean isReplicationEnabled() {
        return this.listeners.size() > 0;
    }

    public void addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.add(responsibilityListener);
    }

    public void removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.remove(responsibilityListener);
    }

    private void notifyMeResponsible(Number160 locationKey) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey);
        }
    }

    private void notifyOtherResponsible(Number160 locationKey, PeerAddress other) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.otherResponsible(locationKey, other);
        }
    }

    public void updateAndNotifyResponsibilities(Number160 locationKey) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        PeerAddress closest = this.closest(locationKey);
        if (closest.getID().equals(this.selfAddress.getID())) {
            if (this.replicationStorage.updateResponsibilities(locationKey, closest.getID())) {
                this.notifyMeResponsible(locationKey);
            }
        } else if (this.replicationStorage.updateResponsibilities(locationKey, closest.getID())) {
            this.notifyOtherResponsible(locationKey, closest);
        }
    }

    @Override
    public void peerInserted(PeerAddress peerAddress) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The peer " + peerAddress + " was inserted in my map. I'm " + this.selfAddress);
        }
        Collection<Number160> myResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(this.selfAddress.getID());
        if (LOG.isDebugEnabled()) {
            LOG.debug("I (" + this.selfAddress + ") am currently responsibel for " + myResponsibleLocations);
        }
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            PeerAddress closest = this.closest(myResponsibleLocation);
            if (!closest.getID().equals(this.selfAddress.getID())) {
                if (!this.replicationStorage.updateResponsibilities(myResponsibleLocation, closest.getID())) continue;
                this.notifyOtherResponsible(myResponsibleLocation, closest);
                continue;
            }
            if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor) || !this.replicationStorage.updateResponsibilities(myResponsibleLocation, peerAddress.getID())) continue;
            this.notifyOtherResponsible(myResponsibleLocation, peerAddress);
        }
    }

    @Override
    public void peerRemoved(PeerAddress peerAddress) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        Collection<Number160> otherResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(peerAddress.getID());
        Collection<Number160> myResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(this.selfAddress.getID());
        for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
            PeerAddress closest = this.closest(otherResponsibleLocation);
            if (closest.getID().equals(this.selfAddress.getID())) {
                if (!this.replicationStorage.updateResponsibilities(otherResponsibleLocation, closest.getID())) continue;
                this.notifyMeResponsible(otherResponsibleLocation);
                myResponsibleLocations.remove(otherResponsibleLocation);
                continue;
            }
            this.replicationStorage.updateResponsibilities(otherResponsibleLocation, closest.getID());
        }
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) continue;
            this.notifyMeResponsible(myResponsibleLocation);
        }
    }

    @Override
    public void peerUpdated(PeerAddress peerAddress) {
    }

    private PeerAddress closest(Number160 locationKey) {
        SortedSet<PeerAddress> tmp = this.peerMap.closePeers(locationKey, 1);
        tmp.add(this.selfAddress);
        return (PeerAddress)tmp.iterator().next();
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        SortedSet<PeerAddress> tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }
}

