/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.DefaultMapAcceptHandler;
import net.tomp2p.peers.MapAcceptHandler;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerMapStat;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Timings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerMap {
    private static final Logger logger = LoggerFactory.getLogger(PeerMap.class);
    private final int bagSize;
    private final int maxPeers;
    private final Number160 self;
    private final List<Map<Number160, PeerAddress>> peerMap;
    private final Map<PeerAddress, Log> peerOfflineLogs;
    private final int cacheTimeout;
    private final int maxFail;
    private final AtomicInteger peerCount = new AtomicInteger();
    private final List<PeerMapChangeListener> peerMapChangeListeners = new ArrayList<PeerMapChangeListener>();
    private final List<PeerStatusListener> peerListeners = new ArrayList<PeerStatusListener>();
    private final int[] maintenanceTimeoutsSeconds;
    private final Map<PeerAddress, Long> maintenance = new LinkedHashMap<PeerAddress, Long>();
    private final Collection<InetAddress> filteredAddresses = Collections.synchronizedSet(new HashSet());
    private final PeerMapStat peerMapStat;
    private final Statistics statistics;
    private final MapAcceptHandler mapHandler;

    @Deprecated
    public PeerMap(Number160 self, int bagSize, int cacheTimeoutMillis, int maxNrBeforeExclude, int[] waitingTimeBetweenNodeMaintenenceSeconds, int cachSize, boolean acceptFirstClassOnly) {
        this(self, bagSize, cacheTimeoutMillis, maxNrBeforeExclude, waitingTimeBetweenNodeMaintenenceSeconds, cachSize, new DefaultMapAcceptHandler(acceptFirstClassOnly));
    }

    public PeerMap(Number160 self, int bagSize, int cacheTimeoutMillis, int maxNrBeforeExclude, int[] waitingTimeBetweenNodeMaintenenceSeconds, int cachSize, MapAcceptHandler mapHandler) {
        if (self == null || self.isZero()) {
            throw new IllegalArgumentException("Zero or null are not a valid IDs");
        }
        this.self = self;
        this.peerMapStat = new PeerMapStat();
        this.bagSize = bagSize;
        this.maxPeers = bagSize * 160;
        this.cacheTimeout = cacheTimeoutMillis;
        this.maxFail = maxNrBeforeExclude;
        this.maintenanceTimeoutsSeconds = waitingTimeBetweenNodeMaintenenceSeconds;
        this.peerOfflineLogs = new CacheMap<PeerAddress, Log>(cachSize, false);
        this.mapHandler = mapHandler;
        ArrayList tmp = new ArrayList();
        for (int i = 0; i < 160; ++i) {
            tmp.add(Collections.synchronizedMap(new HashMap()));
        }
        this.peerMap = Collections.unmodifiableList(tmp);
        this.statistics = new Statistics(this.peerMap, self, this.maxPeers, bagSize);
    }

    public void addPeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        this.peerMapChangeListeners.add(peerMapChangeListener);
    }

    public void removePeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        this.peerMapChangeListeners.add(peerMapChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerOfflineListener(PeerStatusListener peerListener) {
        List<PeerStatusListener> list = this.peerListeners;
        synchronized (list) {
            this.peerListeners.add(peerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerOfflineListener(PeerStatusListener peerListener) {
        List<PeerStatusListener> list = this.peerListeners;
        synchronized (list) {
            this.peerListeners.remove(peerListener);
        }
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private void notifyInsert(PeerAddress peerAddress) {
        this.statistics.triggerStatUpdate(true, this.size());
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerInserted(peerAddress);
        }
    }

    private void notifyRemove(PeerAddress peerAddress) {
        this.statistics.triggerStatUpdate(false, this.size());
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerRemoved(peerAddress);
        }
    }

    private void notifyUpdate(PeerAddress peerAddress) {
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerUpdated(peerAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOffline(PeerAddress peerAddress, PeerStatusListener.Reason reason) {
        List<PeerStatusListener> list = this.peerListeners;
        synchronized (list) {
            for (PeerStatusListener listener : this.peerListeners) {
                listener.peerOffline(peerAddress, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPeerFail(PeerAddress peerAddress, boolean force) {
        List<PeerStatusListener> list = this.peerListeners;
        synchronized (list) {
            for (PeerStatusListener listener : this.peerListeners) {
                listener.peerFail(peerAddress, force);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPeerOnline(PeerAddress peerAddress) {
        List<PeerStatusListener> list = this.peerListeners;
        synchronized (list) {
            for (PeerStatusListener listener : this.peerListeners) {
                listener.peerOnline(peerAddress);
            }
        }
    }

    public int size() {
        return this.peerCount.get();
    }

    public Number160 self() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer) {
        boolean firstHand;
        boolean bl = firstHand = referrer == null;
        if (firstHand) {
            this.notifyPeerOnline(remotePeer);
            Map<PeerAddress, Log> map = this.peerOfflineLogs;
            synchronized (map) {
                this.peerOfflineLogs.remove(remotePeer);
            }
        }
        if (remotePeer.getID().isZero() || this.self().equals(remotePeer.getID()) || this.isPeerRemovedTemporarly(remotePeer) || this.filteredAddresses.contains(remotePeer.getInetAddress())) {
            return false;
        }
        if (this.updateExistingPeerAddress(remotePeer)) {
            return true;
        }
        if (!this.mapHandler.acceptPeer(firstHand, remotePeer)) {
            return false;
        }
        int classMember = this.classMember(remotePeer.getID());
        Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
        if (this.size() < this.maxPeers) {
            this.prepareInsertOrUpdate(remotePeer, firstHand);
            return this.insertOrUpdate(map, remotePeer, classMember);
        }
        PeerAddress toRemove = this.removeLatestEntryExceedingBagSize();
        if (this.classMember(toRemove.getID()) > this.classMember(remotePeer.getID()) && this.remove(toRemove, PeerStatusListener.Reason.REMOVED_FROM_MAP)) {
            this.prepareInsertOrUpdate(remotePeer, firstHand);
            return this.insertOrUpdate(map, remotePeer, classMember);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peerOffline(PeerAddress remotePeer, boolean force) {
        Log log;
        if (logger.isDebugEnabled()) {
            logger.debug("peer " + remotePeer + " is offline");
        }
        if (remotePeer.getID().isZero() || this.self().equals(remotePeer.getID())) {
            return false;
        }
        this.notifyPeerFail(remotePeer, force);
        Object object = this.peerOfflineLogs;
        synchronized (object) {
            log = this.peerOfflineLogs.get(remotePeer);
            if (log == null) {
                log = new Log();
                this.peerOfflineLogs.put(remotePeer, log);
            }
        }
        object = log;
        synchronized (object) {
            if (!force) {
                if (this.shouldPeerBeRemoved(log)) {
                    this.remove(remotePeer, PeerStatusListener.Reason.NOT_REACHABLE);
                    return true;
                }
                log.inc();
                if (!this.shouldPeerBeRemoved(log)) {
                    this.peerMapStat.removeStat(remotePeer);
                    this.addToMaintenanceQueue(remotePeer);
                    return false;
                }
            } else {
                log.set(this.maxFail);
            }
        }
        this.remove(remotePeer, PeerStatusListener.Reason.NOT_REACHABLE);
        return true;
    }

    private boolean remove(PeerAddress remotePeer, PeerStatusListener.Reason reason) {
        boolean retVal;
        int classMember = this.classMember(remotePeer.getID());
        Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
        boolean bl = retVal = map.remove(remotePeer.getID()) != null;
        if (retVal) {
            this.removeFromMaintenance(remotePeer);
            this.peerCount.decrementAndGet();
            this.notifyRemove(remotePeer);
        }
        this.notifyOffline(remotePeer, reason);
        return retVal;
    }

    private void prepareInsertOrUpdate(PeerAddress remotePeer, boolean firstHand) {
        if (firstHand) {
            this.peerMapStat.setSeenOnlineTime(remotePeer);
            long online = this.peerMapStat.online(remotePeer);
            if (this.maintenanceTimeoutsSeconds.length > 0) {
                long time;
                int checked = this.peerMapStat.getChecked(remotePeer);
                if (checked >= this.maintenanceTimeoutsSeconds.length) {
                    checked = this.maintenanceTimeoutsSeconds.length - 1;
                }
                if (online >= (time = (long)this.maintenanceTimeoutsSeconds[checked] * 1000L)) {
                    this.peerMapStat.incChecked(remotePeer);
                }
            }
        }
        this.addToMaintenanceQueue(remotePeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMaintenanceQueue(PeerAddress remotePeer) {
        long scheduledCheck;
        if (this.maintenanceTimeoutsSeconds.length == 0) {
            return;
        }
        if (this.peerMapStat.getLastSeenOnlineTime(remotePeer) == 0L) {
            scheduledCheck = Timings.currentTimeMillis();
        } else {
            int checked = this.peerMapStat.getChecked(remotePeer);
            if (checked >= this.maintenanceTimeoutsSeconds.length) {
                checked = this.maintenanceTimeoutsSeconds.length - 1;
            }
            scheduledCheck = Timings.currentTimeMillis() + (long)this.maintenanceTimeoutsSeconds[checked] * 1000L;
        }
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            this.maintenance.put(remotePeer, scheduledCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PeerAddress> peersForMaintenance() {
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>();
        long now = Timings.currentTimeMillis();
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            Iterator<Map.Entry<PeerAddress, Long>> iterator = this.maintenance.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PeerAddress, Long> entry = iterator.next();
                if (entry.getValue() > now) continue;
                iterator.remove();
                result.add(entry.getKey());
            }
        }
        for (PeerAddress peerAddress : result) {
            this.addToMaintenanceQueue(peerAddress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMaintenance(PeerAddress peerAddress) {
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            this.maintenance.remove(peerAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertOrUpdate(Map<Number160, PeerAddress> map, PeerAddress remotePeer, int classMember) {
        boolean retVal;
        Map<Number160, PeerAddress> map2 = map;
        synchronized (map2) {
            retVal = !map.containsKey(remotePeer.getID());
            map.put(remotePeer.getID(), remotePeer);
        }
        if (retVal) {
            this.peerCount.incrementAndGet();
            this.notifyInsert(remotePeer);
        } else {
            this.notifyUpdate(remotePeer);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerAddress removeLatestEntryExceedingBagSize() {
        for (int classMember = 159; classMember >= 0; --classMember) {
            Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
            if (map.size() <= this.bagSize) continue;
            long maxValue = Long.MAX_VALUE;
            PeerAddress removePeerAddress = null;
            Map<Number160, PeerAddress> map2 = map;
            synchronized (map2) {
                for (PeerAddress peerAddress : map.values()) {
                    long lastSeenOline = this.peerMapStat.getLastSeenOnlineTime(peerAddress);
                    if (lastSeenOline < maxValue) {
                        maxValue = lastSeenOline;
                        removePeerAddress = peerAddress;
                    }
                    if (maxValue != 0L) continue;
                    break;
                }
            }
            if (removePeerAddress == null) continue;
            return removePeerAddress;
        }
        return null;
    }

    private boolean shouldPeerBeRemoved(Log log) {
        return Timings.currentTimeMillis() - log.getLastOffline() <= (long)this.cacheTimeout && log.getCounter() >= this.maxFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPeerRemovedTemporarly(PeerAddress remotePeer) {
        Log log;
        Object object = this.peerOfflineLogs;
        synchronized (object) {
            log = this.peerOfflineLogs.get(remotePeer);
        }
        if (log != null) {
            object = log;
            synchronized (object) {
                if (this.shouldPeerBeRemoved(log)) {
                    return true;
                }
                if (Timings.currentTimeMillis() - log.getLastOffline() > (long)this.cacheTimeout) {
                    Map<PeerAddress, Log> map = this.peerOfflineLogs;
                    synchronized (map) {
                        this.peerOfflineLogs.remove(remotePeer);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateExistingPeerAddress(PeerAddress peerAddress) {
        Map<Number160, PeerAddress> tmp;
        int classMember = this.classMember(peerAddress.getID());
        Map<Number160, PeerAddress> map = tmp = this.peerMap.get(classMember);
        synchronized (map) {
            if (tmp.containsKey(peerAddress.getID())) {
                tmp.put(peerAddress.getID(), peerAddress);
                return true;
            }
        }
        return false;
    }

    public boolean contains(PeerAddress peerAddress) {
        int classMember = this.classMember(peerAddress.getID());
        if (classMember == -1) {
            return false;
        }
        Map<Number160, PeerAddress> tmp = this.peerMap.get(classMember);
        return tmp.containsKey(peerAddress.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PeerAddress> closePeers(Number160 id, int atLeast) {
        Map<Number160, PeerAddress> map;
        int i;
        Map<Number160, PeerAddress> tmp;
        TreeSet<PeerAddress> set = new TreeSet<PeerAddress>(this.createPeerComparator(id));
        if (this.self().equals(id)) {
            for (int j = 0; set.size() < atLeast && j < 160; ++j) {
                Map<Number160, PeerAddress> tmp2;
                Map<Number160, PeerAddress> map2 = tmp2 = this.peerMap.get(j);
                synchronized (map2) {
                    set.addAll(tmp2.values());
                    continue;
                }
            }
            return set;
        }
        int classMember = this.classMember(id);
        Map<Number160, PeerAddress> map3 = tmp = this.peerMap.get(classMember);
        synchronized (map3) {
            set.addAll(tmp.values());
        }
        if (set.size() >= atLeast) {
            return set;
        }
        for (i = classMember - 1; i >= 0; --i) {
            map = tmp = this.peerMap.get(i);
            synchronized (map) {
                set.addAll(tmp.values());
                continue;
            }
        }
        if (set.size() >= atLeast) {
            return set;
        }
        for (i = classMember + 1; set.size() < atLeast && i < 160; ++i) {
            map = tmp = this.peerMap.get(i);
            synchronized (map) {
                set.addAll(tmp.values());
                continue;
            }
        }
        return set;
    }

    public int isCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.isKadCloser(id, rn, rn2);
    }

    public int isCloser(Number160 id, Number160 rn, Number160 rn2) {
        return PeerMap.distance(id, rn).compareTo(PeerMap.distance(id, rn2));
    }

    public static int isKadCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMap.distance(id, rn.getID()).compareTo(PeerMap.distance(id, rn2.getID()));
    }

    private int classMember(Number160 remoteID) {
        return PeerMap.classMember(this.self(), remoteID);
    }

    static int classMember(Number160 id1, Number160 id2) {
        return PeerMap.distance(id1, id2).bitLength() - 1;
    }

    static Number160 distance(Number160 id1, Number160 id2) {
        return id1.xor(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("I'm node ");
        sb.append(this.self()).append("\n");
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerAddress> tmp = this.peerMap.get(i);
            if (tmp.size() <= 0) continue;
            sb.append("class:").append(i).append("->\n");
            Map<Number160, PeerAddress> map = tmp;
            synchronized (map) {
                for (PeerAddress node : tmp.values()) {
                    sb.append("node:").append(node).append(",");
                }
                continue;
            }
        }
        return sb.toString();
    }

    public static Comparator<PeerAddress> createComparator(final Number160 id) {
        return new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress remotePeer, PeerAddress remotePeer2) {
                return PeerMap.isKadCloser(id, remotePeer, remotePeer2);
            }
        };
    }

    public Comparator<PeerAddress> createPeerComparator(Number160 id) {
        return PeerMap.createComparator(id);
    }

    public Comparator<PeerAddress> createPeerComparator() {
        return this.createPeerComparator(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerAddress> getAll() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerAddress>> i$ = this.peerMap.iterator();
        while (i$.hasNext()) {
            Map<Number160, PeerAddress> map;
            Map<Number160, PeerAddress> map2 = map = i$.next();
            synchronized (map2) {
                all.addAll(map.values());
            }
        }
        return all;
    }

    public void addAddressFilter(InetAddress address) {
        this.filteredAddresses.add(address);
    }

    class Log {
        private int counter;
        private long lastOffline;

        Log() {
        }

        private void inc() {
            ++this.counter;
            this.lastOffline = Timings.currentTimeMillis();
        }

        private void set(int counter) {
            this.counter = counter;
            this.lastOffline = Timings.currentTimeMillis();
        }

        private int getCounter() {
            return this.counter;
        }

        private long getLastOffline() {
            return this.lastOffline;
        }
    }
}

