/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class PutBuilder
extends DHTBuilder<PutBuilder> {
    private Map.Entry<Number160, Data> data;
    private Map<Number160, Data> dataMap;
    private boolean putIfAbsent = false;

    public PutBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Map.Entry<Number160, Data> getData() {
        return this.data;
    }

    public PutBuilder setData(Data data) {
        return this.setData(Number160.ZERO, data);
    }

    public PutBuilder setData(final Number160 key, final Data data) {
        this.data = new Map.Entry<Number160, Data>(){

            @Override
            public Data setValue(Data value) {
                return null;
            }

            @Override
            public Data getValue() {
                return data;
            }

            @Override
            public Number160 getKey() {
                return key;
            }
        };
        return this;
    }

    public PutBuilder setObject(Object object) throws IOException {
        return this.setData(new Data(object));
    }

    public PutBuilder setKeyObject(Number160 contentKey, Object object) throws IOException {
        return this.setData(contentKey, new Data(object));
    }

    public Map<Number160, Data> getDataMap() {
        return this.dataMap;
    }

    public PutBuilder setDataMap(Map<Number160, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public PutBuilder setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
        return this;
    }

    public PutBuilder setPutIfAbsent() {
        this.putIfAbsent = true;
        return this;
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("put-builder");
        if (this.dataMap == null) {
            this.setDataMap(new HashMap<Number160, Data>(1));
        }
        if (this.data != null) {
            this.getDataMap().put(this.getData().getKey(), this.getData().getValue());
        }
        if (this.dataMap.size() == 0) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        final FutureDHT futureDHT = this.peer.getDistributedHashMap().put(this.locationKey, this.domainKey, this.dataMap, this.routingConfiguration, this.requestP2PConfiguration, this.putIfAbsent, this.protectDomain, this.signMessage, this.manualCleanup, this.futureCreate, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
        if (this.directReplication) {
            if (this.defaultDirectReplication == null) {
                this.defaultDirectReplication = new DefaultDirectReplication();
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FutureDHT futureDHTReplication = (FutureDHT)PutBuilder.this.defaultDirectReplication.create();
                    futureDHT.repeated(futureDHTReplication);
                }
            };
            ScheduledFuture<?> tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, this.refreshSeconds, this.refreshSeconds, TimeUnit.SECONDS);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private class DefaultDirectReplication
    implements FutureCreator<FutureDHT> {
        private DefaultDirectReplication() {
        }

        @Override
        public FutureDHT create() {
            FutureChannelCreator futureChannelCreator = PutBuilder.this.peer.reserve(PutBuilder.this.routingConfiguration, PutBuilder.this.requestP2PConfiguration, "submit-builder-direct-replication");
            FutureDHT futureDHT = PutBuilder.this.peer.getDistributedHashMap().put(PutBuilder.this.locationKey, PutBuilder.this.domainKey, PutBuilder.this.dataMap, PutBuilder.this.routingConfiguration, PutBuilder.this.requestP2PConfiguration, PutBuilder.this.putIfAbsent, PutBuilder.this.protectDomain, PutBuilder.this.signMessage, PutBuilder.this.manualCleanup, PutBuilder.this.futureCreate, futureChannelCreator, PutBuilder.this.peer.getConnectionBean().getConnectionReservation());
            return futureDHT;
        }
    }
}

