/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class BroadcastBuilder {
    private final Peer peer;
    private final Number160 messageKey;
    private Map<Number160, Data> dataMap;
    private Boolean isUDP;

    public BroadcastBuilder(Peer peer, Number160 messageKey) {
        this.peer = peer;
        this.messageKey = messageKey;
    }

    public void start() {
        if (this.isUDP == null) {
            if (this.getDataMap() == null) {
                this.setIsUDP(true);
            } else {
                this.setIsUDP(false);
            }
        }
        if (this.dataMap == null) {
            this.setDataMap(new HashMap<Number160, Data>());
        }
        Message message = new Message();
        message.setKey(this.messageKey);
        message.setDataMap(this.dataMap);
        message.setInteger(0);
        message.setUDP();
        this.peer.getBroadcastRPC().getBroadcastHandler().receive(message);
    }

    public Map<Number160, Data> getDataMap() {
        return this.dataMap;
    }

    public BroadcastBuilder setDataMap(Map<Number160, Data> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public boolean isUDP() {
        if (this.isUDP == null) {
            return false;
        }
        return this.isUDP;
    }

    public BroadcastBuilder setIsUDP(boolean isUDP) {
        this.isUDP = isUDP;
        return this;
    }
}

