/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class AddBuilder
extends DHTBuilder<AddBuilder> {
    private Collection<Data> dataSet;
    private Data data;
    private boolean list = false;

    public AddBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Data> getDataSet() {
        return this.dataSet;
    }

    public AddBuilder setDataSet(Collection<Data> dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public Data getData() {
        return this.data;
    }

    public AddBuilder setData(Data data) {
        this.data = data;
        return this;
    }

    public AddBuilder setObject(Object object) throws IOException {
        return this.setData(new Data(object));
    }

    public boolean isList() {
        return this.list;
    }

    public AddBuilder setList(boolean list) {
        this.list = list;
        return this;
    }

    public AddBuilder setList() {
        this.list = true;
        return this;
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("add-builder");
        if (this.dataSet == null) {
            this.dataSet = new ArrayList<Data>(1);
        }
        if (this.data != null) {
            this.dataSet.add(this.data);
        }
        if (this.dataSet.size() == 0) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        final FutureDHT futureDHT = this.peer.getDistributedHashMap().add(this.locationKey, this.domainKey, this.dataSet, this.routingConfiguration, this.requestP2PConfiguration, this.protectDomain, this.signMessage, this.manualCleanup, this.list, this.futureCreate, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
        if (this.directReplication) {
            if (this.defaultDirectReplication == null) {
                this.defaultDirectReplication = new DefaultDirectReplication();
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FutureDHT futureDHTReplication = (FutureDHT)AddBuilder.this.defaultDirectReplication.create();
                    futureDHT.repeated(futureDHTReplication);
                }
            };
            ScheduledFuture<?> tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, this.refreshSeconds, this.refreshSeconds, TimeUnit.SECONDS);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private class DefaultDirectReplication
    implements FutureCreator<FutureDHT> {
        private DefaultDirectReplication() {
        }

        @Override
        public FutureDHT create() {
            FutureChannelCreator futureChannelCreator = AddBuilder.this.peer.reserve(AddBuilder.this.routingConfiguration, AddBuilder.this.requestP2PConfiguration, "submit-builder-direct-replication");
            FutureDHT futureDHT = AddBuilder.this.peer.getDistributedHashMap().add(AddBuilder.this.locationKey, AddBuilder.this.domainKey, AddBuilder.this.dataSet, AddBuilder.this.routingConfiguration, AddBuilder.this.requestP2PConfiguration, AddBuilder.this.protectDomain, AddBuilder.this.signMessage, AddBuilder.this.manualCleanup, AddBuilder.this.list, AddBuilder.this.futureCreate, futureChannelCreator, AddBuilder.this.peer.getConnectionBean().getConnectionReservation());
            return futureDHT;
        }
    }
}

