/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.TrackerConfiguration;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.TrackerData;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTracker {
    private static final Logger logger = LoggerFactory.getLogger(DistributedTracker.class);
    private final DistributedRouting routing;
    private final PeerBean peerBean;
    private final TrackerRPC trackerRPC;
    private final PeerExchangeRPC peerExchangeRPC;
    private final Random rnd;
    private final Number160 stableRandom;

    public DistributedTracker(PeerBean peerBean, DistributedRouting routing, TrackerRPC trackerRPC, PeerExchangeRPC peerExchangeRPC) {
        this.routing = routing;
        this.trackerRPC = trackerRPC;
        this.peerExchangeRPC = peerExchangeRPC;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.getServerPeerAddress().getID().hashCode());
        this.stableRandom = new Number160(this.rnd);
    }

    public FutureTracker getFromTracker(final Number160 locationKey, final Number160 domainKey, final RoutingConfiguration routingConfiguration, final TrackerConfiguration trackerConfiguration, final boolean expectAttachement, EvaluatingSchemeTracker evaluatingScheme, final boolean signMessage, final boolean useSecondaryTrackers, final Set<Number160> knownPeers, FutureChannelCreator futureChannelCreator, final ConnectionReservation connectionReservation) {
        final FutureTracker futureTracker = new FutureTracker(evaluatingScheme, knownPeers);
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    if (useSecondaryTrackers) {
                        Map<Number160, TrackerData> meshPeers = DistributedTracker.this.peerBean.getTrackerStorage().meshPeers(locationKey, domainKey);
                        Map<Number160, TrackerData> secondaryPeers = DistributedTracker.this.peerBean.getTrackerStorage().secondaryPeers(locationKey, domainKey);
                        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(DistributedTracker.this.peerBean.getPeerMap().createPeerComparator(DistributedTracker.this.stableRandom));
                        for (TrackerData trackerData : meshPeers.values()) {
                            secondaryQueue.add(trackerData.getPeerAddress());
                        }
                        for (TrackerData trackerData : secondaryPeers.values()) {
                            secondaryQueue.add(trackerData.getPeerAddress());
                        }
                        DistributedTracker.this.startLoop(locationKey, domainKey, trackerConfiguration, expectAttachement, signMessage, knownPeers, futureTracker, secondaryQueue, futureChannelCreator2.getChannelCreator());
                    } else {
                        final FutureRouting futureRouting = DistributedTracker.this.createRouting(locationKey, domainKey, null, routingConfiguration, Message.Type.REQUEST_3, futureChannelCreator2.getChannelCreator());
                        futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                            @Override
                            public void operationComplete(FutureRouting future) throws Exception {
                                if (futureRouting.isSuccess()) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("found direct hits for tracker get: " + futureRouting.getDirectHits());
                                    }
                                    DistributedTracker.this.startLoop(locationKey, domainKey, trackerConfiguration, expectAttachement, signMessage, knownPeers, futureTracker, futureRouting.getDirectHits(), futureChannelCreator2.getChannelCreator());
                                } else {
                                    futureTracker.setFailed("routing failed");
                                }
                            }
                        });
                    }
                    Utils.addReleaseListenerAll(futureTracker, connectionReservation, futureChannelCreator2.getChannelCreator());
                } else {
                    futureTracker.setFailed(futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void startLoop(final Number160 locationKey, final Number160 domainKey, final TrackerConfiguration trackerConfiguration, final boolean expectAttachement, final boolean signMessage, final Set<Number160> knownPeers, FutureTracker futureTracker, NavigableSet<PeerAddress> queueToAsk, final ChannelCreator cc) {
        this.loop(locationKey, domainKey, queueToAsk, trackerConfiguration, futureTracker, true, knownPeers, new Operation(){

            @Override
            public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                if (logger.isDebugEnabled()) {
                    logger.debug("tracker get: " + remotePeer + " location=" + locationKey + " ");
                }
                FutureResponse futureResponse = DistributedTracker.this.trackerRPC.getFromTracker(remotePeer, locationKey, domainKey, expectAttachement, signMessage, knownPeers, cc, trackerConfiguration.isForceUPD(), trackerConfiguration.isForceTCP());
                if (logger.isDebugEnabled()) {
                    futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                        @Override
                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                logger.debug("found the following peers: " + future.getResponse().getTrackerData());
                            } else {
                                logger.debug("failed to find peers: " + future.getFailedReason());
                            }
                        }
                    });
                }
                return futureResponse;
            }
        });
    }

    public FutureLateJoin<FutureResponse> startPeerExchange(final Number160 locationKey, final Number160 domainKey, FutureChannelCreator futureChannelCreator, final ConnectionReservation connectionReservation, final boolean forceTCP) {
        Map<Number160, TrackerData> activePeers = this.peerBean.getTrackerStorage().activePeers(locationKey, domainKey);
        final Map<Number160, TrackerData> activePeers2 = Utils.limitRandom(activePeers, 35);
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(activePeers2.size());
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    for (TrackerData data : activePeers2.values()) {
                        FutureResponse futureResponses = DistributedTracker.this.peerExchangeRPC.peerExchange(data.getPeerAddress(), locationKey, domainKey, false, future.getChannelCreator(), forceTCP);
                        if (futureLateJoin.add(futureResponses)) continue;
                        break;
                    }
                    Utils.addReleaseListenerAll(futureLateJoin, connectionReservation, future.getChannelCreator());
                } else {
                    futureLateJoin.setFailed(future);
                }
            }
        });
        return futureLateJoin;
    }

    public FutureTracker addToTracker(final Number160 locationKey, final Number160 domainKey, final byte[] attachment, final RoutingConfiguration routingConfiguration, final TrackerConfiguration trackerConfiguration, final boolean signMessage, FutureCreate<BaseFuture> futureCreate, final Set<Number160> knownPeers, FutureChannelCreator futureChannelCreator, final ConnectionReservation connectionReservation) {
        final FutureTracker futureTracker = new FutureTracker(futureCreate);
        futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(final FutureChannelCreator futureChannelCreator2) throws Exception {
                if (futureChannelCreator2.isSuccess()) {
                    final FutureRouting futureRouting = DistributedTracker.this.createRouting(locationKey, domainKey, null, routingConfiguration, Message.Type.REQUEST_1, futureChannelCreator2.getChannelCreator());
                    futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                        @Override
                        public void operationComplete(FutureRouting future) throws Exception {
                            if (futureRouting.isSuccess()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("found potential hits for tracker add: " + futureRouting.getPotentialHits());
                                }
                                DistributedTracker.this.loop(locationKey, domainKey, futureRouting.getPotentialHits(), trackerConfiguration, futureTracker, false, knownPeers, new Operation(){

                                    @Override
                                    public FutureResponse create(PeerAddress remotePeer, boolean primary) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("tracker add (me=" + DistributedTracker.this.peerBean.getServerPeerAddress() + "): " + remotePeer + " location=" + locationKey);
                                        }
                                        return DistributedTracker.this.trackerRPC.addToTracker(remotePeer, locationKey, domainKey, attachment, signMessage, primary, knownPeers, futureChannelCreator2.getChannelCreator(), trackerConfiguration.isForceUPD(), trackerConfiguration.isForceTCP());
                                    }
                                });
                            } else {
                                futureTracker.setFailed("routing failed");
                            }
                        }
                    });
                    Utils.addReleaseListenerAll(futureTracker, connectionReservation, futureChannelCreator2.getChannelCreator());
                } else {
                    futureTracker.setFailed(futureChannelCreator2);
                }
            }
        });
        return futureTracker;
    }

    private void loop(Number160 locationKey, Number160 domainKey, NavigableSet<PeerAddress> queueToAsk, TrackerConfiguration trackerConfiguration, FutureTracker futureTracker, boolean isGet, Set<Number160> knownPeers, Operation operation) {
        FutureResponse[] futureResponses = new FutureResponse[trackerConfiguration.getParallel()];
        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(this.peerBean.getPeerMap().createPeerComparator(this.stableRandom));
        this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, new HashSet<PeerAddress>(), new HashSet<PeerAddress>(), new HashMap<PeerAddress, Collection<TrackerData>>(), operation, trackerConfiguration.getParallel(), new AtomicInteger(0), trackerConfiguration.getMaxFailure(), new AtomicInteger(0), trackerConfiguration.getMaxFullTrackers(), new AtomicInteger(0), trackerConfiguration.getAtLeastSucessfulRequestes(), trackerConfiguration.getAtLeastEntriesFromTrackers(), new AtomicInteger(0), trackerConfiguration.getMaxPrimaryTrackers(), futureResponses, futureTracker, knownPeers, isGet);
    }

    private void loopRec(final Number160 locationKey, final Number160 domainKey, final NavigableSet<PeerAddress> queueToAsk, final NavigableSet<PeerAddress> secondaryQueue, final Set<PeerAddress> alreadyAsked, final Set<PeerAddress> successAsked, final Map<PeerAddress, Collection<TrackerData>> peerOnTracker, final Operation operation, final int parallel, final AtomicInteger nrFailures, final int maxFailures, final AtomicInteger trackerFull, final int maxTrackerFull, final AtomicInteger successfulRequests, final int atLeastSuccessfullRequests, final int atLeastEntriesFromTrackers, final AtomicInteger primaryTracker, final int maxPrimaryTracker, final FutureResponse[] futureResponses, final FutureTracker futureTracker, final Set<Number160> knownPeers, final boolean isGet) {
        final boolean cancelOnFinish = isGet;
        if (logger.isDebugEnabled()) {
            logger.debug("we can ask " + queueToAsk.size() + " primary, and " + secondaryQueue.size() + " secondary.");
        }
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses[i] == null) {
                boolean primary = true;
                PeerAddress next = null;
                if (primaryTracker.incrementAndGet() <= maxPrimaryTracker) {
                    next = isGet ? Utils.pollRandom(queueToAsk, this.rnd) : queueToAsk.pollFirst();
                }
                if (next == null) {
                    next = isGet ? Utils.pollRandom(secondaryQueue, this.rnd) : secondaryQueue.pollFirst();
                    primary = false;
                }
                if (next == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("we are about to ask " + next);
                }
                alreadyAsked.add(next);
                ++active;
                futureResponses[i] = operation.create(next, primary);
                continue;
            }
            if (futureResponses[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("we finished1, we asked " + alreadyAsked.size() + ", but we could ask " + queueToAsk.size() + " more nodes " + alreadyAsked);
            }
            queueToAsk.addAll(secondaryQueue);
            futureTracker.setTrackers(queueToAsk, successAsked, peerOnTracker);
            DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
            return;
        }
        FutureForkJoin fp = new FutureForkJoin(1, false, (BaseFuture[])futureResponses);
        fp.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean isPartial;
                boolean finished = false;
                FutureResponse futureResponse = future.getLast();
                boolean isFull = futureResponse != null && futureResponse.getResponse() != null && futureResponse.getResponse().getType() == Message.Type.DENIED;
                boolean bl = isPartial = futureResponse != null && futureResponse.getResponse() != null && futureResponse.getResponse().getType() == Message.Type.PARTIALLY_OK;
                if (future.isSuccess() || isFull) {
                    if (!isFull) {
                        successAsked.add(futureResponse.getRequest().getRecipient());
                    }
                    Collection<TrackerData> newDataMap = futureResponse.getResponse().getTrackerData();
                    Collection newPeers = DistributedTracker.convert(newDataMap);
                    DistributedTracker.mergeDiff(secondaryQueue, newPeers, alreadyAsked, queueToAsk);
                    DistributedTracker.storeResult(peerOnTracker, newDataMap, futureResponse.getRequest().getRecipient(), knownPeers);
                    int successRequests = isFull ? successfulRequests.get() : successfulRequests.incrementAndGet();
                    finished = DistributedTracker.this.evaluate(peerOnTracker, successRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, isGet);
                    if (logger.isDebugEnabled()) {
                        logger.debug("evaluation result: finished=" + finished + ", " + peerOnTracker.size() + " / " + atLeastEntriesFromTrackers);
                    }
                    if (!finished && isPartial && TrackerRPC.isPrimary(futureResponse)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("partial1: " + futureResponse.getRequest().getRecipient());
                        }
                        queueToAsk.add(futureResponse.getRequest().getRecipient());
                    }
                    if (!finished && isPartial && TrackerRPC.isSecondary(futureResponse)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("partial2: " + futureResponse.getRequest().getRecipient());
                        }
                        secondaryQueue.add(futureResponse.getRequest().getRecipient());
                    }
                    if (!finished && isFull) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("tracker reported to be full. Check if finished due to full trackers.");
                        }
                        finished = trackerFull.incrementAndGet() >= maxTrackerFull;
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("no success " + future.getFailedReason());
                    }
                    boolean bl2 = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    HashSet<PeerAddress> potentialTrackers = new HashSet<PeerAddress>(queueToAsk);
                    potentialTrackers.addAll(secondaryQueue);
                    if (logger.isDebugEnabled()) {
                        logger.debug("we finished2, we asked " + alreadyAsked.size() + ", but we could ask " + queueToAsk.size() + " more nodes (" + successfulRequests + "/" + atLeastSuccessfullRequests + ")");
                    }
                    futureTracker.setTrackers(potentialTrackers, successAsked, peerOnTracker);
                    DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
                } else {
                    DistributedTracker.this.loopRec(locationKey, domainKey, queueToAsk, secondaryQueue, alreadyAsked, successAsked, peerOnTracker, operation, parallel, nrFailures, maxFailures, trackerFull, maxTrackerFull, successfulRequests, atLeastSuccessfullRequests, atLeastEntriesFromTrackers, primaryTracker, maxPrimaryTracker, futureResponses, futureTracker, knownPeers, isGet);
                }
            }
        });
    }

    private boolean evaluate(Map<?, ?> peerOnTracker, int successfulRequests, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers, boolean isGet) {
        if (isGet) {
            return successfulRequests >= atLeastSuccessfulRequests || peerOnTracker.size() >= atLeastEntriesFromTrackers;
        }
        return successfulRequests >= atLeastSuccessfulRequests;
    }

    private FutureRouting createRouting(Number160 locationKey, Number160 domainKey, Set<Number160> contentKeys, RoutingConfiguration routingConfiguration, Message.Type type, ChannelCreator channelCreator) {
        return this.routing.route(locationKey, domainKey, contentKeys, type, routingConfiguration.getDirectHits(), routingConfiguration.getMaxNoNewInfo(0), routingConfiguration.getMaxFailures(), routingConfiguration.getMaxSuccess(), routingConfiguration.getParallel(), routingConfiguration.isForceTCP(), channelCreator);
    }

    private static void storeResult(Map<PeerAddress, Collection<TrackerData>> peerOnTracker, Collection<TrackerData> newDataMap, PeerAddress newDataProvider, Set<Number160> knownPeers) {
        knownPeers.add(newDataProvider.getID());
        for (TrackerData data : newDataMap) {
            PeerAddress peer = data.getPeerAddress();
            knownPeers.add(peer.getID());
            Collection<TrackerData> peerOnTrackerEntry = peerOnTracker.get(newDataProvider);
            if (peerOnTrackerEntry == null) {
                peerOnTrackerEntry = new HashSet<TrackerData>();
                peerOnTracker.put(newDataProvider, peerOnTrackerEntry);
            }
            peerOnTrackerEntry.add(data);
        }
    }

    private static boolean mergeDiff(Set<PeerAddress> queueToAsk, Collection<PeerAddress> newPeers, Collection<PeerAddress> knownPeers1, Collection<PeerAddress> knownPeers2) {
        Collection<PeerAddress> result = Utils.difference(newPeers, new ArrayList(), knownPeers1, knownPeers2);
        return queueToAsk.addAll(result);
    }

    private static Collection<PeerAddress> convert(Collection<TrackerData> trackerData) {
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>(trackerData.size());
        for (TrackerData data : trackerData) {
            result.add(data.getPeerAddress());
        }
        return result;
    }

    public static interface Operation {
        public FutureResponse create(PeerAddress var1, boolean var2);
    }
}

