/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.ConcurrentCacheMap;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcastHandler
implements BroadcastHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBroadcastHandler.class);
    private static final Set<Number160> DEBUG_COUNTER = new HashSet<Number160>();
    private static final int NR = 10;
    private static final int MAX_HOP_COUNT = 7;
    private final Peer peer;
    private final Random rnd;
    private final ConcurrentCacheMap<Number160, Boolean> cache = new ConcurrentCacheMap();

    public DefaultBroadcastHandler(Peer peer, Random rnd) {
        this.peer = peer;
        this.rnd = rnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBroadcastCounter() {
        Set<Number160> set = DEBUG_COUNTER;
        synchronized (set) {
            return DEBUG_COUNTER.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) {
        Number160 messageKey = message.getKey();
        Map<Number160, Data> dataMap = message.getDataMap();
        int hopCount = message.getInteger();
        if (this.twiceSeen(messageKey)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("got broadcast map " + dataMap + " from " + this.peer.getPeerID());
        }
        Set<Number160> set = DEBUG_COUNTER;
        synchronized (set) {
            DEBUG_COUNTER.add(this.peer.getPeerID());
        }
        if (hopCount < 7) {
            if (hopCount == 0) {
                this.firstPeer(messageKey, dataMap, hopCount, message.isUDP());
            } else {
                this.otherPeer(messageKey, dataMap, hopCount, message.isUDP());
            }
        }
    }

    private boolean twiceSeen(Number160 messageKey) {
        Boolean isInCache = this.cache.putIfAbsent(messageKey, Boolean.TRUE);
        if (isInCache != null) {
            if (isInCache.booleanValue()) {
                this.cache.put(messageKey, false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void firstPeer(final Number160 messageKey, final Map<Number160, Data> dataMap, final int hopCounter, final boolean isUDP) {
        List<PeerAddress> list = this.peer.getPeerBean().getPeerMap().getAll();
        for (final PeerAddress peerAddress : list) {
            this.peer.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse futureResponse = DefaultBroadcastHandler.this.peer.getBroadcastRPC().send(peerAddress, messageKey, dataMap, hopCounter + 1, future.getChannelCreator(), DefaultBroadcastHandler.this.peer.getConnectionBean().getConfiguration().getIdleTCPMillis(), isUDP);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("1st broadcast to " + peerAddress);
                        }
                        Utils.addReleaseListener(futureResponse, DefaultBroadcastHandler.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                    }
                }
            });
        }
    }

    private void otherPeer(final Number160 messageKey, final Map<Number160, Data> dataMap, final int hopCounter, final boolean isUDP) {
        LOG.debug("other");
        final List<PeerAddress> list = this.peer.getPeerBean().getPeerMap().getAll();
        final int max = Math.min(10, list.size());
        this.peer.getConnectionBean().getConnectionReservation().reserve(max).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                LOG.debug("other2");
                if (future.isSuccess()) {
                    for (int i = 0; i < max; ++i) {
                        PeerAddress randomAddress = (PeerAddress)list.remove(DefaultBroadcastHandler.this.rnd.nextInt(list.size()));
                        FutureResponse futureResponse = DefaultBroadcastHandler.this.peer.getBroadcastRPC().send(randomAddress, messageKey, dataMap, hopCounter + 1, future.getChannelCreator(), DefaultBroadcastHandler.this.peer.getConnectionBean().getConfiguration().getIdleTCPMillis(), isUDP);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("2nd broadcast to " + randomAddress);
                        }
                        Utils.addReleaseListener(futureResponse, DefaultBroadcastHandler.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                    }
                }
            }
        });
    }
}

