/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;

public class RemoveBuilder
extends DHTBuilder<RemoveBuilder> {
    private Collection<Number160> contentKeys;
    private Number160 contentKey;
    private int repetitions = 5;
    private boolean all = false;
    private boolean returnResults = false;

    public RemoveBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Number160> getContentKeys() {
        return this.contentKeys;
    }

    public RemoveBuilder setContentKeys(Collection<Number160> contentKeys) {
        this.contentKeys = contentKeys;
        return this;
    }

    public Number160 getContentKey() {
        return this.contentKey;
    }

    public RemoveBuilder setContentKey(Number160 contentKey) {
        this.contentKey = contentKey;
        return this;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public RemoveBuilder setRepetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    public RemoveBuilder setAll(boolean all) {
        this.all = all;
        return this;
    }

    public RemoveBuilder setAll() {
        this.all = true;
        return this;
    }

    public boolean isReturnResults() {
        return this.returnResults;
    }

    public RemoveBuilder setReturnResults(boolean returnResults) {
        this.returnResults = returnResults;
        return this;
    }

    public RemoveBuilder setReturnResults() {
        this.returnResults = true;
        return this;
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("remove-builder");
        if (this.all) {
            this.contentKeys = null;
        } else if (this.contentKeys == null && !this.all) {
            this.contentKeys = new ArrayList<Number160>(1);
            if (this.contentKey == null) {
                this.contentKey = Number160.ZERO;
            }
            this.contentKeys.add(this.contentKey);
        }
        final FutureDHT futureDHT = this.peer.getDistributedHashMap().remove(this.locationKey, this.domainKey, this.contentKeys, this.routingConfiguration, this.requestP2PConfiguration, this.returnResults, this.signMessage, this.manualCleanup, this.futureCreate, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
        if (this.directReplication) {
            if (this.defaultDirectReplication == null) {
                this.defaultDirectReplication = new DefaultDirectReplication();
            }
            Runnable runner = new Runnable(){
                private int counter = 0;

                @Override
                public void run() {
                    if (this.counter < RemoveBuilder.this.repetitions) {
                        FutureDHT futureDHTReplication = (FutureDHT)RemoveBuilder.this.defaultDirectReplication.create();
                        futureDHT.repeated(futureDHTReplication);
                        ++this.counter;
                        ScheduledFuture<?> tmp = RemoveBuilder.this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().schedule(this, (long)RemoveBuilder.this.refreshSeconds, TimeUnit.SECONDS);
                        RemoveBuilder.this.setupCancel(futureDHT, tmp);
                    }
                }
            };
            ScheduledFuture<?> tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().schedule(runner, (long)this.refreshSeconds, TimeUnit.SECONDS);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private class DefaultDirectReplication
    implements FutureCreator<FutureDHT> {
        private DefaultDirectReplication() {
        }

        @Override
        public FutureDHT create() {
            FutureChannelCreator futureChannelCreator = RemoveBuilder.this.peer.reserve(RemoveBuilder.this.routingConfiguration, RemoveBuilder.this.requestP2PConfiguration, "remove-builder-direct-replication");
            FutureDHT futureDHT = RemoveBuilder.this.peer.getDistributedHashMap().remove(RemoveBuilder.this.locationKey, RemoveBuilder.this.domainKey, RemoveBuilder.this.contentKeys, RemoveBuilder.this.routingConfiguration, RemoveBuilder.this.requestP2PConfiguration, RemoveBuilder.this.returnResults, RemoveBuilder.this.signMessage, RemoveBuilder.this.manualCleanup, RemoveBuilder.this.futureCreate, futureChannelCreator, RemoveBuilder.this.peer.getConnectionBean().getConnectionReservation());
            return futureDHT;
        }
    }
}

