/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.TrackerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;

public class AddTrackerBuilder
extends TrackerBuilder<AddTrackerBuilder> {
    private byte[] attachement;
    private int trackerTimeoutSec = 60;
    private int pexWaitSec = 0;
    private SimpleBloomFilter<Number160> bloomFilter;
    private FutureCreate<BaseFuture> futureCreate;
    private FutureCreator<FutureTracker> defaultDirectReplication;
    private FutureCreator<FutureLateJoin<FutureResponse>> defaultPEX;
    private boolean messageSign = false;
    private boolean tcpPEX = false;

    public AddTrackerBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public byte[] getAttachement() {
        return this.attachement;
    }

    public AddTrackerBuilder setAttachement(byte[] attachement) {
        this.attachement = attachement;
        return this;
    }

    public int getTrackerTimeoutSec() {
        return this.trackerTimeoutSec;
    }

    public AddTrackerBuilder setTrackerTimeoutSec(int trackerTimeoutSec) {
        this.trackerTimeoutSec = trackerTimeoutSec;
        return this;
    }

    public int getPexWaitSec() {
        return this.pexWaitSec;
    }

    public AddTrackerBuilder setPexWaitSec(int pexWaitSec) {
        this.pexWaitSec = pexWaitSec;
        return this;
    }

    public SimpleBloomFilter<Number160> getBloomFilter() {
        return this.bloomFilter;
    }

    public AddTrackerBuilder setBloomFilter(SimpleBloomFilter<Number160> bloomFilter) {
        this.bloomFilter = bloomFilter;
        return this;
    }

    public FutureCreate<BaseFuture> getFutureCreate() {
        return this.futureCreate;
    }

    public AddTrackerBuilder setFutureCreate(FutureCreate<BaseFuture> futureCreate) {
        this.futureCreate = futureCreate;
        return this;
    }

    public FutureCreator<FutureTracker> getDefaultDirectReplication() {
        return this.defaultDirectReplication;
    }

    public AddTrackerBuilder setDefaultDirectReplication(FutureCreator<FutureTracker> defaultDirectReplication) {
        this.defaultDirectReplication = defaultDirectReplication;
        return this;
    }

    public FutureCreator<FutureLateJoin<FutureResponse>> getDefaultPEX() {
        return this.defaultPEX;
    }

    public AddTrackerBuilder setDefaultPEX(FutureCreator<FutureLateJoin<FutureResponse>> defaultPEX) {
        this.defaultPEX = defaultPEX;
        return this;
    }

    public boolean isMessageSign() {
        return this.messageSign;
    }

    public AddTrackerBuilder setMessageSign() {
        this.messageSign = true;
        return this;
    }

    public AddTrackerBuilder setMessageSign(boolean messageSign) {
        this.messageSign = messageSign;
        return this;
    }

    public boolean isTcpPEX() {
        return this.tcpPEX;
    }

    public AddTrackerBuilder setTcpPEX() {
        this.tcpPEX = true;
        return this;
    }

    public AddTrackerBuilder setTcpPEX(boolean tcpPEX) {
        this.tcpPEX = tcpPEX;
        return this;
    }

    @Override
    public FutureTracker start() {
        ScheduledFuture<?> tmp;
        Runnable runner;
        if (this.peer.isShutdown()) {
            return FUTURE_TRACKER_SHUTDOWN;
        }
        this.preBuild("add-tracker-build");
        if (this.bloomFilter == null) {
            this.bloomFilter = new SimpleBloomFilter(1024, 1024);
        }
        this.peer.getPeerBean().getTrackerStorage().put(this.locationKey, this.domainKey, this.peer.getPeerAddress(), this.peer.getPeerBean().getKeyPair().getPublic(), this.attachement);
        final FutureTracker futureTracker = this.peer.getDistributedTracker().addToTracker(this.locationKey, this.domainKey, this.attachement, this.routingConfiguration, this.trackerConfiguration, this.messageSign, this.futureCreate, this.bloomFilter, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
        if (this.trackerTimeoutSec > 0) {
            if (this.defaultDirectReplication == null) {
                this.defaultDirectReplication = new DefaultDirectReplication();
            }
            runner = new Runnable(){

                @Override
                public void run() {
                    FutureTracker futureTracker2 = (FutureTracker)AddTrackerBuilder.this.defaultDirectReplication.create();
                    futureTracker.repeated(futureTracker2);
                }
            };
            tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, this.trackerTimeoutSec / 2, this.trackerTimeoutSec / 2, TimeUnit.SECONDS);
            this.setupCancel(futureTracker, tmp);
        }
        if (this.pexWaitSec > 0) {
            if (this.defaultPEX == null) {
                this.defaultPEX = new DefaultPEX();
            }
            runner = new Runnable(){

                @Override
                public void run() {
                    FutureLateJoin future = (FutureLateJoin)AddTrackerBuilder.this.defaultPEX.create();
                    futureTracker.repeated(future);
                }
            };
            tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, this.pexWaitSec, this.pexWaitSec, TimeUnit.SECONDS);
            this.setupCancel(futureTracker, tmp);
        }
        return futureTracker;
    }

    protected void setupCancel(FutureCleanup futureCleanup, final ScheduledFuture<?> future) {
        this.peer.getScheduledFutures().add(future);
        futureCleanup.addCleanup(new Cancellable(){

            @Override
            public void cancel() {
                future.cancel(true);
                AddTrackerBuilder.this.peer.getScheduledFutures().remove(future);
            }
        });
    }

    private class DefaultPEX
    implements FutureCreator<FutureLateJoin<FutureResponse>> {
        private DefaultPEX() {
        }

        @Override
        public FutureLateJoin<FutureResponse> create() {
            FutureChannelCreator futureChannelCreator = AddTrackerBuilder.this.peer.getConnectionBean().getConnectionReservation().reserve(35);
            FutureLateJoin<FutureResponse> futureLateJoin = AddTrackerBuilder.this.peer.getDistributedTracker().startPeerExchange(AddTrackerBuilder.this.locationKey, AddTrackerBuilder.this.domainKey, futureChannelCreator, AddTrackerBuilder.this.peer.getConnectionBean().getConnectionReservation(), AddTrackerBuilder.this.tcpPEX);
            return futureLateJoin;
        }
    }

    private class DefaultDirectReplication
    implements FutureCreator<FutureTracker> {
        private DefaultDirectReplication() {
        }

        @Override
        public FutureTracker create() {
            int conn = Math.max(AddTrackerBuilder.this.routingConfiguration.getParallel(), AddTrackerBuilder.this.trackerConfiguration.getParallel());
            FutureChannelCreator futureChannelCreator = AddTrackerBuilder.this.peer.getConnectionBean().getConnectionReservation().reserve(conn);
            FutureTracker futureTracker = AddTrackerBuilder.this.peer.getDistributedTracker().addToTracker(AddTrackerBuilder.this.locationKey, AddTrackerBuilder.this.domainKey, AddTrackerBuilder.this.getAttachement(), AddTrackerBuilder.this.routingConfiguration, AddTrackerBuilder.this.trackerConfiguration, AddTrackerBuilder.this.isMessageSign(), AddTrackerBuilder.this.futureCreate, AddTrackerBuilder.this.getBloomFilter(), futureChannelCreator, AddTrackerBuilder.this.peer.getConnectionBean().getConnectionReservation());
            return futureTracker;
        }
    }
}

