/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.tomp2p.message.DataCodec;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.ProtocolChunked;
import net.tomp2p.message.ProtocolChunkedInput;
import net.tomp2p.message.SHA1Signature;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.HashData;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerData;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class MessageCodec {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int MAX_BYTE = 255;
    public static final int HEADER_SIZE = 56;

    public static ChannelBuffer encodeHeader(ChannelBuffer buffer, Message message) {
        buffer.writeInt(message.getVersion());
        buffer.writeInt(message.getMessageId());
        buffer.writeByte(message.getType().ordinal() << 4 | message.getCommand().ordinal());
        buffer.writeBytes(message.getSender().getID().toByteArray());
        buffer.writeShort((int)((short)message.getSender().portTCP()));
        buffer.writeShort((int)((short)message.getSender().portUDP()));
        buffer.writeBytes(message.getRecipient().getID().toByteArray());
        int content = message.getContentType4().ordinal() << 12 | message.getContentType3().ordinal() << 8 | message.getContentType2().ordinal() << 4 | message.getContentType1().ordinal();
        buffer.writeShort((int)((short)content));
        int options = message.getSender().getOptions() << 4 | message.getOptions();
        buffer.writeByte(options);
        return buffer;
    }

    public static void encodePayload(Message message, ProtocolChunkedInput input) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, ClassNotFoundException, IOException {
        int contentLength = 0;
        if (message.getContentType1() != Message.Content.EMPTY) {
            contentLength += MessageCodec.encodePayloadType(message.getContentType1(), input, message);
            if (message.getContentType2() != Message.Content.EMPTY) {
                contentLength += MessageCodec.encodePayloadType(message.getContentType2(), input, message);
                if (message.getContentType3() != Message.Content.EMPTY) {
                    contentLength += MessageCodec.encodePayloadType(message.getContentType3(), input, message);
                    if (message.getContentType4() != Message.Content.EMPTY) {
                        contentLength += MessageCodec.encodePayloadType(message.getContentType4(), input, message);
                    }
                }
            }
        }
        if (message.isHintSign()) {
            input.addMarkerForSignature();
        } else {
            input.flush(true);
        }
        message.setLength(contentLength);
    }

    private static int encodePayloadType(Message.Content content, ProtocolChunked input, Message message) throws ClassNotFoundException, IOException {
        switch (content) {
            case KEY: {
                input.copyToCurrent(message.getKey().toByteArray());
                return 20;
            }
            case KEY_KEY: {
                input.copyToCurrent(message.getKeyKey1().toByteArray());
                input.copyToCurrent(message.getKeyKey2().toByteArray());
                return 40;
            }
            case MAP_KEY480_DATA: {
                int count = 4;
                Map<Number480, Data> dataMap480 = message.getDataMap480();
                input.copyToCurrent(dataMap480.size());
                for (Map.Entry<Number480, Data> entry : dataMap480.entrySet()) {
                    input.copyToCurrent(entry.getKey().getLocationKey().toByteArray());
                    count += 20;
                    input.copyToCurrent(entry.getKey().getDomainKey().toByteArray());
                    count += 20;
                    input.copyToCurrent(entry.getKey().getContentKey().toByteArray());
                    count += 20;
                    count += DataCodec.encodeData(input, entry.getValue());
                }
                return count;
            }
            case MAP_KEY160_DATA: {
                int count = 4;
                if (message.isConvertNumber480to160()) {
                    Map<Number480, Data> dataMap480 = message.getDataMap480();
                    input.copyToCurrent(dataMap480.size());
                    for (Map.Entry<Number480, Data> entry : dataMap480.entrySet()) {
                        input.copyToCurrent(entry.getKey().getContentKey().toByteArray());
                        count += 20;
                        count += DataCodec.encodeData(input, entry.getValue());
                    }
                    return count;
                }
                input.copyToCurrent(message.getDataMap().size());
                for (Map.Entry<Number160, Data> entry : message.getDataMap().entrySet()) {
                    input.copyToCurrent(entry.getKey().toByteArray());
                    count += 20;
                    count += DataCodec.encodeData(input, entry.getValue());
                }
                return count;
            }
            case MAP_KEY_COMPARE_DATA: {
                int count = 4;
                input.copyToCurrent(message.getHashDataMap().size());
                for (Map.Entry<Number160, HashData> entry : message.getHashDataMap().entrySet()) {
                    input.copyToCurrent(entry.getKey().toByteArray());
                    count += 20;
                    input.copyToCurrent(entry.getValue().getHash().toByteArray());
                    count += 20;
                    count += DataCodec.encodeData(input, entry.getValue().getData());
                }
                return count;
            }
            case MAP_KEY_KEY: {
                Map<Number160, Number160> keyMap = message.getKeyMap();
                int size = keyMap.size();
                input.copyToCurrent(size);
                for (Map.Entry<Number160, Number160> entry : keyMap.entrySet()) {
                    input.copyToCurrent(entry.getKey().toByteArray());
                    input.copyToCurrent(entry.getValue().toByteArray());
                }
                return 4 + size * 40;
            }
            case SET_KEY480: {
                Collection<Number480> keys480 = message.getKeys480();
                int size = keys480.size();
                input.copyToCurrent(size);
                for (Number480 key : keys480) {
                    input.copyToCurrent(key.getLocationKey().toByteArray());
                    input.copyToCurrent(key.getDomainKey().toByteArray());
                    input.copyToCurrent(key.getContentKey().toByteArray());
                }
                return 4 + size * 60;
            }
            case SET_KEY160: {
                if (message.isConvertNumber480to160()) {
                    Collection<Number480> keys = message.getKeys480();
                    int size = keys.size();
                    input.copyToCurrent(size);
                    for (Number480 key : keys) {
                        input.copyToCurrent(key.getContentKey().toByteArray());
                    }
                    return 4 + size * 20;
                }
                int size = message.getKeys().size();
                input.copyToCurrent(size);
                for (Number160 key : message.getKeys()) {
                    input.copyToCurrent(key.toByteArray());
                }
                return 4 + size * 20;
            }
            case SET_NEIGHBORS: {
                int count = 1;
                int size = Math.min(message.getNeighbors().size(), Math.min(message.getUseAtMostNeighbors(), 255));
                input.copyToCurrent((byte)size);
                Iterator<PeerAddress> iterator = message.getNeighbors().iterator();
                for (int i = 0; iterator.hasNext() && i < size; ++i) {
                    byte[] data1 = iterator.next().toByteArray();
                    input.copyToCurrent(data1);
                    count += data1.length;
                }
                return count;
            }
            case SET_TRACKER_DATA: {
                int count = 1;
                Collection<TrackerData> trackerDatas = message.getTrackerData();
                input.copyToCurrent((byte)trackerDatas.size());
                for (TrackerData trackerData : trackerDatas) {
                    byte[] data1 = trackerData.getPeerAddress().toByteArray();
                    input.copyToCurrent(data1);
                    count += data1.length;
                    if (trackerData.getAttachement() != null) {
                        input.copyToCurrent((byte)1);
                        input.copyToCurrent(trackerData.getLength());
                        count += 5;
                        input.copyToCurrent(trackerData.getAttachement(), trackerData.getOffset(), trackerData.getLength());
                        count += trackerData.getLength();
                        continue;
                    }
                    input.copyToCurrent((byte)0);
                    ++count;
                }
                return count;
            }
            case CHANNEL_BUFFER: {
                ChannelBuffer tmpBuffer = message.getPayload();
                int size = tmpBuffer.writerIndex();
                input.copyToCurrent(size);
                input.copyToCurrent(tmpBuffer.slice());
                return 4 + size;
            }
            case LONG: {
                input.copyToCurrent(message.getLong());
                return 8;
            }
            case INTEGER: {
                input.copyToCurrent(message.getInteger());
                return 4;
            }
            case PUBLIC_KEY_SIGNATURE: {
                byte[] data = message.getPublicKey().getEncoded();
                int size = data.length;
                input.copyToCurrent((short)size);
                input.copyToCurrent(data);
                message.setHintSign(true);
                return 42 + size;
            }
            case TWO_BLOOM_FILTER: {
                int size2;
                int size1;
                SimpleBloomFilter<Number160> bloomFilter1 = message.getBloomFilter1();
                if (bloomFilter1 != null) {
                    byte[] raw = bloomFilter1.toByteArray();
                    size1 = raw.length;
                    input.copyToCurrent(size1);
                    input.copyToCurrent(raw);
                } else {
                    size1 = 0;
                    input.copyToCurrent(size1);
                }
                SimpleBloomFilter<Number160> bloomFilter2 = message.getBloomFilter2();
                if (bloomFilter2 != null) {
                    byte[] raw = bloomFilter2.toByteArray();
                    size2 = raw.length;
                    input.copyToCurrent(size2);
                    input.copyToCurrent(raw);
                } else {
                    size2 = 0;
                    input.copyToCurrent(size2);
                }
                return 8 + size1 + size2;
            }
        }
        return 0;
    }

    public static Message decodeHeader(ChannelBuffer buffer, InetSocketAddress recipient, InetSocketAddress sender) throws DecoderException {
        Message message = new Message();
        message.setVersion(buffer.readInt());
        message.setMessageId(buffer.readInt());
        short typeCommand = buffer.readUnsignedByte();
        message.setType(Message.Type.values()[typeCommand >>> 4]);
        message.setCommand(Message.Command.values()[typeCommand & 0xF]);
        Number160 senderID = MessageCodec.readID(buffer);
        int portTCP = buffer.readUnsignedShort();
        int portUDP = buffer.readUnsignedShort();
        Number160 recipientID = MessageCodec.readID(buffer);
        message.setRecipient(new PeerAddress(recipientID, recipient));
        int contentType = buffer.readUnsignedShort();
        message.setContentType(Message.Content.values()[contentType & 0xF], Message.Content.values()[contentType >>> 4 & 0xF], Message.Content.values()[contentType >>> 8 & 0xF], Message.Content.values()[contentType >>> 12]);
        short senderMessageOptions = buffer.readUnsignedByte();
        int senderOptions = senderMessageOptions >>> 4;
        PeerAddress peerAddress = new PeerAddress(senderID, sender.getAddress(), portTCP, portUDP, senderOptions);
        message.setSender(peerAddress);
        int options = senderMessageOptions & 0xF;
        message.setOptions(options);
        return message;
    }

    public static boolean decodePayload(Message.Content content, ChannelBuffer buffer, Message message) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, DecoderException {
        switch (content) {
            case KEY: {
                if (buffer.readableBytes() < 20) {
                    return false;
                }
                message.setKey0(MessageCodec.readID(buffer));
                return true;
            }
            case KEY_KEY: {
                if (buffer.readableBytes() < 40) {
                    return false;
                }
                message.setKeyKey0(MessageCodec.readID(buffer), MessageCodec.readID(buffer));
                return true;
            }
            case MAP_KEY480_DATA: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                HashMap<Number480, Data> result480 = new HashMap<Number480, Data>(len);
                for (int i = 0; i < len; ++i) {
                    if (buffer.readableBytes() < 60) {
                        return false;
                    }
                    Number160 locationKey = MessageCodec.readID(buffer);
                    Number160 domainKey = MessageCodec.readID(buffer);
                    Number160 contentKey = MessageCodec.readID(buffer);
                    Data data = DataCodec.decodeData(buffer, message.getSender());
                    if (data == null) {
                        return false;
                    }
                    if (message.isRequest()) {
                        if (data.isProtectedEntry() && message.getPublicKey() == null) {
                            throw new DecoderException("You indicated that you want to protect the data, but you did not provide or provided too late a public key.");
                        }
                        data.setPublicKey(message.getPublicKey());
                    }
                    result480.put(new Number480(locationKey, domainKey, contentKey), data);
                }
                message.setDataMap0480(result480);
                return true;
            }
            case MAP_KEY160_DATA: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                HashMap<Number160, Data> result160 = new HashMap<Number160, Data>(len);
                for (int i = 0; i < len; ++i) {
                    if (buffer.readableBytes() < 20) {
                        return false;
                    }
                    Number160 key = MessageCodec.readID(buffer);
                    Data data = DataCodec.decodeData(buffer, message.getSender());
                    if (data == null) {
                        return false;
                    }
                    if (message.isRequest()) {
                        if (data.isProtectedEntry() && message.getPublicKey() == null) {
                            throw new DecoderException("You indicated that you want to protect the data, but you did not provide or provided too late a public key.");
                        }
                        data.setPublicKey(message.getPublicKey());
                    }
                    result160.put(key, data);
                }
                message.setDataMap0(result160);
                return true;
            }
            case MAP_KEY_COMPARE_DATA: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                HashMap<Number160, HashData> resultHash = new HashMap<Number160, HashData>(len);
                for (int i = 0; i < len; ++i) {
                    if (buffer.readableBytes() < 20) {
                        return false;
                    }
                    Number160 key = MessageCodec.readID(buffer);
                    if (buffer.readableBytes() < 20) {
                        return false;
                    }
                    Number160 hash = MessageCodec.readID(buffer);
                    Data data = DataCodec.decodeData(buffer, message.getSender());
                    if (data == null) {
                        return false;
                    }
                    if (message.isRequest()) {
                        if (data.isProtectedEntry() && message.getPublicKey() == null) {
                            throw new DecoderException("You indicated that you want to protect the data, but you did not provide or provided too late a public key.");
                        }
                        data.setPublicKey(message.getPublicKey());
                    }
                    resultHash.put(key, new HashData(hash, data));
                }
                message.setHashDataMap0(resultHash);
                return true;
            }
            case MAP_KEY_KEY: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < 40 * len) {
                    return false;
                }
                HashMap<Number160, Number160> keyMap = new HashMap<Number160, Number160>();
                for (int i = 0; i < len; ++i) {
                    Number160 key1 = MessageCodec.readID(buffer);
                    Number160 key2 = MessageCodec.readID(buffer);
                    keyMap.put(key1, key2);
                }
                message.setKeyMap0(keyMap);
                return true;
            }
            case SET_KEY480: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < 60 * len) {
                    return false;
                }
                ArrayList<Number480> tmp480 = new ArrayList<Number480>(len);
                for (int i = 0; i < len; ++i) {
                    Number160 locationKey = MessageCodec.readID(buffer);
                    Number160 domainKey = MessageCodec.readID(buffer);
                    Number160 conentKey = MessageCodec.readID(buffer);
                    tmp480.add(new Number480(locationKey, domainKey, conentKey));
                }
                message.setKeys0480(tmp480);
                return true;
            }
            case SET_KEY160: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < 20 * len) {
                    return false;
                }
                ArrayList<Number160> tmp160 = new ArrayList<Number160>(len);
                for (int i = 0; i < len; ++i) {
                    Number160 key = MessageCodec.readID(buffer);
                    tmp160.add(key);
                }
                message.setKeys0(tmp160);
                return true;
            }
            case SET_NEIGHBORS: {
                if (buffer.readableBytes() < 1) {
                    return false;
                }
                int len = buffer.readUnsignedByte();
                if (buffer.readableBytes() < len * 29) {
                    return false;
                }
                ArrayList<PeerAddress> neighbors = new ArrayList<PeerAddress>(len);
                for (int i = 0; i < len; ++i) {
                    PeerAddress peerAddress = MessageCodec.readPeerAddress(buffer);
                    if (peerAddress == null) {
                        return false;
                    }
                    neighbors.add(peerAddress);
                }
                message.setNeighbors0(neighbors);
                return true;
            }
            case SET_TRACKER_DATA: {
                if (buffer.readableBytes() < 1) {
                    return false;
                }
                int len = buffer.readUnsignedByte();
                if (buffer.readableBytes() < len * 30) {
                    return false;
                }
                ArrayList<TrackerData> trackerDatas = new ArrayList<TrackerData>(len);
                for (int i = 0; i < len; ++i) {
                    PeerAddress peerAddress = MessageCodec.readPeerAddress(buffer);
                    if (peerAddress == null) {
                        return false;
                    }
                    byte[] attachment = null;
                    int offset = 0;
                    int length = 0;
                    if (buffer.readableBytes() < 1) {
                        return false;
                    }
                    byte miniHeader = buffer.readByte();
                    if (miniHeader != 0) {
                        if (buffer.readableBytes() < 4) {
                            return false;
                        }
                        length = buffer.readInt();
                        if (buffer.readableBytes() < length) {
                            return false;
                        }
                        attachment = new byte[length];
                        buffer.readBytes(attachment);
                    }
                    trackerDatas.add(new TrackerData(peerAddress, message.getSender(), attachment, offset, length));
                }
                message.setTrackerData0(trackerDatas);
                return true;
            }
            case CHANNEL_BUFFER: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (len == 0) {
                    message.setPayload0(ChannelBuffers.EMPTY_BUFFER);
                    return true;
                }
                if (buffer.readableBytes() < len) {
                    return false;
                }
                ChannelBuffer tmpBuffer = buffer.copy(buffer.readerIndex(), len);
                buffer.skipBytes(len);
                message.setPayload0(tmpBuffer);
                return true;
            }
            case LONG: {
                if (buffer.readableBytes() < 8) {
                    return false;
                }
                message.setLong0(buffer.readLong());
                return true;
            }
            case INTEGER: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                message.setInteger0(buffer.readInt());
                return true;
            }
            case PUBLIC_KEY_SIGNATURE: {
                if (buffer.readableBytes() < 2) {
                    return false;
                }
                int len = buffer.readUnsignedShort();
                byte[] me = new byte[len];
                if (buffer.readableBytes() < len) {
                    return false;
                }
                message.setPublicKey0(MessageCodec.decodePublicKey(buffer, me));
                if (content == Message.Content.PUBLIC_KEY_SIGNATURE) {
                    message.setHintSign(true);
                }
                return true;
            }
            case TWO_BLOOM_FILTER: {
                byte[] me;
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                SimpleBloomFilter<Number160> sbf1 = null;
                if (len > 0) {
                    me = new byte[len];
                    if (buffer.readableBytes() < len) {
                        return false;
                    }
                    buffer.readBytes(me);
                    sbf1 = new SimpleBloomFilter<Number160>(me);
                }
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len2 = buffer.readInt();
                SimpleBloomFilter sbf2 = null;
                if (len2 > 0) {
                    me = new byte[len2];
                    if (buffer.readableBytes() < len2) {
                        return false;
                    }
                    buffer.readBytes(me);
                    sbf2 = new SimpleBloomFilter(me);
                }
                message.setTwoBloomFilter0(sbf1, sbf2);
                return true;
            }
        }
        return true;
    }

    private static Number160 readID(ChannelBuffer buffer) {
        byte[] me = new byte[20];
        buffer.readBytes(me);
        return new Number160(me);
    }

    private static PeerAddress readPeerAddress(ChannelBuffer buffer) {
        if (buffer.readableBytes() < 21) {
            return null;
        }
        Number160 id = MessageCodec.readID(buffer);
        short type = buffer.getUnsignedByte(buffer.readerIndex());
        int len = PeerAddress.expectedSocketLength(type);
        if (buffer.readableBytes() < len) {
            return null;
        }
        PeerAddress peerAddress = new PeerAddress(id, buffer);
        return peerAddress;
    }

    public static PublicKey decodePublicKey(ChannelBuffer buffer, byte[] receivedRawPublicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        buffer.readBytes(receivedRawPublicKey);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(receivedRawPublicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey receivedPublicKey = keyFactory.generatePublic(pubKeySpec);
        return receivedPublicKey;
    }

    public static boolean decodeSignature(Signature signature, Message message, ChannelBuffer buffer) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException {
        Number160 number2;
        if (buffer.readableBytes() < 40) {
            return false;
        }
        Number160 number1 = MessageCodec.readID(buffer);
        SHA1Signature signatureEncode = new SHA1Signature(number1, number2 = MessageCodec.readID(buffer));
        byte[] signatureReceived = signatureEncode.encode();
        if (!signature.verify(signatureReceived)) {
            message.setPublicKey0(null);
        }
        return true;
    }
}

