/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;

public class FutureForkJoin<K extends BaseFuture>
extends BaseFutureImpl<FutureForkJoin<K>>
implements BaseFuture {
    private final K[] forks;
    private final int nrFutures;
    private final int nrFinishFuturesSuccess;
    private final boolean cancelFuturesOnFinish;
    private final List<K> forksCopy = new ArrayList<K>();
    private K last;
    private int counter = 0;
    private int successCounter = 0;
    private volatile boolean completedJoin = false;

    public FutureForkJoin(K ... forks) {
        this(forks.length, false, (BaseFuture[])forks);
    }

    public FutureForkJoin(int nrFinishFuturesSuccess, boolean cancelFuturesOnFinish, K ... forks) {
        this.nrFinishFuturesSuccess = nrFinishFuturesSuccess;
        this.forks = forks;
        this.cancelFuturesOnFinish = cancelFuturesOnFinish;
        this.nrFutures = forks.length;
        if (this.nrFutures <= 0) {
            this.setFailed("We have no futures: " + this.nrFutures);
        } else {
            this.join();
        }
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() {
        for (int i = 0; i < this.nrFutures; ++i) {
            if (this.completedJoin) {
                return;
            }
            final int index = i;
            if (this.forks[index] != null) {
                this.forks[index].addListener(new BaseFutureAdapter<K>(){

                    @Override
                    public void operationComplete(K future) throws Exception {
                        FutureForkJoin.this.evaluate(future, index);
                    }
                });
                continue;
            }
            boolean notifyNow = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.completed) {
                    return;
                }
                if (++this.counter >= this.nrFutures) {
                    notifyNow = this.setFinish(BaseFuture.FutureType.FAILED);
                }
            }
            if (!notifyNow) continue;
            this.notifyListerenrs();
            this.cancelAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(K finished, int index) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.forksCopy.add(finished);
            this.last = finished;
            this.forks[index] = null;
            if (finished.isSuccess() && ++this.successCounter >= this.nrFinishFuturesSuccess) {
                notifyNow = this.setFinish(BaseFuture.FutureType.OK);
            } else if (++this.counter >= this.nrFutures) {
                notifyNow = this.setFinish(BaseFuture.FutureType.FAILED);
            }
        }
        if (notifyNow) {
            this.notifyListerenrs();
            this.cancelAll();
        }
    }

    private void cancelAll() {
        if (this.cancelFuturesOnFinish) {
            for (K future : this.forks) {
                if (future == null) continue;
                future.cancel();
            }
        }
    }

    private boolean setFinish(BaseFuture.FutureType type) {
        if (!this.setCompletedAndNotify()) {
            return false;
        }
        this.completedJoin = true;
        this.type = type;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailedReason() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder("FFJ:").append(this.reason);
            sb.append(", type:").append((Object)this.type);
            if (this.last != null) {
                sb.append(", last:").append(this.last.getFailedReason()).append("rest:");
            }
            for (BaseFuture k : this.getCompleted()) {
                sb.append(",").append(k.getFailedReason());
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K getLast() {
        Object object = this.lock;
        synchronized (object) {
            return this.last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.forksCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuccessCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.successCounter;
        }
    }
}

