/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.PeerException;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Timings;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultExceptionEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyTimeoutHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReplyTimeoutHandler.class);
    private final Timer timer;
    private final long allIdleTimeMillis;
    private final PeerAddress remotePeer;
    private volatile Timeout allIdleTimeout;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;

    public ReplyTimeoutHandler(Timer timer, long timeoutMillis, PeerAddress remotePeer) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timout need to be larger than 0");
        }
        this.timer = timer;
        this.allIdleTimeMillis = timeoutMillis;
        this.remotePeer = remotePeer;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.initialize(ctx);
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.lastReadTime = Timings.currentTimeMillis();
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (e.getWrittenAmount() > 0L) {
            this.lastWriteTime = Timings.currentTimeMillis();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.equals("error in timeout " + e.toString());
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void initialize(ChannelHandlerContext ctx) {
        this.lastReadTime = this.lastWriteTime = Timings.currentTimeMillis();
        if (this.allIdleTimeMillis > 0L) {
            this.allIdleTimeout = this.timer.newTimeout((TimerTask)new AllIdleTimeoutTask(ctx), this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void cancel() {
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel();
        }
        this.allIdleTimeout = null;
    }

    private final class AllIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        private AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout == null) {
                this.ctx.sendUpstream((ChannelEvent)new DefaultExceptionEvent(this.ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, "Shutting down " + ReplyTimeoutHandler.this.remotePeer)));
                return;
            }
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            long currentTime = Timings.currentTimeMillis();
            long lastIoTime = Math.max(ReplyTimeoutHandler.this.lastReadTime, ReplyTimeoutHandler.this.lastWriteTime);
            long nextDelay = ReplyTimeoutHandler.this.allIdleTimeMillis - (currentTime - lastIoTime);
            if (nextDelay <= 0L) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Timeout exception for peer " + ReplyTimeoutHandler.this.remotePeer);
                    }
                    this.ctx.sendUpstream((ChannelEvent)new DefaultExceptionEvent(this.ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.TIMEOUT, "Timeout exception for peer " + ReplyTimeoutHandler.this.remotePeer)));
                }
                catch (Throwable t) {
                    this.ctx.sendUpstream((ChannelEvent)new DefaultExceptionEvent(this.ctx.getChannel(), t));
                }
            } else {
                ReplyTimeoutHandler.this.allIdleTimeout = ReplyTimeoutHandler.this.timer.newTimeout((TimerTask)this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

