/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureChannel;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderTCP;
import net.tomp2p.message.TomP2PEncoderUDP;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelCreator.class);
    private static final FutureChannel FAILED_FUTURE = new FutureChannel();
    private final Semaphore connectionSemaphore;
    private final ChannelGroup channelsTCP = new DefaultChannelGroup("TomP2P ConnectionPool TCP");
    private final ChannelGroup channelsUDP = new DefaultChannelGroup("TomP2P ConnectionPool UDP");
    private final String channelCreatorName;
    private final long creatorThread;
    private final MessageLogger messageLoggerFilter;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final boolean keepAliveAndReuse;
    private final Map<InetSocketAddress, ChannelFuture> cacheMap;
    private final Statistics statistics;
    private final int permits;
    private final Scheduler scheduler;
    private boolean shutdownUDP;
    private boolean shutdownTCP;
    private AtomicInteger permitsCount;

    ChannelCreator(int permits, Statistics statistics, MessageLogger messageLoggerFilter, ChannelFactory tcpClientChannelFactory, ChannelFactory udpClientChannelFactory, boolean keepAliveAndReuse, String name, long creatorThread, Scheduler scheduler) {
        this.permitsCount = new AtomicInteger(permits);
        this.connectionSemaphore = new Semaphore(permits);
        this.cacheMap = new ConcurrentHashMap<InetSocketAddress, ChannelFuture>(permits);
        this.messageLoggerFilter = messageLoggerFilter;
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpClientChannelFactory;
        this.keepAliveAndReuse = keepAliveAndReuse;
        this.statistics = statistics;
        this.channelCreatorName = name;
        this.creatorThread = creatorThread;
        this.permits = permits;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannel createUDPChannel(ReplyTimeoutHandler timeoutHandler, RequestHandlerUDP<? extends BaseFuture> requestHandler, boolean broadcast) {
        ChannelGroup channelGroup = this.channelsUDP;
        synchronized (channelGroup) {
            if (this.shutdownUDP) {
                return FAILED_FUTURE;
            }
            FutureChannel futureChannelCreation = new FutureChannel();
            this.createUDPChannel(futureChannelCreation, timeoutHandler, requestHandler, broadcast);
            return futureChannelCreation;
        }
    }

    private void createUDPChannel(FutureChannel futureChannelCreation, ReplyTimeoutHandler timeoutHandler, RequestHandlerUDP<? extends BaseFuture> requestHandler, boolean broadcast) {
        Channel channel;
        if (!futureChannelCreation.isAcquired() && !this.connectionSemaphore.tryAcquire()) {
            this.connectionNotReadyYetUDP(futureChannelCreation, timeoutHandler, requestHandler, broadcast, this.connectionSemaphore);
            return;
        }
        this.statistics.incrementUDPChannelCreation();
        try {
            channel = this.createChannelUDP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, broadcast);
            futureChannelCreation.setChannel(channel);
        }
        catch (Exception e) {
            futureChannelCreation.setFailed("Cannot create channel " + e);
            this.connectionSemaphore.release();
            this.statistics.decrementUDPChannelCreation();
            return;
        }
        channel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelCreator.this.connectionSemaphore.release();
                ChannelCreator.this.statistics.decrementUDPChannelCreation();
            }
        });
        this.channelsUDP.add((Object)channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureChannel createTCPChannel(ReplyTimeoutHandler timeoutHandler, RequestHandlerTCP<? extends BaseFuture> requestHandler, int connectTimeoutMillis, InetSocketAddress recipient) {
        ChannelGroup channelGroup = this.channelsTCP;
        synchronized (channelGroup) {
            if (this.shutdownTCP) {
                return FAILED_FUTURE;
            }
            FutureChannel futureChannelCreation = new FutureChannel();
            this.createTCPChannel(futureChannelCreation, timeoutHandler, requestHandler, connectTimeoutMillis, recipient);
            return futureChannelCreation;
        }
    }

    private void createTCPChannel(final FutureChannel futureChannelCreation, ReplyTimeoutHandler timeoutHandler, final RequestHandlerTCP<? extends BaseFuture> requestHandler, int connectTimeoutMillis, final InetSocketAddress recipient) {
        Channel channel;
        ChannelFuture channelFuture;
        boolean newConnection = true;
        if (this.keepAliveAndReuse) {
            channelFuture = this.cacheMap.get(recipient);
            if (channelFuture == null) {
                if (!futureChannelCreation.isAcquired() && !this.connectionSemaphore.tryAcquire()) {
                    this.connectionNotReadyYetTCP(futureChannelCreation, timeoutHandler, requestHandler, connectTimeoutMillis, recipient, this.connectionSemaphore);
                    return;
                }
                this.statistics.incrementTCPChannelCreation();
                try {
                    channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
                    futureChannelCreation.setChannelFuture(channelFuture);
                    channelFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                futureChannelCreation.setChannel(future.getChannel());
                            } else {
                                futureChannelCreation.setFailed("ChannelFuture failed (TCP, reuse)", future.getCause());
                                ChannelCreator.this.connectionSemaphore.release();
                                ChannelCreator.this.statistics.decrementTCPChannelCreation();
                            }
                        }
                    });
                    this.cacheMap.put(recipient, channelFuture);
                }
                catch (Exception e) {
                    futureChannelCreation.setFailed("Cannot create channel (TCP, reuse)", e);
                    this.connectionSemaphore.release();
                    this.statistics.decrementTCPChannelCreation();
                    return;
                }
            } else {
                futureChannelCreation.setChannelFuture(channelFuture);
                newConnection = false;
                channel = channelFuture.getChannel();
                channel.getPipeline().replace("request", "request", requestHandler);
                futureChannelCreation.setChannel(channel);
            }
        } else {
            if (!futureChannelCreation.isAcquired() && !this.connectionSemaphore.tryAcquire()) {
                this.connectionNotReadyYetTCP(futureChannelCreation, timeoutHandler, requestHandler, connectTimeoutMillis, recipient, this.connectionSemaphore);
                return;
            }
            this.statistics.incrementTCPChannelCreation();
            try {
                channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
                futureChannelCreation.setChannelFuture(channelFuture);
                channelFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            futureChannelCreation.setChannel(future.getChannel());
                        } else {
                            futureChannelCreation.setFailed("ChannelFuture failed (TCP)", future.getCause());
                            ChannelCreator.this.connectionSemaphore.release();
                            ChannelCreator.this.statistics.decrementTCPChannelCreation();
                        }
                    }
                });
            }
            catch (Exception e) {
                futureChannelCreation.setFailed("Cannot create channel (TCP)", e);
                this.connectionSemaphore.release();
                this.statistics.decrementTCPChannelCreation();
                return;
            }
        }
        channel = channelFuture.getChannel();
        if (newConnection) {
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (LOGGER.isDebugEnabled()) {
                        if (requestHandler.getFutureResponse() != null) {
                            LOGGER.debug("channel close, set failure for request message: " + ((BaseFutureImpl)requestHandler.getFutureResponse()).getFailedReason());
                        } else {
                            LOGGER.debug("channel close");
                        }
                    }
                    ChannelCreator.this.connectionSemaphore.release();
                    ChannelCreator.this.statistics.decrementTCPChannelCreation();
                    if (ChannelCreator.this.keepAliveAndReuse) {
                        ChannelCreator.this.cacheMap.remove(recipient);
                    }
                }
            });
        }
        this.channelsTCP.add((Object)channel);
    }

    private void connectionNotReadyYetTCP(final FutureChannel futureChannelCreation, final ReplyTimeoutHandler timeoutHandler, final RequestHandlerTCP<? extends BaseFuture> requestHandler, final int connectTimeoutMillis, final InetSocketAddress recipient, Semaphore connectionSemaphore2) {
        this.scheduler.addConnectionQueue(futureChannelCreation, connectionSemaphore2, new Runnable(){

            @Override
            public void run() {
                ChannelCreator.this.createTCPChannel(futureChannelCreation, timeoutHandler, requestHandler, connectTimeoutMillis, recipient);
            }
        });
    }

    private void connectionNotReadyYetUDP(final FutureChannel futureChannelCreation, final ReplyTimeoutHandler timeoutHandler, final RequestHandlerUDP<? extends BaseFuture> requestHandler, final boolean broadcast, Semaphore connectionSemaphore2) {
        this.scheduler.addConnectionQueue(futureChannelCreation, connectionSemaphore2, new Runnable(){

            @Override
            public void run() {
                ChannelCreator.this.createUDPChannel(futureChannelCreation, timeoutHandler, requestHandler, broadcast);
            }
        });
    }

    private ChannelFuture createChannelTCP(ChannelHandler timeoutHandler, ChannelHandler requestHandler, SocketAddress remoteAddress, SocketAddress localAddress, int connectionTimoutMillis) {
        ClientBootstrap bootstrap = new ClientBootstrap(this.tcpClientChannelFactory);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectionTimoutMillis);
        ChannelCreator.setupBootstrapTCP((Bootstrap)bootstrap, timeoutHandler, requestHandler, (ChannelUpstreamHandler)new TomP2PDecoderTCP(), new TomP2PEncoderTCP(), new ChunkedWriteHandler(), (ChannelHandler)this.messageLoggerFilter);
        ChannelFuture channelFuture = bootstrap.connect(remoteAddress);
        this.trySetOption(channelFuture.getChannel(), "tcpNoDelay", true);
        this.trySetOption(channelFuture.getChannel(), "soLinger", 0);
        this.trySetOption(channelFuture.getChannel(), "reuseAddress", true);
        this.trySetOption(channelFuture.getChannel(), "keepAlive", true);
        return channelFuture;
    }

    private void trySetOption(Channel channel, String name, Object value) {
        try {
            channel.getConfig().setOption(name, value);
        }
        catch (ChannelException e) {
            // empty catch block
        }
    }

    private Channel createChannelUDP(ChannelHandler timeoutHandler, ChannelHandler requestHandler, boolean allowBroadcast) {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        ChannelCreator.setupBootstrapUDP((Bootstrap)bootstrap, timeoutHandler, requestHandler, new TomP2PDecoderUDP(), new TomP2PEncoderUDP(), (ChannelHandler)this.messageLoggerFilter);
        bootstrap.setOption("broadcast", (Object)(allowBroadcast ? 1 : 0));
        bootstrap.setOption("receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1400));
        Channel c = bootstrap.bind((SocketAddress)new InetSocketAddress(0));
        return c;
    }

    private static void setupBootstrapTCP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChunkedWriteHandler streamer, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("streamer", (ChannelHandler)streamer);
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    private static void setupBootstrapUDP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    public ChannelFuture close(PeerAddress destination) {
        ChannelFuture channelFuture = this.cacheMap.get(destination.createSocketTCP());
        if (channelFuture != null) {
            return channelFuture.getChannel().close();
        }
        return null;
    }

    public int getPermits() {
        return this.permits;
    }

    public int getCurrentPermits() {
        return this.permitsCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean release(int freedPermits) {
        int result = this.permitsCount.addAndGet(-freedPermits);
        if (result < 0) {
            throw new RuntimeException("Cannot release more than I acquired");
        }
        if (result == 0) {
            ChannelGroup channelGroup = this.channelsTCP;
            synchronized (channelGroup) {
                this.shutdownTCP = true;
            }
            channelGroup = this.channelsUDP;
            synchronized (channelGroup) {
                this.shutdownUDP = true;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("shutting down in ChannelCreator");
        }
        ChannelGroup channelGroup = this.channelsTCP;
        synchronized (channelGroup) {
            this.shutdownTCP = true;
        }
        this.channelsTCP.close().awaitUninterruptibly();
        channelGroup = this.channelsUDP;
        synchronized (channelGroup) {
            this.shutdownUDP = true;
        }
        this.channelsUDP.close().awaitUninterruptibly();
    }

    public String getName() {
        return this.channelCreatorName;
    }

    public long getCreatorThread() {
        return this.creatorThread;
    }

    public boolean isKeepAliveAndReuse() {
        return this.keepAliveAndReuse;
    }

    static {
        FAILED_FUTURE.setFailed("shutting down!");
    }
}

