/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Bindings {
    public static final int MAX_PORT = 65535;
    public static final int MIN_DYN_PORT = 49152;
    public static final int DEFAULT_PORT = 7700;
    private static final Random RND = new Random();
    private static final int RANGE = 16383;
    private final List<InetAddress> listenAddresses = new ArrayList<InetAddress>(1);
    private final List<String> listenInterfaceHints = new ArrayList<String>(1);
    private final Protocol listenProtocolHint;
    private final InetAddress externalAddress;
    private final int externalTCPPort;
    private final int externalUDPPort;
    private final boolean setExternalPortsManually;
    private final List<InetAddress> foundBroadcastAddresses = new ArrayList<InetAddress>(1);
    private final List<Inet4Address> foundAddresses4 = new ArrayList<Inet4Address>(1);
    private final List<Inet6Address> foundAddresses6 = new ArrayList<Inet6Address>(1);

    public Bindings() {
        this(Protocol.Any, null, 0, 0);
    }

    public Bindings(InetAddress bind) {
        this(Protocol.Any, null, 0, 0);
        this.addAddress(bind);
    }

    public Bindings(String iface) {
        this(Protocol.Any, null, 0, 0);
        this.addInterface(iface);
    }

    public Bindings(Protocol protocol) {
        this(protocol, null, 0, 0);
    }

    public Bindings(Protocol protocol, String iface) {
        this(protocol, null, 0, 0);
        this.addInterface(iface);
    }

    public Bindings(Protocol protocol, String iface, InetAddress bind) {
        this(protocol, null, 0, 0);
        this.addInterface(iface);
    }

    public Bindings(InetAddress externalAddress, int externalTCPPort, int externalUDPPort) {
        this(Protocol.Any, externalAddress, externalTCPPort, externalUDPPort);
    }

    public Bindings(Protocol protocol, InetAddress externalAddress, int externalTCPPort, int externalUDPPort) {
        if (externalTCPPort < 0 || externalUDPPort < 0) {
            throw new IllegalArgumentException("port needs to be >= 0");
        }
        this.externalAddress = externalAddress;
        this.externalTCPPort = externalTCPPort == 0 ? RND.nextInt(16383) + 49152 : externalTCPPort;
        this.externalUDPPort = externalUDPPort == 0 ? RND.nextInt(16383) + 49152 : externalUDPPort;
        this.setExternalPortsManually = externalUDPPort != 0 && externalTCPPort != 0;
        this.listenProtocolHint = protocol;
    }

    Bindings addFoundAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        if (address instanceof Inet4Address) {
            this.foundAddresses4.add((Inet4Address)address);
        } else if (address instanceof Inet6Address) {
            this.foundAddresses6.add((Inet6Address)address);
        } else {
            throw new IllegalArgumentException("Unknown address family " + address.getClass());
        }
        return this;
    }

    public List<InetAddress> getFoundAddresses() {
        ArrayList<InetAddress> listenAddresses2 = new ArrayList<InetAddress>();
        listenAddresses2.addAll(this.foundAddresses4);
        listenAddresses2.addAll(this.foundAddresses6);
        return listenAddresses2;
    }

    public Bindings addAddress(InetAddress address) {
        this.listenAddresses.add(address);
        return this;
    }

    public List<InetAddress> getAddresses() {
        return this.listenAddresses;
    }

    public List<InetAddress> getBroadcastAddresses() {
        return this.foundBroadcastAddresses;
    }

    public Bindings addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenInterfaceHints.add(interfaceHint);
        return this;
    }

    public List<String> getInterfaces() {
        return this.listenInterfaceHints;
    }

    public Protocol getProtocol() {
        return this.listenProtocolHint;
    }

    public void clear() {
        this.listenInterfaceHints.clear();
        this.listenAddresses.clear();
        this.foundAddresses4.clear();
        this.foundAddresses6.clear();
        this.foundBroadcastAddresses.clear();
    }

    public boolean isAllAddresses() {
        return this.listenAddresses.size() == 0;
    }

    public boolean isAllInterfaces() {
        return this.listenInterfaceHints.size() == 0;
    }

    public boolean isAllProtocols() {
        return this.listenProtocolHint == Protocol.Any;
    }

    public boolean isIPv4() {
        return this.isAllProtocols() || this.listenProtocolHint == Protocol.IPv4;
    }

    public boolean isIPv6() {
        return this.isAllProtocols() || this.listenProtocolHint == Protocol.IPv6;
    }

    public boolean isListenAll() {
        return this.isAllProtocols() && this.isAllInterfaces() && this.isAllAddresses();
    }

    public boolean containsInterface(String name) {
        return this.listenInterfaceHints.contains(name);
    }

    public boolean isExternalAddress() {
        return this.externalAddress != null && this.externalTCPPort != 0 && this.externalUDPPort != 0;
    }

    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    public int getOutsideTCPPort() {
        return this.externalTCPPort;
    }

    public int getOutsideUDPPort() {
        return this.externalUDPPort;
    }

    public Bindings add(Bindings other) {
        this.foundAddresses4.addAll(other.foundAddresses4);
        this.foundAddresses6.addAll(other.foundAddresses6);
        this.foundBroadcastAddresses.addAll(other.foundBroadcastAddresses);
        return this;
    }

    public boolean isSetExternalPortsManually() {
        return this.setExternalPortsManually;
    }

    public static enum Protocol {
        IPv4,
        IPv6,
        Any;

    }
}

