/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.utils.CacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCacheMap<K, V>
implements ConcurrentMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentCacheMap.class);
    public static final int SEGMENT_NR = 16;
    public static final int MAX_ENTRIES = 1024;
    public static final int DEFAULT_TIME_TO_LIVE = 60;
    private final CacheMap<K, ExpiringObject>[] segments;
    private final int timeToLive;
    private final boolean refreshTimeout;
    private final AtomicInteger removed = new AtomicInteger();

    public ConcurrentCacheMap() {
        this(60, 1024, true);
    }

    public ConcurrentCacheMap(int timeToLive) {
        this(timeToLive, 1024, true);
    }

    public ConcurrentCacheMap(int timeToLive, int maxEntries, boolean refreshTimeout) {
        this.segments = new CacheMap[16];
        int maxEntriesPerSegment = maxEntries / 16;
        for (int i = 0; i < 16; ++i) {
            this.segments[i] = new CacheMap(maxEntriesPerSegment, true);
        }
        this.timeToLive = timeToLive;
        this.refreshTimeout = refreshTimeout;
    }

    private CacheMap<K, ExpiringObject> segment(Object key) {
        return this.segments[(key.hashCode() & Integer.MAX_VALUE) % 16];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = segment.put(key, newValue);
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        ExpiringObject oldValue = null;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            if (!segment.containsKey(key)) {
                oldValue = segment.put(key, newValue);
            } else {
                oldValue = (ExpiringObject)segment.get(key);
                if (oldValue.isExpired()) {
                    segment.put(key, newValue);
                } else if (this.refreshTimeout) {
                    oldValue = new ExpiringObject(oldValue.getValue(), System.currentTimeMillis());
                    segment.put(key, oldValue);
                }
            }
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
        }
        if (oldValue != null) {
            if (this.expire(segment, key, oldValue)) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("get: " + key + ";" + oldValue.getValue());
            }
            return oldValue.getValue();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("get not found: " + key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.remove(key);
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        boolean removed = false;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
            if (oldValue != null && oldValue.equals(value) && !oldValue.isExpired()) {
                removed = segment.remove(key) != null;
            }
        }
        if (oldValue != null) {
            this.expire(segment, key, oldValue);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
        }
        if (oldValue != null) {
            return !this.expire(segment, key, oldValue);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                this.expireSegment(segment);
                if (segment.containsValue(value)) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                this.expireSegment(segment);
                size += segment.size();
                continue;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                this.expireSegment(segment);
                if (!segment.isEmpty()) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                segment.clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int hashCode = 0;
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                this.expireSegment(segment);
                hashCode += segment.hashCode();
                continue;
            }
        }
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        HashSet retVal = new HashSet();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                this.expireSegment(segment);
                retVal.addAll(segment.keySet());
                continue;
            }
        }
        return retVal;
    }

    @Override
    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> inMap) {
        for (Map.Entry<K, V> e : inMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        ArrayList retVal = new ArrayList();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                Iterator iterator = segment.values().iterator();
                while (iterator.hasNext()) {
                    ExpiringObject expiringObject = (ExpiringObject)iterator.next();
                    if (expiringObject.isExpired()) {
                        iterator.remove();
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove in entrySet " + expiringObject.getValue());
                        }
                        this.removed.incrementAndGet();
                        continue;
                    }
                    retVal.add(expiringObject.getValue());
                }
                continue;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> retVal = new HashSet<Map.Entry<K, V>>();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                Iterator iterator = segment.entrySet().iterator();
                while (iterator.hasNext()) {
                    final Map.Entry entry = iterator.next();
                    if (((ExpiringObject)entry.getValue()).isExpired()) {
                        iterator.remove();
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove in entrySet " + ((ExpiringObject)entry.getValue()).getValue());
                        }
                        this.removed.incrementAndGet();
                        continue;
                    }
                    retVal.add(new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((ExpiringObject)entry.getValue()).getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException("not supported");
                        }
                    });
                }
                continue;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ExpiringObject oldValue3;
        ExpiringObject oldValue2 = new ExpiringObject(oldValue, 0L);
        ExpiringObject newValue2 = new ExpiringObject(newValue, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        boolean replaced = false;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue3 = (ExpiringObject)segment.get(key);
            if (oldValue3 != null && !oldValue3.isExpired() && oldValue2.equals(oldValue3.getValue())) {
                segment.put(key, newValue2);
                replaced = true;
            }
        }
        if (oldValue3 != null) {
            this.expire(segment, key, oldValue3);
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
            if (oldValue != null && !oldValue.isExpired()) {
                segment.put(key, newValue);
            }
        }
        if (oldValue == null) {
            return null;
        }
        if (this.expire(segment, key, oldValue)) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expire(CacheMap<K, ExpiringObject> segment, K key, ExpiringObject value) {
        if (value.isExpired()) {
            CacheMap<K, ExpiringObject> cacheMap = segment;
            synchronized (cacheMap) {
                ExpiringObject tmp = (ExpiringObject)segment.get(key);
                if (tmp != null && tmp.equals(value)) {
                    segment.remove(key);
                    if (logger.isDebugEnabled()) {
                        logger.debug("remove in expire " + value.getValue());
                    }
                    this.removed.incrementAndGet();
                }
            }
            return true;
        }
        return false;
    }

    private void expireSegment(CacheMap<K, ExpiringObject> segment) {
        ExpiringObject expiringObject;
        Iterator iterator = segment.values().iterator();
        while (iterator.hasNext() && (expiringObject = (ExpiringObject)iterator.next()).isExpired()) {
            iterator.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("remove in expireAll " + expiringObject.getValue());
            }
            this.removed.incrementAndGet();
        }
    }

    public int expiredCounter() {
        return this.removed.get();
    }

    private class ExpiringObject {
        private final V value;
        private final long lastAccessTime;

        ExpiringObject(V value, long lastAccessTime) {
            if (value == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.value = value;
            this.lastAccessTime = lastAccessTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.lastAccessTime + (long)(ConcurrentCacheMap.this.timeToLive * 1000);
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpiringObject)) {
                return false;
            }
            ExpiringObject exp = (ExpiringObject)obj;
            return this.value.equals(exp.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

