/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class SendBuilder
extends DHTBuilder<SendBuilder> {
    private ChannelBuffer buffer;
    private Object object;
    private boolean cancelOnFinish = false;
    private boolean raw = false;
    private int repetitions = 5;

    public SendBuilder(Peer peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public ChannelBuffer getBuffer() {
        return this.buffer;
    }

    public SendBuilder setBuffer(ChannelBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public SendBuilder setObject(Object object) {
        this.object = object;
        return this;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public SendBuilder setRepetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public boolean isCancelOnFinish() {
        return this.cancelOnFinish;
    }

    public SendBuilder setCancelOnFinish(boolean cancelOnFinish) {
        this.cancelOnFinish = cancelOnFinish;
        return this;
    }

    public SendBuilder setCancelOnFinish() {
        this.cancelOnFinish = true;
        return this;
    }

    @Override
    public FutureDHT start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DHT_SHUTDOWN;
        }
        this.preBuild("send-builder");
        if (this.buffer == null && this.object != null) {
            byte[] me;
            this.raw = false;
            try {
                me = Utils.encodeJavaObject(this.object);
            }
            catch (IOException e) {
                FutureDHT futureDHT = new FutureDHT();
                return (FutureDHT)futureDHT.setFailed("problems with encoding the object " + e);
            }
            this.buffer = ChannelBuffers.wrappedBuffer((byte[])me);
        } else if (this.buffer != null && this.object == null) {
            this.raw = true;
        } else {
            throw new IllegalArgumentException("either buffer has to be set or object.");
        }
        final FutureDHT futureDHT = this.peer.getDistributedHashMap().direct(this.locationKey, this.buffer, this.raw, this.routingConfiguration, this.requestP2PConfiguration, this.futureCreate, this.isCancelOnFinish(), this.manualCleanup, this.futureChannelCreator, this.peer.getConnectionBean().getConnectionReservation());
        if (this.directReplication) {
            if (this.defaultDirectReplication == null) {
                this.defaultDirectReplication = new DefaultDirectReplication();
            }
            Runnable runner = new Runnable(){
                private int counter = 0;

                @Override
                public void run() {
                    if (this.counter < SendBuilder.this.repetitions) {
                        FutureDHT futureDHTReplication = (FutureDHT)SendBuilder.this.defaultDirectReplication.create();
                        futureDHT.repeated(futureDHTReplication);
                        ++this.counter;
                        ScheduledFuture<?> tmp = SendBuilder.this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().schedule(this, (long)SendBuilder.this.refreshSeconds, TimeUnit.SECONDS);
                        SendBuilder.this.setupCancel(futureDHT, tmp);
                    }
                }
            };
            ScheduledFuture<?> tmp = this.peer.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().schedule(runner, (long)this.refreshSeconds, TimeUnit.SECONDS);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private class DefaultDirectReplication
    implements FutureCreator<FutureDHT> {
        private DefaultDirectReplication() {
        }

        @Override
        public FutureDHT create() {
            FutureChannelCreator futureChannelCreator = SendBuilder.this.peer.reserve(SendBuilder.this.routingConfiguration, SendBuilder.this.requestP2PConfiguration, "send-builder-direct-replication");
            FutureDHT futureDHT = SendBuilder.this.peer.getDistributedHashMap().direct(SendBuilder.this.locationKey, SendBuilder.this.buffer, SendBuilder.this.raw, SendBuilder.this.routingConfiguration, SendBuilder.this.requestP2PConfiguration, SendBuilder.this.futureCreate, SendBuilder.this.isCancelOnFinish(), SendBuilder.this.manualCleanup, futureChannelCreator, SendBuilder.this.peer.getConnectionBean().getConnectionReservation());
            return futureDHT;
        }
    }
}

