/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.util.Collection;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DiscoverBuilder.class);
    private static final FutureDiscover FUTURE_DISCOVER_SHUTDOWN = (FutureDiscover)new FutureDiscover().setFailed("Peer is shutting down");
    private final Peer peer;
    private InetAddress inetAddress;
    private int portUDP = 7700;
    private int portTCP = 7700;
    private PeerAddress peerAddress;
    private int discoverTimeoutSec = 5;

    public DiscoverBuilder(Peer peer) {
        this.peer = peer;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public DiscoverBuilder setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public int getPortUDP() {
        return this.portUDP;
    }

    public DiscoverBuilder setPortUDP(int portUDP) {
        this.portUDP = portUDP;
        return this;
    }

    public int getPortTCP() {
        return this.portTCP;
    }

    public DiscoverBuilder setPortTCP(int portTCP) {
        this.portTCP = portTCP;
        return this;
    }

    public DiscoverBuilder setPorts(int port) {
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DiscoverBuilder setPeerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public int getDiscoverTimeoutSec() {
        return this.discoverTimeoutSec;
    }

    public DiscoverBuilder setDiscoverTimeoutSec(int discoverTimeoutSec) {
        this.discoverTimeoutSec = discoverTimeoutSec;
        return this;
    }

    public FutureDiscover start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DISCOVER_SHUTDOWN;
        }
        if (this.peerAddress == null && this.inetAddress != null) {
            this.peerAddress = new PeerAddress(Number160.ZERO, this.inetAddress, this.portTCP, this.portUDP);
        }
        if (this.peerAddress == null) {
            throw new IllegalArgumentException("need peeraddress or inetaddress");
        }
        return this.discover(this.peerAddress);
    }

    private FutureDiscover discover(final PeerAddress peerAddress) {
        final FutureDiscover futureDiscover = new FutureDiscover();
        this.peer.getConnectionBean().getConnectionReservation().reserve(3).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    DiscoverBuilder.this.discover(futureDiscover, peerAddress, future.getChannelCreator());
                } else {
                    futureDiscover.setFailed(future);
                }
            }
        });
        return futureDiscover;
    }

    private void discover(final FutureDiscover futureDiscover, final PeerAddress peerAddress, final ChannelCreator cc) {
        final FutureResponse futureResponseTCP = this.peer.getHandshakeRPC().pingTCPDiscover(peerAddress, cc);
        Utils.addReleaseListener(futureResponseTCP, this.peer.getConnectionBean().getConnectionReservation(), cc, 1);
        this.peer.addPeerListener(new PeerListener(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void serverAddressChanged(PeerAddress peerAddress, PeerAddress reporter, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                    futureDiscover.setDiscoveredTCP();
                } else {
                    this.changedUDP = true;
                    futureDiscover.setDiscoveredUDP();
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress, reporter);
                }
            }

            @Override
            public void notifyOnStart() {
            }

            @Override
            public void notifyOnShutdown() {
            }
        });
        futureResponseTCP.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = DiscoverBuilder.this.peer.getPeerBean().getServerPeerAddress();
                if (futureResponseTCP.isSuccess()) {
                    Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighbors();
                    if (tmp.size() == 1) {
                        PeerAddress seenAs = tmp.iterator().next();
                        logger.info("I'm seen as " + seenAs + " by peer " + peerAddress + " I see myself as " + DiscoverBuilder.this.peer.getPeerAddress().getInetAddress());
                        if (!DiscoverBuilder.this.peer.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                            Bindings bindings2 = new Bindings(seenAs.getInetAddress());
                            String status = DiscoverNetworks.discoverInterfaces(bindings2);
                            logger.info("2nd interface discovery: " + status);
                            if (bindings2.getFoundAddresses().size() > 0 && bindings2.getFoundAddresses().contains(seenAs.getInetAddress())) {
                                serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                DiscoverBuilder.this.peer.getPeerBean().setServerPeerAddress(serverAddress);
                            } else if (DiscoverBuilder.this.peer.getBindings().isSetExternalPortsManually() || DiscoverBuilder.this.peer.setupPortForwanding(futureResponseTCP.getResponse().getRecipient().getInetAddress().getHostAddress())) {
                                serverAddress = serverAddress.changePorts(DiscoverBuilder.this.peer.getBindings().getOutsideUDPPort(), DiscoverBuilder.this.peer.getBindings().getOutsideTCPPort());
                                serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                DiscoverBuilder.this.peer.getPeerBean().setServerPeerAddress(serverAddress);
                            }
                        }
                        FutureResponse fr1 = DiscoverBuilder.this.peer.getHandshakeRPC().pingTCPProbe(peerAddress, cc);
                        FutureResponse fr2 = DiscoverBuilder.this.peer.getHandshakeRPC().pingUDPProbe(peerAddress, cc);
                        Utils.addReleaseListener(fr1, DiscoverBuilder.this.peer.getConnectionBean().getConnectionReservation(), cc, 1);
                        Utils.addReleaseListener(fr2, DiscoverBuilder.this.peer.getConnectionBean().getConnectionReservation(), cc, 1);
                        futureDiscover.setTimeout(DiscoverBuilder.this.peer.getTimer(), DiscoverBuilder.this.discoverTimeoutSec);
                        return;
                    }
                    DiscoverBuilder.this.peer.getConnectionBean().getConnectionReservation().release(cc, 2);
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                DiscoverBuilder.this.peer.getConnectionBean().getConnectionReservation().release(cc, 2);
                futureDiscover.setFailed("FutureDiscover: We need at least the TCP connection", futureResponseTCP);
            }
        });
    }
}

