/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.concurrent.ScheduledFuture;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureCreator;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.peers.Number160;

public abstract class DHTBuilder<K extends DHTBuilder<K>> {
    public static final Number160 DEFAULT_DOMAIN = Number160.createHash("default-dht");
    protected static final FutureDHT FUTURE_DHT_SHUTDOWN = (FutureDHT)new FutureDHT().setFailed("Peer is shutting down");
    protected final Peer peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected RoutingConfiguration routingConfiguration;
    protected RequestP2PConfiguration requestP2PConfiguration;
    protected FutureCreate<FutureDHT> futureCreate;
    protected FutureChannelCreator futureChannelCreator;
    protected FutureCreator<FutureDHT> defaultDirectReplication;
    protected int refreshSeconds = 30;
    protected boolean protectDomain = false;
    protected boolean signMessage = false;
    protected boolean manualCleanup = false;
    protected boolean directReplication = false;
    private K self;

    public DHTBuilder(Peer peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    public Number160 getDomainKey() {
        return this.domainKey;
    }

    public K setDomainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public RoutingConfiguration getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public K setRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    public RequestP2PConfiguration getRequestP2PConfiguration() {
        return this.requestP2PConfiguration;
    }

    public K setRequestP2PConfiguration(RequestP2PConfiguration requestP2PConfiguration) {
        this.requestP2PConfiguration = requestP2PConfiguration;
        return this.self;
    }

    public FutureCreate<FutureDHT> getFutureCreate() {
        return this.futureCreate;
    }

    public K setFutureCreate(FutureCreate<FutureDHT> futureCreate) {
        this.futureCreate = futureCreate;
        return this.self;
    }

    public FutureChannelCreator getFutureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K setFutureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public int getRefreshSeconds() {
        return this.refreshSeconds;
    }

    public K setRefreshSeconds(int refreshSeconds) {
        this.refreshSeconds = refreshSeconds;
        return this.self;
    }

    public FutureCreator<FutureDHT> getDefaultDirectReplication() {
        return this.defaultDirectReplication;
    }

    public K setDefaultDirectReplication(FutureCreator<FutureDHT> defaultDirectReplication) {
        this.defaultDirectReplication = defaultDirectReplication;
        return this.self;
    }

    public boolean isProtectDomain() {
        return this.protectDomain;
    }

    public K setProtectDomain(boolean protectDomain) {
        this.protectDomain = protectDomain;
        return this.self;
    }

    public K setProtectDomain() {
        this.protectDomain = true;
        return this.self;
    }

    public boolean isSignMessage() {
        return this.signMessage;
    }

    public K setSignMessage(boolean signMessage) {
        this.signMessage = signMessage;
        return this.self;
    }

    public K setSignMessage() {
        this.signMessage = true;
        return this.self;
    }

    public boolean isManualCleanup() {
        return this.manualCleanup;
    }

    public K setManualCleanup(boolean isManualCleanup) {
        this.manualCleanup = isManualCleanup;
        return this.self;
    }

    public K setManualCleanup() {
        this.manualCleanup = true;
        return this.self;
    }

    public boolean isDirectReplication() {
        return this.directReplication;
    }

    public K setDirectReplication(boolean directReplication) {
        this.directReplication = directReplication;
        return this.self;
    }

    public K setDirectReplication() {
        this.directReplication = true;
        return this.self;
    }

    protected void setupCancel(FutureCleanup futureCleanup, final ScheduledFuture<?> future) {
        this.peer.getScheduledFutures().add(future);
        futureCleanup.addCleanup(new Cancellable(){

            @Override
            public void cancel() {
                future.cancel(true);
                DHTBuilder.this.peer.getScheduledFutures().remove(future);
            }
        });
    }

    protected void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = DEFAULT_DOMAIN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.requestP2PConfiguration == null) {
            this.requestP2PConfiguration = new RequestP2PConfiguration(3, 5, 3);
        }
        int size = this.peer.getPeerBean().getPeerMap().size() + 1;
        this.requestP2PConfiguration = this.requestP2PConfiguration.adjustMinimumResult(size);
        if (this.futureChannelCreator == null) {
            this.futureChannelCreator = this.peer.reserve(this.routingConfiguration, this.requestP2PConfiguration, name);
        }
        if (this.refreshSeconds > 0) {
            this.directReplication = true;
        }
    }

    public abstract FutureDHT start();
}

