/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistics {
    private static final Logger logger = LoggerFactory.getLogger(Statistics.class);
    private static final double MAX = Math.pow(2.0, 160.0);
    private double estimatedNumberOfPeers = 1.0;
    private double avgGap = MAX / 2.0;
    private final List<Map<Number160, PeerAddress>> peerMap;
    private final int maxSize;
    private final int bagSize;
    private int currentSize;
    private long tcpCreationCount = 0L;
    private long udpCreationCount = 0L;
    private long tcpCount = 0L;
    private long udpCount = 0L;

    public Statistics(List<Map<Number160, PeerAddress>> peerMap, Number160 remotePeer, int maxSize, int bagSize) {
        this.peerMap = peerMap;
        this.maxSize = maxSize;
        this.bagSize = bagSize;
    }

    public void triggerStatUpdate(boolean insert, int currentSize) {
        this.currentSize = currentSize;
    }

    public double getEstimatedNumberOfNodes() {
        if (this.currentSize < this.maxSize) {
            this.estimatedNumberOfPeers = this.currentSize;
            return this.estimatedNumberOfPeers;
        }
        double gap = 0.0;
        int gapCount = 0;
        int oldNumPeers = 0;
        for (int i = 159; i >= 0; --i) {
            Map<Number160, PeerAddress> peers = this.peerMap.get(i);
            int numPeers = peers.size();
            if (numPeers > 0 && (numPeers < this.bagSize || numPeers < oldNumPeers)) {
                double currentGap = Math.pow(2.0, i) / (double)numPeers;
                gap += currentGap * (double)numPeers;
                gapCount += numPeers;
            }
            oldNumPeers = numPeers;
        }
        this.avgGap = gap / (double)gapCount;
        this.estimatedNumberOfPeers = MAX / this.avgGap;
        return this.estimatedNumberOfPeers;
    }

    public double getAvgGap() {
        return this.avgGap;
    }

    public static void tooClose(Collection<PeerAddress> collection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTCPChannelCreation() {
        Statistics statistics = this;
        synchronized (statistics) {
            ++this.tcpCreationCount;
            ++this.tcpCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUDPChannelCreation() {
        Statistics statistics = this;
        synchronized (statistics) {
            ++this.udpCreationCount;
            ++this.udpCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementTCPChannelCreation() {
        Statistics statistics = this;
        synchronized (statistics) {
            --this.tcpCount;
            if (logger.isDebugEnabled()) {
                logger.debug("TCP channel count is " + this.tcpCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUDPChannelCreation() {
        Statistics statistics = this;
        synchronized (statistics) {
            --this.udpCount;
            if (logger.isDebugEnabled()) {
                logger.debug("UDP channel count is " + this.udpCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTCPChannelCreationCount() {
        Statistics statistics = this;
        synchronized (statistics) {
            return this.tcpCreationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUDPChannelCreationCount() {
        Statistics statistics = this;
        synchronized (statistics) {
            return this.udpCreationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTCPChannelCount() {
        Statistics statistics = this;
        synchronized (statistics) {
            return this.tcpCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUDPChannelCount() {
        Statistics statistics = this;
        synchronized (statistics) {
            return this.udpCount;
        }
    }
}

