/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.ConnectionConfiguration;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTask;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.AddBuilder;
import net.tomp2p.p2p.builder.AddTrackerBuilder;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.p2p.builder.GetTrackerBuilder;
import net.tomp2p.p2p.builder.ParallelRequestBuilder;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.p2p.builder.RemoveBuilder;
import net.tomp2p.p2p.builder.SendBuilder;
import net.tomp2p.p2p.builder.SendDirectBuilder;
import net.tomp2p.p2p.builder.SubmitBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TaskRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.task.AsyncTask;
import net.tomp2p.task.Worker;
import net.tomp2p.utils.CacheMap;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    private ConnectionHandler connectionHandler;
    private final Number160 peerId;
    private final int p2pID;
    private final KeyPair keyPair;
    private DistributedHashTable distributedHashMap;
    private DistributedTracker distributedTracker;
    private DistributedRouting distributedRouting;
    private DistributedTask distributedTask;
    private AsyncTask asyncTask;
    private HandshakeRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private PeerExchangeRPC peerExchangeRPC;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private TaskRPC taskRPC;
    private Bindings bindings;
    private final ConnectionConfiguration configuration;
    private final Map<BaseFuture, Long> pendingFutures = Collections.synchronizedMap(new CacheMap(1000, true));
    private boolean masterFlag = true;
    private List<ScheduledFuture<?>> scheduledFutures = Collections.synchronizedList(new ArrayList());
    private final List<PeerListener> listeners = new ArrayList<PeerListener>();
    private Timer timer;
    public static final int BLOOMFILTER_SIZE = 1024;
    private final int maintenanceThreads;
    private final int replicationThreads;
    private final PeerMap peerMap;
    private final int maxMessageSize;
    private volatile boolean shutdown = false;

    Peer(int p2pID, Number160 nodeId, KeyPair keyPair, int maintenanceThreads, int replicationThreads, ConnectionConfiguration configuration, PeerMap peerMap, int maxMessageSize) {
        this.p2pID = p2pID;
        this.peerId = nodeId;
        this.configuration = configuration;
        this.keyPair = keyPair;
        this.maintenanceThreads = maintenanceThreads;
        this.replicationThreads = replicationThreads;
        this.peerMap = peerMap;
        this.maxMessageSize = maxMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerListener(PeerListener listener) {
        if (this.isRunning()) {
            listener.notifyOnStart();
        }
        List<PeerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerListener(PeerListener listener) {
        List<PeerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public List<PeerListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        logger.info("begin shutdown in progres at " + System.nanoTime());
        List<Object> list = this.scheduledFutures;
        synchronized (list) {
            for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        if (this.masterFlag) {
            this.getConnectionBean().getSender().shutdown();
            this.getPeerBean().getTaskManager().shutdown();
        }
        this.getConnectionHandler().shutdown();
        if (this.masterFlag && this.timer != null) {
            this.timer.stop();
        }
        list = this.listeners;
        synchronized (list) {
            for (PeerListener listener : this.listeners) {
                listener.notifyOnShutdown();
            }
        }
        this.getPeerBean().getStorage().close();
        this.connectionHandler = null;
    }

    ConnectionHandler listen(int udpPort, int tcpPort, Bindings bindings, File fileMessageLogger, int workerThreads) throws IOException {
        this.masterFlag = true;
        this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS, 10);
        this.bindings = bindings;
        ConnectionHandler connectionHandler = new ConnectionHandler(udpPort, tcpPort, this.peerId, bindings, this.getP2PID(), this.configuration, fileMessageLogger, this.keyPair, this.peerMap, this.timer, this.maxMessageSize, this.maintenanceThreads, this.replicationThreads, workerThreads);
        logger.debug("listen done");
        this.connectionHandler = connectionHandler;
        return connectionHandler;
    }

    ConnectionHandler listen(Peer master) throws IOException {
        this.masterFlag = false;
        this.timer = master.timer;
        this.bindings = master.bindings;
        ConnectionHandler connectionHandler = new ConnectionHandler(master.getConnectionHandler(), this.peerId, this.keyPair, this.peerMap);
        logger.debug("listen done");
        this.connectionHandler = connectionHandler;
        return connectionHandler;
    }

    public Map<BaseFuture, Long> getPendingFutures() {
        return this.pendingFutures;
    }

    public boolean isRunning() {
        return this.connectionHandler != null;
    }

    public boolean isListening() {
        if (!this.isRunning()) {
            return false;
        }
        return this.connectionHandler.isListening();
    }

    public void customLoggerMessage(String customMessage) {
        this.getConnectionHandler().customLoggerMessage(customMessage);
    }

    public HandshakeRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.handshakeRCP;
    }

    public void setHandshakeRPC(HandshakeRPC handshakeRPC) {
        this.handshakeRCP = handshakeRPC;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.storageRPC;
    }

    public void setStorageRPC(StorageRPC storageRPC) {
        this.storageRPC = storageRPC;
    }

    public NeighborRPC getNeighborRPC() {
        if (this.neighborRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.neighborRPC;
    }

    public void setNeighborRPC(NeighborRPC neighborRPC) {
        this.neighborRPC = neighborRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.quitRCP;
    }

    public void setQuitRPC(QuitRPC quitRCP) {
        this.quitRCP = quitRCP;
    }

    public PeerExchangeRPC getPeerExchangeRPC() {
        if (this.peerExchangeRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.peerExchangeRPC;
    }

    public void setPeerExchangeRPC(PeerExchangeRPC peerExchangeRPC) {
        this.peerExchangeRPC = peerExchangeRPC;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.directDataRPC;
    }

    public void setDirectDataRPC(DirectDataRPC directDataRPC) {
        this.directDataRPC = directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.trackerRPC;
    }

    public void setTrackerRPC(TrackerRPC trackerRPC) {
        this.trackerRPC = trackerRPC;
    }

    public TaskRPC getTaskRPC() {
        if (this.taskRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.taskRPC;
    }

    public void setTaskRPC(TaskRPC taskRPC) {
        this.taskRPC = taskRPC;
    }

    public DistributedRouting getDistributedRouting() {
        if (this.distributedRouting == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedRouting;
    }

    public void setDistributedRouting(DistributedRouting distributedRouting) {
        this.distributedRouting = distributedRouting;
    }

    public DistributedHashTable getDistributedHashMap() {
        if (this.distributedHashMap == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedHashMap;
    }

    public void setDistributedHashMap(DistributedHashTable distributedHashMap) {
        this.distributedHashMap = distributedHashMap;
    }

    public DistributedTracker getDistributedTracker() {
        if (this.distributedTracker == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedTracker;
    }

    public void setDistributedTracker(DistributedTracker distributedTracker) {
        this.distributedTracker = distributedTracker;
    }

    public AsyncTask getAsyncTask() {
        if (this.asyncTask == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.asyncTask;
    }

    public void setAsyncTask(AsyncTask asyncTask) {
        this.asyncTask = asyncTask;
    }

    public DistributedTask getDistributedTask() {
        if (this.distributedTask == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedTask;
    }

    public void setDistributedTask(DistributedTask task) {
        this.distributedTask = task;
    }

    public List<ScheduledFuture<?>> getScheduledFutures() {
        return this.scheduledFutures;
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.connectionHandler;
    }

    public Bindings getBindings() {
        if (this.bindings == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.bindings;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.timer;
    }

    public PeerBean getPeerBean() {
        return this.getConnectionHandler().getPeerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.getConnectionHandler().getConnectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public PeerConnection createPeerConnection(PeerAddress destination, int idleTCPMillis) {
        FutureChannelCreator fcc = this.getConnectionBean().getConnectionReservation().reserve(1, true, "PeerConnection");
        fcc.awaitUninterruptibly();
        if (fcc.isFailed()) {
            return null;
        }
        ChannelCreator cc = fcc.getChannelCreator();
        PeerConnection peerConnection = new PeerConnection(destination, this.getConnectionBean().getConnectionReservation(), cc, idleTCPMillis);
        return peerConnection;
    }

    public boolean setupPortForwanding(String internalHost) {
        boolean success;
        int portUDP = this.bindings.getOutsideUDPPort();
        int portTCP = this.bindings.getOutsideTCPPort();
        try {
            success = this.connectionHandler.getNATUtils().mapUPNP(internalHost, this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
        }
        catch (IOException e) {
            success = false;
        }
        if (!success) {
            logger.warn("cannot find UPNP devices");
            try {
                success = this.connectionHandler.getNATUtils().mapPMP(this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
                if (!success) {
                    logger.warn("cannot find NAT-PMP devices");
                }
            }
            catch (NatPmpException e1) {
                logger.warn("cannot find NAT-PMP devices " + e1);
            }
        }
        return success;
    }

    public SubmitBuilder submit(Number160 locationKey, Worker worker) {
        return new SubmitBuilder(this, locationKey, worker);
    }

    public AddBuilder add(Number160 locationKey) {
        return new AddBuilder(this, locationKey);
    }

    public PutBuilder put(Number160 locationKey) {
        return new PutBuilder(this, locationKey);
    }

    public GetBuilder get(Number160 locationKey) {
        return new GetBuilder(this, locationKey);
    }

    public RemoveBuilder remove(Number160 locationKey) {
        return new RemoveBuilder(this, locationKey);
    }

    public SendBuilder send(Number160 locationKey) {
        return new SendBuilder(this, locationKey);
    }

    public SendDirectBuilder sendDirect() {
        return new SendDirectBuilder(this);
    }

    public BootstrapBuilder bootstrap() {
        return new BootstrapBuilder(this);
    }

    public PingBuilder ping() {
        return new PingBuilder(this);
    }

    public DiscoverBuilder discover() {
        return new DiscoverBuilder(this);
    }

    public AddTrackerBuilder addTracker(Number160 locationKey) {
        return new AddTrackerBuilder(this, locationKey);
    }

    public GetTrackerBuilder getTracker(Number160 locationKey) {
        return new GetTrackerBuilder(this, locationKey);
    }

    public ParallelRequestBuilder parallelRequest(Number160 locationKey) {
        return new ParallelRequestBuilder(this, locationKey);
    }

    public FutureChannelCreator reserve(RoutingConfiguration routingConfiguration, RequestP2PConfiguration requestP2PConfiguration, String name) {
        if (routingConfiguration == null && requestP2PConfiguration == null) {
            throw new IllegalArgumentException("Both routingConfiguration and requestP2PConfiguration cannot be null");
        }
        int nrConnections = routingConfiguration == null ? requestP2PConfiguration.getParallel() : (requestP2PConfiguration == null ? routingConfiguration.getParallel() : Math.max(routingConfiguration.getParallel(), requestP2PConfiguration.getParallel()));
        return this.getConnectionBean().getConnectionReservation().reserve(nrConnections, name);
    }

    public void release(ChannelCreator channelCreator) {
        this.getConnectionBean().getConnectionReservation().release(channelCreator);
    }

    public void setFutureTimeout(BaseFuture baseFuture, int millis, String reason) {
        this.getConnectionBean().getScheduler().scheduleTimeout(baseFuture, millis, reason);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

