/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.VotingSchemeTracker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.TrackerData;

public class FutureTracker
extends BaseFutureImpl<FutureTracker>
implements FutureCleanup {
    private final EvaluatingSchemeTracker evaluatingSchemeTracker;
    private final Set<Number160> knownPeers;
    private final FutureCreate<BaseFuture> futureCreate;
    private final List<Cancellable> cleanup = new ArrayList<Cancellable>(1);
    private Set<PeerAddress> potentialTrackers;
    private Set<PeerAddress> directTrackers;
    private Map<PeerAddress, Collection<TrackerData>> peersOnTracker;

    public FutureTracker() {
        this(null);
    }

    public FutureTracker(FutureCreate<BaseFuture> futureCreate) {
        this(new VotingSchemeTracker(), null, futureCreate);
    }

    public FutureTracker(EvaluatingSchemeTracker evaluatingSchemeTracker, Set<Number160> knownPeers) {
        this(new VotingSchemeTracker(), knownPeers, null);
    }

    private FutureTracker(EvaluatingSchemeTracker evaluatingSchemeTracker, Set<Number160> knownPeers, FutureCreate<BaseFuture> futureCreate) {
        this.evaluatingSchemeTracker = evaluatingSchemeTracker;
        this.knownPeers = knownPeers;
        this.futureCreate = futureCreate;
        this.self(this);
    }

    public void repeated(BaseFuture future) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackers(Set<PeerAddress> potentialTrackers, Set<PeerAddress> directTrackers, Map<PeerAddress, Collection<TrackerData>> peersOnTracker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.potentialTrackers = potentialTrackers;
            this.directTrackers = directTrackers;
            this.peersOnTracker = peersOnTracker;
            BaseFuture.FutureType futureType = this.type = potentialTrackers.size() == 0 && directTrackers.size() == 0 ? BaseFuture.FutureType.FAILED : BaseFuture.FutureType.OK;
            if (this.type == BaseFuture.FutureType.FAILED) {
                this.reason = "we did not find anything, are you sure you are serching for the right tracker?";
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPotentialTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.potentialTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getDirectTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.directTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Collection<TrackerData>> getRawPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Number160> getKnownPeers() {
        Object object = this.lock;
        synchronized (object) {
            return this.knownPeers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TrackerData> getTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluatingSchemeTracker.evaluateSingle(this.peersOnTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCleanup(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanup.add(cancellable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            for (Cancellable cancellable : this.cleanup) {
                cancellable.cancel();
            }
        }
    }
}

