/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.IOException;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.futures.FutureSuccessEvaluatorCommunication;
import net.tomp2p.message.Message;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;

public class FutureResponse
extends BaseFutureImpl<FutureResponse> {
    private final Message requestMessage;
    private final FutureSuccessEvaluator futureSuccessEvaluator;
    private Message responseMessage;
    private final boolean raw;

    public FutureResponse(Message requestMessage) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication(), false);
    }

    public FutureResponse(Message requestMessage, boolean raw) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication(), raw);
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator) {
        this(requestMessage, futureSuccessEvaluator, false);
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator, boolean raw) {
        this.requestMessage = requestMessage;
        this.futureSuccessEvaluator = futureSuccessEvaluator;
        this.raw = raw;
        this.self(this);
    }

    public void setResponse() {
        this.setResponse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.getType().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelBuffer getBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage.getPayload1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            ChannelBuffer buffer = this.responseMessage.getPayload1();
            Object object2 = null;
            if (!this.raw && this.type == BaseFuture.FutureType.OK && buffer != null) {
                try {
                    object2 = Utils.decodeJavaObject(buffer);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResponse setFailed(String reason) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return this;
            }
            this.reason = reason;
            this.type = BaseFuture.FutureType.FAILED;
        }
        this.notifyListerenrs();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getResponse() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getRequest() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestMessage;
        }
    }

    public void setReplyTimeoutHandler(final ReplyTimeoutHandler replyTimeoutHandler) {
        this.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                replyTimeoutHandler.cancel();
            }
        });
    }
}

