/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestResult;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;

public class FutureDHT
extends BaseFutureImpl<FutureDHT>
implements FutureCleanup {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private final FutureCreate<FutureDHT> futureCreate;
    private FutureRouting futureRouting;
    private final List<FutureResponse> requests = new ArrayList<FutureResponse>(6);
    private final List<Cancellable> cleanup = new ArrayList<Cancellable>(1);
    private Map<PeerAddress, Collection<Number160>> rawKeys;
    private Map<PeerAddress, Map<Number160, Data>> rawData;
    private Map<PeerAddress, DigestResult> rawDigest;
    private Map<PeerAddress, Object> rawObjects;
    private Map<PeerAddress, ChannelBuffer> rawChannels;
    private boolean minReached;
    private Object attachement;

    public FutureDHT() {
        this(0, new VotingSchemeDHT(), null);
    }

    public FutureDHT(int min, EvaluatingSchemeDHT evaluationScheme, FutureCreate<FutureDHT> futureCreate) {
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.futureCreate = futureCreate;
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDone(Object attachement) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.attachement = attachement;
            this.type = BaseFuture.FutureType.OK;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttachement() {
        Object object = this.lock;
        synchronized (object) {
            return this.attachement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovedKeys(Map<PeerAddress, Collection<Number160>> rawKeys) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
            int size = rawKeys.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected > 0 result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoredKeys(Map<PeerAddress, Collection<Number160>> rawKeys) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
            int size = rawKeys.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvgStoredKeys() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.rawKeys.size();
            int total = 0;
            for (Collection<Number160> collection : this.rawKeys.values()) {
                if (collection == null) continue;
                total += collection.size();
            }
            return (double)total / (double)size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedData(Map<PeerAddress, Map<Number160, Data>> rawData) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            int size = rawData.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedDigest(Map<PeerAddress, DigestResult> rawDigest) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawDigest = rawDigest;
            int size = rawDigest.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData1(Map<PeerAddress, ChannelBuffer> rawChannels) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawChannels = rawChannels;
            int size = rawChannels.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData2(Map<PeerAddress, Object> rawObjects) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawObjects = rawObjects;
            int size = rawObjects.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Collection<Number160>> getRawKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number160, Data>> getRawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, DigestResult> getRawDigest() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawDigest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, ChannelBuffer> getRawDirectData1() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Object> getRawDirectData2() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate1(this.rawKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, Data> getDataMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    public Data getData() {
        Map<Number160, Data> dataMap = this.getDataMap();
        if (dataMap.size() == 0) {
            return null;
        }
        return dataMap.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestResult getDigest() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate5(this.rawDigest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate3(this.rawObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getChannelBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate4(this.rawChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureCreate<FutureDHT> getFutureCreate() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureCreate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureRouting getFutureRouting() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureRouting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFutureRouting(FutureRouting futureRouting) {
        Object object = this.lock;
        synchronized (object) {
            this.futureRouting = futureRouting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureResponse> getFutureRequests() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.requests.size();
            BaseFuture[] futureResponses = new FutureResponse[size];
            for (int i = 0; i < size; ++i) {
                futureResponses[i] = this.requests.get(i);
            }
            return new FutureForkJoin(futureResponses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequests(FutureResponse futureResponse) {
        Object object = this.lock;
        synchronized (object) {
            this.requests.add(futureResponse);
        }
    }

    public void repeated(FutureDHT futureDHT) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(futureDHT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCleanup(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanup.add(cancellable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            for (Cancellable cancellable : this.cleanup) {
                cancellable.cancel();
            }
        }
    }
}

