/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.util.ArrayList;
import java.util.Random;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;

public class ExampleUtils {
    private static final Random rnd = new Random(42L);

    public static void bootstrap(Peer[] peers) {
        int i;
        ArrayList<FutureBootstrap> futures1 = new ArrayList<FutureBootstrap>();
        ArrayList<FutureDiscover> futures2 = new ArrayList<FutureDiscover>();
        for (int i2 = 1; i2 < peers.length; ++i2) {
            FutureDiscover futureDiscover = peers[i2].discover().setPeerAddress(peers[0].getPeerAddress()).start();
            futures2.add(futureDiscover);
        }
        for (FutureDiscover futureDiscover : futures2) {
            futureDiscover.awaitUninterruptibly();
        }
        for (i = 1; i < peers.length; ++i) {
            FutureBootstrap futureBootstrap = peers[i].bootstrap().setPeerAddress(peers[0].getPeerAddress()).start();
            futures1.add(futureBootstrap);
        }
        for (i = 1; i < peers.length; ++i) {
            FutureBootstrap futureBootstrap = peers[0].bootstrap().setPeerAddress(peers[i].getPeerAddress()).start();
            futures1.add(futureBootstrap);
        }
        for (FutureBootstrap futureBootstrap : futures1) {
            futureBootstrap.awaitUninterruptibly();
        }
    }

    public static Peer[] createAndAttachNodes(int nr, int port) throws Exception {
        Peer[] peers = new Peer[nr];
        for (int i = 0; i < nr; ++i) {
            if (i == 0) {
                peers[0] = new PeerMaker(new Number160(rnd)).setPorts(port).makeAndListen();
                continue;
            }
            peers[i] = new PeerMaker(new Number160(rnd)).setMasterPeer(peers[0]).makeAndListen();
        }
        return peers;
    }
}

