/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.HashData;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.Storage;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;

public abstract class StorageGeneric
implements Storage {
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private final Collection<Number160> removedDomains = new HashSet<Number160>();
    private final KeyLock<Storage> dataLock = new KeyLock();
    private final KeyLock<Number160> dataLock160 = new KeyLock();
    private final KeyLock<Number320> dataLock320 = new KeyLock();
    private final KeyLock<Number480> dataLock480 = new KeyLock();

    public void setProtection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode) {
        this.setProtectionDomainEnable(protectionDomainEnable);
        this.setProtectionDomainMode(protectionDomainMode);
        this.setProtectionEntryEnable(protectionEntryEnable);
        this.setProtectionEntryMode(protectionEntryMode);
    }

    public void setProtectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode getProtectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void setProtectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable getProtectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void setProtectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode getProtectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void setProtectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable getProtectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> compareAndPut(Number160 locationKey, Number160 domainKey, Map<Number160, HashData> hashDataMap, PublicKey publicKey, boolean partial, boolean protectDomain) {
        ArrayList<Number160> retVal = new ArrayList<Number160>();
        Number320 lockKey = new Number320(locationKey, domainKey);
        Lock lock = this.dataLock320.lock(lockKey);
        try {
            Number480 key;
            boolean perfectMatch = true;
            for (Map.Entry<Number160, HashData> entry : hashDataMap.entrySet()) {
                key = new Number480(locationKey, domainKey, entry.getKey());
                Data data = this.get(locationKey, domainKey, entry.getKey());
                if (data == null) {
                    perfectMatch = false;
                    continue;
                }
                Number160 storedHash = data.getHash();
                if (!storedHash.equals(entry.getValue().getHash())) {
                    perfectMatch = false;
                    continue;
                }
                if (!partial) continue;
                this.put(locationKey, domainKey, entry.getKey(), entry.getValue().getData(), publicKey, false, protectDomain);
                retVal.add(key.getContentKey());
            }
            if (!partial && perfectMatch) {
                for (Map.Entry<Number160, HashData> entry : hashDataMap.entrySet()) {
                    key = new Number480(locationKey, domainKey, entry.getKey());
                    this.put(locationKey, domainKey, entry.getKey(), entry.getValue().getData(), publicKey, false, protectDomain);
                    retVal.add(key.getContentKey());
                }
            }
        }
        finally {
            this.dataLock320.unlock(lockKey, lock);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Number160 locationKey, Number160 domainKey, Number160 contentKey, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        boolean retVal = false;
        Number480 lockKey = new Number480(locationKey, domainKey, contentKey);
        Lock lock = this.dataLock480.lock(lockKey);
        try {
            boolean protectEntry;
            Data oldData;
            if (!this.securityDomainCheck(locationKey, domainKey, publicKey, domainProtection)) {
                boolean bl = false;
                return bl;
            }
            boolean contains = this.contains(locationKey, domainKey, contentKey);
            if (putIfAbsent && contains) {
                boolean bl = false;
                return bl;
            }
            if (contains && !this.canUpdateEntry(contentKey, oldData = this.get(locationKey, domainKey, contentKey), newData, protectEntry = newData.isProtectedEntry())) {
                boolean bl = false;
                return bl;
            }
            retVal = this.put(locationKey, domainKey, contentKey, newData);
            if (retVal) {
                long expiration = newData.getExpirationMillis();
                this.addTimeout(locationKey, domainKey, contentKey, expiration);
            }
        }
        finally {
            this.dataLock480.unlock(lockKey, lock);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data remove(Number160 locationKey, Number160 domainKey, Number160 contentKey, PublicKey publicKey) {
        Number480 lockKey = new Number480(locationKey, domainKey, contentKey);
        Lock lock = this.dataLock480.lock(lockKey);
        try {
            if (!this.canClaimDomain(locationKey, domainKey, publicKey)) {
                Data data = null;
                return data;
            }
            Data data = this.get(locationKey, domainKey, contentKey);
            if (data == null) {
                Data data2 = null;
                return data2;
            }
            if (data.getPublicKey() == null || data.getPublicKey().equals(publicKey)) {
                this.removeTimeout(locationKey, domainKey, contentKey);
                this.removeContentResponsibility(locationKey);
                Data data3 = this.remove(locationKey, domainKey, contentKey);
                return data3;
            }
        }
        finally {
            this.dataLock480.unlock(lockKey, lock);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number480, Data> remove(Number160 locationKey, Number160 domainKey, Number160 fromContentKey, Number160 toContentKey, PublicKey publicKey) {
        Number320 lockKey = new Number320(locationKey, domainKey);
        Lock lock = this.dataLock320.lock(lockKey);
        try {
            if (!this.canClaimDomain(locationKey, domainKey, publicKey)) {
                SortedMap<Number480, Data> sortedMap = null;
                return sortedMap;
            }
            SortedMap<Number480, Data> tmp = this.subMap(locationKey, domainKey, fromContentKey, toContentKey);
            ArrayList<Number480> keys = new ArrayList<Number480>(tmp.keySet());
            TreeMap<Number480, Data> result = new TreeMap<Number480, Data>();
            for (Number480 key : keys) {
                Data data = this.get(key.getLocationKey(), key.getDomainKey(), key.getContentKey());
                if (data.getPublicKey() != null && !data.getPublicKey().equals(publicKey)) continue;
                this.removeTimeout(key.getLocationKey(), key.getDomainKey(), key.getContentKey());
                this.removeContentResponsibility(key.getLocationKey());
                result.put(key, this.remove(key.getLocationKey(), key.getDomainKey(), key.getContentKey()));
            }
            TreeMap<Number480, Data> treeMap = result;
            return treeMap;
        }
        finally {
            this.dataLock320.unlock(lockKey, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number480, Data> get(Number160 locationKey, Number160 domainKey, Number160 fromContentKey, Number160 toContentKey) {
        Number320 lockKey = new Number320(locationKey, domainKey);
        Lock lock = this.dataLock320.lock(lockKey);
        try {
            SortedMap<Number480, Data> sortedMap = this.subMap(locationKey, domainKey, fromContentKey, toContentKey);
            return sortedMap;
        }
        finally {
            this.dataLock320.unlock(lockKey, lock);
        }
    }

    public void checkTimeout() {
        long time = Timings.currentTimeMillis();
        Collection<Number480> toRemove = this.subMapTimeout(time);
        if (toRemove.size() > 0) {
            for (Number480 key : toRemove) {
                this.remove(key.getLocationKey(), key.getDomainKey(), key.getContentKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DigestInfo digest(Number160 locationKey, Number160 domainKey) {
        DigestInfo digestInfo = new DigestInfo();
        Number320 lockKey = new Number320(locationKey, domainKey);
        Lock lock = this.dataLock320.lock(lockKey);
        try {
            SortedMap<Number480, Data> tmp = this.get(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE);
            for (Map.Entry<Number480, Data> entry : tmp.entrySet()) {
                digestInfo.put(entry.getKey().getContentKey(), entry.getValue().getHash());
            }
        }
        finally {
            this.dataLock320.unlock(lockKey, lock);
        }
        return digestInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Number160 locationKey, Number160 domainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter) {
        DigestInfo digestInfo = new DigestInfo();
        Number320 lockKey = new Number320(locationKey, domainKey);
        SortedMap<Number480, Data> tmp = this.get(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE);
        Lock lock = this.dataLock320.lock(lockKey);
        try {
            for (Map.Entry<Number480, Data> entry : tmp.entrySet()) {
                if (keyBloomFilter != null && !keyBloomFilter.contains(entry.getKey().getContentKey()) || contentBloomFilter != null && !contentBloomFilter.contains(entry.getValue().getHash())) continue;
                digestInfo.put(entry.getKey().getContentKey(), entry.getValue().getHash());
            }
        }
        finally {
            this.dataLock320.unlock(lockKey, lock);
        }
        return digestInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys) {
        if (contentKeys == null) {
            return this.digest(locationKey, domainKey);
        }
        DigestInfo digestInfo = new DigestInfo();
        for (Number160 contentKey : contentKeys) {
            Number480 lockKey = new Number480(locationKey, domainKey, contentKey);
            Lock lock = this.dataLock480.lock(lockKey);
            try {
                if (!this.contains(locationKey, domainKey, contentKey)) continue;
                Data data = this.get(locationKey, domainKey, contentKey);
                digestInfo.put(contentKey, data.getHash());
            }
            finally {
                this.dataLock480.unlock(lockKey, lock);
            }
        }
        return digestInfo;
    }

    private void removeContentResponsibility(Number160 locationKey) {
        this.removeResponsibility(locationKey);
    }

    private boolean canClaimDomain(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        boolean domainProtectedByOthers = this.isDomainProtectedByOthers(locationKey, domainKey, publicKey);
        boolean domainOverridableByMe = this.foreceOverrideDomain(domainKey, publicKey);
        return !domainProtectedByOthers || domainOverridableByMe;
    }

    private boolean canProtectDomain(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        if (this.isDomainRemoved(domainKey)) {
            return false;
        }
        if (this.getProtectionDomainEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.getProtectionDomainEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideDomain(domainKey, publicKey);
        }
        return false;
    }

    private boolean securityDomainCheck(Number160 locationKey, Number160 domainKey, PublicKey publicKey, boolean domainProtection) {
        boolean domainProtectedByOthers = this.isDomainProtectedByOthers(locationKey, domainKey, publicKey);
        if (!domainProtection) {
            return !domainProtectedByOthers;
        }
        if (this.canClaimDomain(locationKey, domainKey, publicKey)) {
            if (this.canProtectDomain(locationKey, domainKey, publicKey)) {
                return this.protectDomain(locationKey, domainKey, publicKey);
            }
            return true;
        }
        return false;
    }

    private boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.getProtectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return StorageGeneric.isMine(domainKey, publicKey);
        }
        return false;
    }

    private boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.getProtectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return StorageGeneric.isMine(entryKey, publicKey);
        }
        return false;
    }

    private boolean canUpdateEntry(Number160 contentKey, Data oldData, Data newData, boolean protectEntry) {
        if (protectEntry) {
            return this.canProtectEntry(contentKey, oldData, newData);
        }
        return true;
    }

    private boolean canProtectEntry(Number160 contentKey, Data oldData, Data newData) {
        if (this.getProtectionEntryEnable() == ProtectionEnable.ALL) {
            if (oldData == null) {
                return true;
            }
            if (oldData.getPublicKey() == null) {
                return true;
            }
            if (oldData.getPublicKey().equals(newData.getPublicKey())) {
                return true;
            }
        }
        return this.foreceOverrideEntry(contentKey, newData.getPublicKey());
    }

    private static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals(Utils.makeSHAHash(publicKey.getEncoded()));
    }

    public KeyLock<Storage> getLockStorage() {
        return this.dataLock;
    }

    public KeyLock<Number160> getLockNumber160() {
        return this.dataLock160;
    }

    public KeyLock<Number320> getLockNumber320() {
        return this.dataLock320;
    }

    public KeyLock<Number480> getLockNumber480() {
        return this.dataLock480;
    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

