/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;

public class DigestInfo {
    private volatile Number160 keyDigest = null;
    private volatile Number160 contentDigest = null;
    private volatile int size = -1;
    private final Map<Number160, Number160> mapDigests = new HashMap<Number160, Number160>();

    public DigestInfo() {
    }

    public DigestInfo(int size) {
        this.size = size;
    }

    public DigestInfo(Number160 keyDigest, Number160 contentDigest, int size) {
        this.keyDigest = keyDigest;
        this.contentDigest = contentDigest;
        this.size = size;
    }

    public Number160 getKeyDigest() {
        if (this.keyDigest == null) {
            this.process();
        }
        return this.keyDigest;
    }

    public Number160 getContentDigest() {
        if (this.contentDigest == null) {
            this.process();
        }
        return this.contentDigest;
    }

    private void process() {
        Number160 hashKey = Number160.ZERO;
        Number160 hashContent = Number160.ZERO;
        for (Map.Entry<Number160, Number160> entry : this.mapDigests.entrySet()) {
            hashKey = hashKey.xor(entry.getKey());
            hashContent = hashContent.xor(entry.getValue());
        }
        this.keyDigest = hashKey;
        this.contentDigest = hashContent;
    }

    public SimpleBloomFilter<Number160> getKeyBloomFilter(int bitArraySize, int expectedElements) {
        SimpleBloomFilter<Number160> sbf = new SimpleBloomFilter<Number160>(bitArraySize, expectedElements);
        for (Map.Entry<Number160, Number160> entry : this.mapDigests.entrySet()) {
            sbf.add(entry.getKey());
        }
        return sbf;
    }

    public SimpleBloomFilter<Number160> getContentBloomFilter(int bitArraySize, int expectedElements) {
        SimpleBloomFilter<Number160> sbf = new SimpleBloomFilter<Number160>(bitArraySize, expectedElements);
        for (Map.Entry<Number160, Number160> entry : this.mapDigests.entrySet()) {
            sbf.add(entry.getValue());
        }
        return sbf;
    }

    public void put(Number160 key, Number160 content) {
        this.mapDigests.put(key, content);
    }

    public Map<Number160, Number160> getDigests() {
        return this.mapDigests;
    }

    public int getSize() {
        if (this.size == -1) {
            this.size = this.mapDigests.size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestInfo)) {
            return false;
        }
        DigestInfo other = (DigestInfo)obj;
        return this.getKeyDigest().equals(other.getKeyDigest()) && this.getSize() == other.getSize() && this.getContentDigest().equals(other.getContentDigest());
    }

    public int hashCode() {
        return this.getKeyDigest().hashCode() ^ this.getSize() ^ this.getContentDigest().hashCode();
    }
}

