/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureSuccessEvaluator;
import net.tomp2p.futures.FutureSuccessEvaluatorCommunication;
import net.tomp2p.message.Message;

public class FutureResponse
extends BaseFutureImpl {
    private final Message requestMessage;
    private final FutureSuccessEvaluator futureSuccessEvaluator;
    private Message responseMessage;

    public FutureResponse(Message requestMessage) {
        this(requestMessage, new FutureSuccessEvaluatorCommunication());
    }

    public FutureResponse(Message requestMessage, FutureSuccessEvaluator futureSuccessEvaluator) {
        this.requestMessage = requestMessage;
        this.futureSuccessEvaluator = futureSuccessEvaluator;
    }

    public void setResponse() {
        this.setResponse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Message responseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            if (responseMessage != null) {
                this.responseMessage = responseMessage;
                this.type = this.futureSuccessEvaluator.evaluate(this.requestMessage, responseMessage);
                this.reason = responseMessage.getType().toString();
            } else {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "Nothing to deliver...";
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFailed(String reason) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.reason = reason;
            this.type = BaseFuture.FutureType.FAILED;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getResponse() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getRequest() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestMessage;
        }
    }

    public void setReplyTimeoutHandler(final ReplyTimeoutHandler replyTimeoutHandler) {
        this.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                replyTimeoutHandler.cancel();
            }
        });
    }
}

