/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.StorageGeneric;
import net.tomp2p.storage.StorageMemoryReplication;

public class StorageMemory
extends StorageGeneric {
    private final NavigableMap<Number480, Data> dataMap = new ConcurrentSkipListMap<Number480, Data>();
    private final Map<Number480, Long> timeoutMap = new ConcurrentHashMap<Number480, Long>();
    private final SortedMap<Long, Set<Number480>> timeoutMapRev = new ConcurrentSkipListMap<Long, Set<Number480>>();
    private final Map<Number320, PublicKey> protectedMap = new ConcurrentHashMap<Number320, PublicKey>();
    private final StorageMemoryReplication storageMemoryReplication = new StorageMemoryReplication();
    private final KeyLock<Long> timeoutLock = new KeyLock();

    @Override
    public boolean put(Number160 locationKey, Number160 domainKey, Number160 contentKey, Data value) {
        this.dataMap.put(new Number480(locationKey, domainKey, contentKey), value);
        return true;
    }

    @Override
    public Data get(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        return (Data)this.dataMap.get(new Number480(locationKey, domainKey, contentKey));
    }

    @Override
    public boolean contains(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        return this.dataMap.containsKey(new Number480(locationKey, domainKey, contentKey));
    }

    @Override
    public Data remove(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        return (Data)this.dataMap.remove(new Number480(locationKey, domainKey, contentKey));
    }

    @Override
    public SortedMap<Number480, Data> subMap(Number160 locationKey, Number160 domainKey, Number160 fromContentKey, Number160 toContentKey) {
        return this.dataMap.subMap(new Number480(locationKey, domainKey, fromContentKey), new Number480(locationKey, domainKey, toContentKey));
    }

    @Override
    public Map<Number480, Data> subMap(Number160 locationKey) {
        return this.dataMap.subMap(new Number480(locationKey, Number160.ZERO, Number160.ZERO), new Number480(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    @Override
    public NavigableMap<Number480, Data> map() {
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeout(Number160 locationKey, Number160 domainKey, Number160 contentKey, long expiration) {
        Number480 key = new Number480(locationKey, domainKey, contentKey);
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Lock lock1 = this.timeoutLock.lock(expiration);
        try {
            Set<Number480> tmp = this.putIfAbsent2(expiration, new HashSet<Number480>());
            tmp.add(key);
        }
        finally {
            this.timeoutLock.unlock(expiration, lock1);
        }
        if (oldExpiration == null) {
            return;
        }
        Lock lock2 = this.timeoutLock.lock(oldExpiration);
        try {
            this.removeRevTimeout(key, oldExpiration);
        }
        finally {
            this.timeoutLock.unlock(oldExpiration, lock2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeout(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Number480 key = new Number480(locationKey, domainKey, contentKey);
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        Lock lock = this.timeoutLock.lock(expiration);
        try {
            this.removeRevTimeout(key, expiration);
        }
        finally {
            this.timeoutLock.unlock(expiration, lock);
        }
    }

    private void removeRevTimeout(Number480 key, Long expiration) {
        Set tmp2;
        if (expiration != null && (tmp2 = (Set)this.timeoutMapRev.get(expiration)) != null) {
            tmp2.remove(key);
            if (tmp2.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number480> subMapTimeout(long to) {
        SortedMap<Long, Set<Number480>> tmp = this.timeoutMapRev.subMap(0L, to);
        ArrayList<Number480> toRemove = new ArrayList<Number480>();
        for (Map.Entry<Long, Set<Number480>> entry : tmp.entrySet()) {
            Lock lock = this.timeoutLock.lock(entry.getKey());
            try {
                toRemove.addAll((Collection<Number480>)entry.getValue());
            }
            finally {
                this.timeoutLock.unlock(entry.getKey(), lock);
            }
        }
        return toRemove;
    }

    @Override
    public boolean protectDomain(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        this.protectedMap.put(new Number320(locationKey, domainKey), publicKey);
        return true;
    }

    @Override
    public boolean isDomainProtectedByOthers(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        PublicKey other = this.protectedMap.get(new Number320(locationKey, domainKey));
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    @Override
    public void close() {
        this.dataMap.clear();
        this.protectedMap.clear();
        this.timeoutMap.clear();
        this.timeoutMapRev.clear();
    }

    private Set<Number480> putIfAbsent2(long expiration, Set<Number480> hashSet) {
        Set<Number480> timeouts = ((ConcurrentMap)((Object)this.timeoutMapRev)).putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.storageMemoryReplication.findPeerIDForResponsibleContent(locationKey);
    }

    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.storageMemoryReplication.findContentForResponsiblePeerID(peerID);
    }

    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        return this.storageMemoryReplication.updateResponsibilities(locationKey, peerId);
    }

    @Override
    public void removeResponsibility(Number160 locationKey) {
        this.storageMemoryReplication.removeResponsibility(locationKey);
    }
}

