/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureWrapper;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouting {
    private static final Logger logger = LoggerFactory.getLogger(DistributedRouting.class);
    private final NeighborRPC neighbors;
    private final PeerBean peerBean;
    private final Random rnd;

    public DistributedRouting(PeerBean peerBean, NeighborRPC neighbors) {
        this.neighbors = neighbors;
        this.peerBean = peerBean;
        this.rnd = new Random(peerBean.getServerPeerAddress().getID().hashCode());
    }

    public FutureWrapper<FutureRouting> bootstrap(final Collection<PeerAddress> peerAddresses, final int maxNoNewInfo, final int maxFailures, final int maxSuccess, final int parallel, final boolean forceTCP, final boolean isForceRoutingOnlyToSelf, final ChannelCreator cc) {
        if (logger.isDebugEnabled()) {
            logger.debug("broadcast to " + peerAddresses);
        }
        final FutureWrapper<FutureRouting> futureWrapper = new FutureWrapper<FutureRouting>();
        FutureRouting futureRouting = this.routing(peerAddresses, this.peerBean.getServerPeerAddress().getID(), null, null, 0, maxNoNewInfo, maxFailures, maxSuccess, parallel, Message.Type.REQUEST_1, forceTCP, cc, true, isForceRoutingOnlyToSelf);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting future) throws Exception {
                FutureRouting futureRouting = DistributedRouting.this.routing(peerAddresses, null, null, null, 0, maxNoNewInfo, maxFailures, maxSuccess, parallel, Message.Type.REQUEST_1, forceTCP, cc, true, isForceRoutingOnlyToSelf);
                futureWrapper.waitFor(futureRouting);
            }
        });
        return futureWrapper;
    }

    public FutureRouting route(Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, Message.Type type, int maxDirectHits, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, boolean forceTCP, ChannelCreator cc) {
        SortedSet<PeerAddress> startPeers = this.peerBean.getPeerMap().closePeers(locationKey, parallel * 2);
        return this.routing(startPeers, locationKey, domainKey, contentKeys, maxDirectHits, maxNoNewInfo, maxFailures, maxSuccess, parallel, type, forceTCP, cc, false, false);
    }

    private FutureRouting routing(Collection<PeerAddress> peerAddresses, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, int maxDirectHits, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, Message.Type type, boolean forceTCP, ChannelCreator cc, boolean isBootstrap, boolean isForceRoutingOnlyToSelf) {
        DigestInfo digestInfo;
        if (peerAddresses == null) {
            throw new IllegalArgumentException("you need to specify some nodes");
        }
        boolean randomSearch = locationKey == null;
        FutureResponse[] futureResponses = new FutureResponse[parallel];
        FutureRouting futureRouting = new FutureRouting();
        Comparator<PeerAddress> comparator = randomSearch ? this.peerBean.getPeerMap().createPeerComparator() : this.peerBean.getPeerMap().createPeerComparator(locationKey);
        TreeSet<PeerAddress> queueToAsk = new TreeSet<PeerAddress>(comparator);
        TreeSet<PeerAddress> alreadyAsked = new TreeSet<PeerAddress>(comparator);
        TreeMap<PeerAddress, DigestInfo> directHits = new TreeMap<PeerAddress, DigestInfo>(this.peerBean.getPeerMap().createPeerComparator());
        TreeSet<PeerAddress> potentialHits = new TreeSet<PeerAddress>(comparator);
        queueToAsk.addAll(peerAddresses);
        alreadyAsked.add(this.peerBean.getServerPeerAddress());
        potentialHits.add(this.peerBean.getServerPeerAddress());
        if (type == Message.Type.REQUEST_2 && domainKey != null && !randomSearch) {
            DigestInfo digestBean = this.peerBean.getStorage().digest(locationKey, domainKey, contentKeys);
            if (digestBean.getSize() > 0) {
                directHits.put(this.peerBean.getServerPeerAddress(), digestBean);
            }
        } else if (type == Message.Type.REQUEST_3 && !randomSearch) {
            digestInfo = this.peerBean.getTrackerStorage().digest(locationKey, domainKey, contentKeys);
            if (digestInfo.getSize() > 0) {
                directHits.put(this.peerBean.getServerPeerAddress(), digestInfo);
            }
        } else if (type == Message.Type.REQUEST_4 && !randomSearch && (digestInfo = this.peerBean.getTaskManager().digest()).getSize() > 0) {
            directHits.put(this.peerBean.getServerPeerAddress(), digestInfo);
        }
        if (peerAddresses.size() == 0) {
            futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked, isBootstrap, false);
        } else {
            boolean isRoutingOnlyToSelf = isForceRoutingOnlyToSelf || peerAddresses.size() == 1 && peerAddresses.iterator().next().equals(this.peerBean.getServerPeerAddress());
            this.routingRec(futureResponses, futureRouting, queueToAsk, alreadyAsked, directHits, potentialHits, new AtomicInteger(0), new AtomicInteger(0), new AtomicInteger(0), maxDirectHits, maxNoNewInfo, maxFailures, maxSuccess, parallel, locationKey, domainKey, contentKeys, true, type, forceTCP, false, cc, isBootstrap, !isRoutingOnlyToSelf);
        }
        return futureRouting;
    }

    private void routingRec(final FutureResponse[] futureResponses, final FutureRouting futureRouting, final NavigableSet<PeerAddress> queueToAsk, final SortedSet<PeerAddress> alreadyAsked, final SortedMap<PeerAddress, DigestInfo> directHits, final NavigableSet<PeerAddress> potentialHits, final AtomicInteger nrNoNewInfo, final AtomicInteger nrFailures, final AtomicInteger nrSuccess, final int maxDirectHits, final int maxNoNewInfo, final int maxFailures, final int maxSucess, final int parallel, final Number160 locationKey, final Number160 domainKey, final Collection<Number160> contentKeys, final boolean cancelOnFinish, final Message.Type type, final boolean forceTCP, boolean stopCreatingNewFutures, final ChannelCreator channelCreator, final boolean isBootstrap, final boolean isRoutingToOthers) {
        boolean randomSearch = locationKey == null;
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses[i] == null && !stopCreatingNewFutures) {
                PeerAddress next = randomSearch ? Utils.pollRandom(queueToAsk, this.rnd) : queueToAsk.pollFirst();
                if (next == null) continue;
                alreadyAsked.add(next);
                ++active;
                Number160 locationKey2 = randomSearch ? next.getID().xor(Number160.MAX_VALUE) : locationKey;
                futureResponses[i] = this.neighbors.closeNeighbors(next, locationKey2, domainKey, contentKeys, type, channelCreator, forceTCP);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("get close neighbors: " + next);
                continue;
            }
            if (futureResponses[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked, isBootstrap, isRoutingToOthers);
            DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
            return;
        }
        final boolean last = active == 1;
        FutureForkJoin fp = new FutureForkJoin(1, false, (BaseFuture[])futureResponses);
        fp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean stopCreatingNewFutures;
                boolean finished;
                if (future.isSuccess()) {
                    DigestInfo digestBean;
                    Message lastResponse = future.getLast().getResponse();
                    PeerAddress remotePeer = lastResponse.getSender();
                    potentialHits.add(remotePeer);
                    Collection<PeerAddress> newNeighbors = lastResponse.getNeighbors();
                    int resultSize = lastResponse.getInteger();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Peer (" + (resultSize > 0 ? "direct" : "none") + ") " + remotePeer + " reported " + newNeighbors);
                    }
                    Number160 resultHash = lastResponse.getKey();
                    Map<Number160, Number160> keyMap = lastResponse.getKeyMap();
                    if (DistributedRouting.evaluateDirectHits(keyMap, remotePeer, directHits, digestBean = new DigestInfo(resultHash, resultSize), maxDirectHits)) {
                        finished = true;
                        stopCreatingNewFutures = true;
                    } else if (nrSuccess.incrementAndGet() > maxSucess) {
                        finished = last;
                        stopCreatingNewFutures = true;
                    } else if (DistributedRouting.evaluateInformation(newNeighbors, queueToAsk, alreadyAsked, nrNoNewInfo, maxNoNewInfo)) {
                        finished = last;
                        stopCreatingNewFutures = true;
                    } else {
                        finished = false;
                        stopCreatingNewFutures = false;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Routing finished " + finished + "/" + stopCreatingNewFutures);
                    }
                } else {
                    stopCreatingNewFutures = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("finished routing, direct hits: " + directHits + ", potential: " + potentialHits);
                    }
                    futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked, isBootstrap, isRoutingToOthers);
                    DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
                } else {
                    DistributedRouting.this.routingRec(futureResponses, futureRouting, queueToAsk, alreadyAsked, directHits, potentialHits, nrNoNewInfo, nrFailures, nrSuccess, maxDirectHits, maxNoNewInfo, maxFailures, maxSucess, parallel, locationKey, domainKey, contentKeys, cancelOnFinish, type, forceTCP, stopCreatingNewFutures, channelCreator, isBootstrap, isRoutingToOthers);
                }
            }
        });
    }

    public static void cancel(boolean cancelOnFinish, int parallel, BaseFuture[] futureResponses) {
        if (cancelOnFinish) {
            for (int i = 0; i < parallel; ++i) {
                if (futureResponses[i] == null) continue;
                futureResponses[i].cancel();
            }
        }
    }

    static boolean evaluateDirectHits(Map<Number160, Number160> keyMap, PeerAddress remotePeer, Map<PeerAddress, DigestInfo> directHits, DigestInfo digestBean, int maxDirectHits) {
        if (digestBean.getSize() > 0) {
            directHits.put(remotePeer, digestBean);
            if (directHits.size() >= maxDirectHits) {
                return true;
            }
        }
        return false;
    }

    static boolean evaluateInformation(Collection<PeerAddress> newNeighbors, SortedSet<PeerAddress> queueToAsk, Set<PeerAddress> alreadyAsked, AtomicInteger noNewInfo, int maxNoNewInfo) {
        boolean newInformation = DistributedRouting.merge(queueToAsk, newNeighbors, alreadyAsked);
        if (newInformation) {
            noNewInfo.set(0);
            return false;
        }
        return noNewInfo.incrementAndGet() >= maxNoNewInfo;
    }

    static boolean merge(SortedSet<PeerAddress> queueToAsk, Collection<PeerAddress> newPeers, Collection<PeerAddress> alreadyAsked) {
        TreeSet<PeerAddress> result = new TreeSet<PeerAddress>(queueToAsk.comparator());
        Utils.difference(newPeers, result, alreadyAsked);
        if (result.size() == 0) {
            return false;
        }
        PeerAddress first = (PeerAddress)result.first();
        boolean newInfo = DistributedRouting.isNew(queueToAsk, first);
        queueToAsk.addAll(result);
        return newInfo;
    }

    private static boolean isNew(SortedSet<PeerAddress> queueToAsk, PeerAddress item) {
        if (queueToAsk.contains(item)) {
            return false;
        }
        SortedSet<PeerAddress> tmp = queueToAsk.headSet(item);
        return tmp.size() == 0;
    }
}

