/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import java.util.Arrays;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.Location;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;

final class LogicalRowIdManager {
    private final RecordFile file;
    private final PageManager pageman;
    static final short ELEMS_PER_PAGE = 680;
    private long[] freeRecordsInTransRowid = new long[4];
    private int freeRecordsInTransSize = 0;

    LogicalRowIdManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    long insert(long physloc) throws IOException {
        long retval = this.getFreeSlot();
        if (retval == 0L) {
            long firstPage = this.pageman.allocate((short)2);
            short curOffset = 14;
            for (int i = 0; i < 680; ++i) {
                this.putFreeSlot(Location.toLong(-firstPage, curOffset));
                curOffset = (short)(curOffset + 6);
            }
            retval = this.getFreeSlot();
            if (retval == 0L) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(retval, physloc);
        return retval;
    }

    void forceInsert(long logicalRowId, long physLoc) throws IOException {
        if (this.fetch(logicalRowId) != 0L) {
            throw new Error("can not forceInsert, record already exists: " + logicalRowId);
        }
        this.update(logicalRowId, physLoc);
    }

    void delete(long logicalrowid) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        xlatPage.pageHeaderSetLocation(Location.getOffset(logicalrowid), 0L);
        this.file.release(block, true);
        this.putFreeSlot(logicalrowid);
    }

    void update(long logicalrowid, long physloc) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        xlatPage.pageHeaderSetLocation(Location.getOffset(logicalrowid), physloc);
        this.file.release(block, true);
    }

    long fetch(long logicalrowid) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        long last = this.pageman.getLast((short)2);
        if (last - 1L > block) {
            return 0L;
        }
        short offset = Location.getOffset(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        long ret = xlatPage.pageHeaderGetLocation(offset);
        this.file.release(block, false);
        return ret;
    }

    void commit() throws IOException {
        short freePhysRowId;
        long rowid;
        short slot;
        BlockIo fp;
        int rowIdPos = 0;
        long current = this.pageman.getFirst((short)3);
        while (current != 0L) {
            fp = this.file.get(current);
            slot = fp.FreeLogicalRowId_getFirstFree();
            while (slot != -1 && rowIdPos < this.freeRecordsInTransSize) {
                rowid = this.freeRecordsInTransRowid[rowIdPos++];
                freePhysRowId = fp.FreeLogicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysRowId, rowid);
                slot = fp.FreeLogicalRowId_getFirstFree();
            }
            this.file.release(current, true);
            if (rowIdPos >= this.freeRecordsInTransSize) break;
            current = this.pageman.getNext(current);
        }
        while (rowIdPos < this.freeRecordsInTransSize) {
            long freePage = this.pageman.allocate((short)3);
            fp = this.file.get(freePage);
            slot = fp.FreeLogicalRowId_getFirstFree();
            while (slot != -1 && rowIdPos < this.freeRecordsInTransSize) {
                rowid = this.freeRecordsInTransRowid[rowIdPos++];
                freePhysRowId = fp.FreeLogicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysRowId, rowid);
                slot = fp.FreeLogicalRowId_getFirstFree();
            }
            this.file.release(freePage, true);
            if (rowIdPos < this.freeRecordsInTransSize) continue;
            break;
        }
        if (rowIdPos < this.freeRecordsInTransSize) {
            throw new InternalError();
        }
        if (this.freeRecordsInTransRowid.length > 128) {
            this.freeRecordsInTransRowid = new long[4];
        }
        this.freeRecordsInTransSize = 0;
    }

    void rollback() throws IOException {
        if (this.freeRecordsInTransRowid.length > 128) {
            this.freeRecordsInTransRowid = new long[4];
        }
        this.freeRecordsInTransSize = 0;
    }

    long getFreeSlot() throws IOException {
        if (this.freeRecordsInTransSize != 0) {
            return this.freeRecordsInTransRowid[--this.freeRecordsInTransSize];
        }
        long retval = 0L;
        long current = this.pageman.getFirst((short)3);
        while (current != 0L) {
            BlockIo fp = this.file.get(current);
            short slot = fp.FreeLogicalRowId_getFirstAllocated();
            if (slot != -1) {
                retval = fp.FreeLogicalRowId_slotToLocation(slot);
                fp.FreeLogicalRowId_free(slot);
                if (fp.FreeLogicalRowId_getCount() == 0) {
                    this.file.release(current, false);
                    this.pageman.free((short)3, current);
                } else {
                    this.file.release(current, true);
                }
                return retval;
            }
            this.file.release(current, false);
            current = this.pageman.getNext(current);
        }
        return 0L;
    }

    void putFreeSlot(long rowid) throws IOException {
        if (this.freeRecordsInTransSize == this.freeRecordsInTransRowid.length) {
            this.freeRecordsInTransRowid = Arrays.copyOf(this.freeRecordsInTransRowid, this.freeRecordsInTransRowid.length * 2);
        }
        this.freeRecordsInTransRowid[this.freeRecordsInTransSize] = rowid;
        ++this.freeRecordsInTransSize;
    }
}

