/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.kotek.jdbm.DBStore;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.HTree;
import net.kotek.jdbm.HTreeBucket;
import net.kotek.jdbm.LongPacker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HTreeDirectory<K, V> {
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[][] _children;
    private byte _depth;
    private transient long _recid;
    protected final HTree<K, V> tree;

    public HTreeDirectory(HTree<K, V> tree) {
        this.tree = tree;
    }

    HTreeDirectory(HTree<K, V> tree, byte depth) {
        this.tree = tree;
        this._depth = depth;
        this._children = new long[32][];
    }

    void setPersistenceContext(long recid) {
        this._recid = recid;
    }

    long getRecid() {
        return this._recid;
    }

    boolean isEmpty() {
        for (int i = 0; i < this._children.length; ++i) {
            long[] sub = this._children[i];
            if (sub == null) continue;
            for (int j = 0; j < 8; ++j) {
                if (sub[j] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    V get(K key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this.getRecid(hash);
        if (child_recid == 0L) {
            return null;
        }
        Object node = this.tree.getDB().fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HTreeDirectory) {
            HTreeDirectory dir = (HTreeDirectory)node;
            dir.setPersistenceContext(child_recid);
            return dir.get(key);
        }
        HTreeBucket bucket = (HTreeBucket)node;
        return bucket.getValue(key);
    }

    private long getRecid(int hash) {
        long[] sub = this._children[hash >>> 3];
        return sub == null ? 0L : sub[hash % 8];
    }

    private void putRecid(int hash, long recid) {
        long[] sub = this._children[hash >>> 3];
        if (sub == null) {
            sub = new long[8];
            this._children[hash >>> 3] = sub;
        }
        sub[hash % 8] = recid;
    }

    Object put(Object key, Object value) throws IOException {
        if (value == null) {
            return this.remove(key);
        }
        int hash = this.hashCode(key);
        long child_recid = this.getRecid(hash);
        if (child_recid == 0L) {
            HTreeBucket<Object, Object> bucket = new HTreeBucket<Object, Object>(this.tree, (byte)(this._depth + 1));
            Object existing = bucket.addElement(key, value);
            long b_recid = this.tree.getDB().insert(bucket, this.tree.SERIALIZER, false);
            this.putRecid(hash, b_recid);
            this.tree.getDB().update(this._recid, this, this.tree.SERIALIZER);
            return existing;
        }
        Object node = this.tree.getDB().fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HTreeDirectory) {
            HTreeDirectory dir = (HTreeDirectory)node;
            dir.setPersistenceContext(child_recid);
            return dir.put(key, value);
        }
        HTreeBucket bucket = (HTreeBucket)node;
        if (bucket.hasRoom()) {
            Object existing = bucket.addElement(key, value);
            this.tree.getDB().update(child_recid, bucket, this.tree.SERIALIZER);
            return existing;
        }
        if (this._depth == 3) {
            throw new RuntimeException("Cannot create deeper directory. Depth=" + this._depth);
        }
        HTreeDirectory<K, V> dir = new HTreeDirectory<K, V>(this.tree, (byte)(this._depth + 1));
        long dir_recid = this.tree.getDB().insert(dir, this.tree.SERIALIZER, false);
        dir.setPersistenceContext(dir_recid);
        this.putRecid(hash, dir_recid);
        this.tree.getDB().update(this._recid, this, this.tree.SERIALIZER);
        this.tree.getDB().delete(child_recid);
        ArrayList keys = bucket.getKeys();
        ArrayList values = bucket.getValues();
        int entries = keys.size();
        for (int i = 0; i < entries; ++i) {
            dir.put(keys.get(i), values.get(i));
        }
        return dir.put(key, value);
    }

    Object remove(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this.getRecid(hash);
        if (child_recid == 0L) {
            return null;
        }
        Object node = this.tree.getDB().fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HTreeDirectory) {
            HTreeDirectory dir = (HTreeDirectory)node;
            dir.setPersistenceContext(child_recid);
            Object existing = dir.remove(key);
            if (existing != null && dir.isEmpty()) {
                this.tree.getDB().delete(child_recid);
                this.putRecid(hash, 0L);
                this.tree.getDB().update(this._recid, this, this.tree.SERIALIZER);
            }
            return existing;
        }
        HTreeBucket bucket = (HTreeBucket)node;
        Object existing = bucket.removeElement(key);
        if (existing != null) {
            if (bucket.getElementCount() >= 1) {
                this.tree.getDB().update(child_recid, bucket, this.tree.SERIALIZER);
            } else {
                this.tree.getDB().delete(child_recid);
                this.putRecid(hash, 0L);
                this.tree.getDB().update(this._recid, this, this.tree.SERIALIZER);
            }
        }
        return existing;
    }

    private int hashCode(Object key) {
        int hashMask = this.hashMask();
        int hash = key.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this._depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this._depth) * 8;
        return hashMask;
    }

    Iterator<K> keys() throws IOException {
        return new HDIterator(true);
    }

    Iterator<V> values() throws IOException {
        return new HDIterator(false);
    }

    public void writeExternal(DataOutput out) throws IOException {
        int i;
        out.writeByte(this._depth);
        int zeroStart = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (this.getRecid(i2) == 0L) continue;
            zeroStart = i2;
            break;
        }
        out.write(zeroStart);
        if (zeroStart == 256) {
            return;
        }
        int zeroEnd = 0;
        for (i = 255; i >= 0; --i) {
            if (this.getRecid(i) == 0L) continue;
            zeroEnd = i;
            break;
        }
        out.write(zeroEnd);
        for (i = zeroStart; i <= zeroEnd; ++i) {
            LongPacker.packLong(out, this.getRecid(i));
        }
    }

    public void readExternal(DataInputOutput in) throws IOException, ClassNotFoundException {
        this._depth = in.readByte();
        this._children = new long[32][];
        int zeroStart = in.readUnsignedByte();
        int zeroEnd = in.readUnsignedByte();
        for (int i = zeroStart; i <= zeroEnd; ++i) {
            long recid = LongPacker.unpackLong(in);
            if (recid == 0L) continue;
            this.putRecid(i, recid);
        }
    }

    public void defrag(DBStore r1, DBStore r2) throws IOException, ClassNotFoundException {
        for (long[] sub : this._children) {
            if (sub == null) continue;
            for (long child : sub) {
                if (child == 0L) continue;
                byte[] data = r1.fetchRaw(child);
                r2.forceInsert(child, data);
                Object t = this.tree.SERIALIZER.deserialize(new DataInputOutput(data));
                if (!(t instanceof HTreeDirectory)) continue;
                ((HTreeDirectory)t).defrag(r1, r2);
            }
        }
    }

    void deleteAllChildren() throws IOException {
        for (long[] ll : this._children) {
            if (ll == null) continue;
            for (long l : ll) {
                if (l == 0L) continue;
                this.tree.getDB().delete(l);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HDIterator<A>
    implements Iterator<A> {
        private boolean _iterateKeys;
        private ArrayList _dirStack = new ArrayList();
        private ArrayList _childStack = new ArrayList();
        private HTreeDirectory _dir;
        private int _child;
        private Iterator<A> _iter;
        private A next;
        private A last;
        private int expectedModCount;

        HDIterator(boolean iterateKeys) throws IOException {
            this._dir = HTreeDirectory.this;
            this._child = -1;
            this._iterateKeys = iterateKeys;
            this.expectedModCount = HTreeDirectory.this.tree.modCount;
            this.prepareNext();
            this.next = this.next2();
        }

        public A next2() {
            A next = null;
            if (this._iter != null && this._iter.hasNext()) {
                next = this._iter.next();
            } else {
                try {
                    this.prepareNext();
                }
                catch (IOException except) {
                    throw new IOError(except);
                }
                if (this._iter != null && this._iter.hasNext()) {
                    return this.next2();
                }
            }
            return next;
        }

        private void prepareNext() throws IOException {
            long child_recid = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HTreeDirectory)this._dirStack.remove(this._dirStack.size() - 1);
                    this._child = (Integer)this._childStack.remove(this._childStack.size() - 1);
                    continue;
                }
                child_recid = this._dir.getRecid(this._child);
            } while (child_recid == 0L);
            if (child_recid == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            Object node = HTreeDirectory.this.tree.getDB().fetch(child_recid, HTreeDirectory.this.tree.SERIALIZER);
            if (node instanceof HTreeDirectory) {
                this._dirStack.add(this._dir);
                this._childStack.add(new Integer(this._child));
                this._dir = (HTreeDirectory)node;
                this._child = -1;
                this._dir.setPersistenceContext(child_recid);
                this.prepareNext();
            } else {
                HTreeBucket bucket = (HTreeBucket)node;
                if (this._iterateKeys) {
                    ArrayList keys2 = bucket.getKeys();
                    this._iter = keys2.iterator();
                } else {
                    this._iter = bucket.getValues().iterator();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public A next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != HTreeDirectory.this.tree.modCount) {
                throw new ConcurrentModificationException();
            }
            this.last = this.next;
            this.next = this.next2();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != HTreeDirectory.this.tree.modCount) {
                throw new ConcurrentModificationException();
            }
            HTreeDirectory.this.tree.remove(this.last);
            this.last = null;
            ++this.expectedModCount;
        }
    }
}

