/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import net.kotek.jdbm.BTree;
import net.kotek.jdbm.BTreeSet;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.RecordListener;
import net.kotek.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V> {
    protected final BTree<K, V> tree;
    protected final K fromKey;
    protected final K toKey;
    protected final boolean readonly;
    protected NavigableSet<K> keySet2;
    private final boolean toInclusive;
    private final boolean fromInclusive;
    private final Set<Map.Entry<K, V>> _entrySet = new AbstractSet<Map.Entry<K, V>>(){

        protected Map.Entry<K, V> newEntry(K k, V v) {
            return new AbstractMap.SimpleEntry<K, V>(k, v){
                private static final long serialVersionUID = 978651696969194154L;

                @Override
                public V setValue(V arg0) {
                    BTreeMap.this.put(this.getKey(), arg0);
                    return super.setValue(arg0);
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            if (BTreeMap.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            try {
                if (e.getKey() == null) {
                    throw new NullPointerException("Can not add null key");
                }
                if (!BTreeMap.this.inBounds(e.getKey())) {
                    throw new IllegalArgumentException("key outside of bounds");
                }
                return BTreeMap.this.tree.insert(e.getKey(), e.getValue(), true) == null;
            }
            catch (IOException e1) {
                throw new IOError(e1);
            }
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                try {
                    if (!BTreeMap.this.inBounds(e.getKey())) {
                        return false;
                    }
                    if (e.getKey() != null && BTreeMap.this.tree.get(e.getKey()) != null) {
                        return true;
                    }
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            try {
                final BTree.BTreeTupleBrowser br = BTreeMap.this.fromKey == null ? BTreeMap.this.tree.browse() : BTreeMap.this.tree.browse(BTreeMap.this.fromKey, BTreeMap.this.fromInclusive);
                return new Iterator<Map.Entry<K, V>>(){
                    private Map.Entry<K, V> next;
                    private K lastKey;
                    {
                        this.ensureNext();
                    }

                    void ensureNext() {
                        try {
                            BTree.BTreeTuple t = new BTree.BTreeTuple();
                            this.next = br.getNext(t) && BTreeMap.this.inBounds(t.key) ? this.newEntry(t.key, t.value) : null;
                        }
                        catch (IOException e1) {
                            throw new IOError(e1);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry ret = this.next;
                        this.lastKey = ret.getKey();
                        this.ensureNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        if (BTreeMap.this.readonly) {
                            throw new UnsupportedOperationException("readonly");
                        }
                        if (this.lastKey == null) {
                            throw new IllegalStateException();
                        }
                        try {
                            br.remove(this.lastKey);
                            this.lastKey = null;
                        }
                        catch (IOException e1) {
                            throw new IOError(e1);
                        }
                    }
                };
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public boolean remove(Object o) {
            if (BTreeMap.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                try {
                    if (e.getKey() == null || e.getValue() == null) {
                        return false;
                    }
                    if (!BTreeMap.this.inBounds(e.getKey())) {
                        throw new IllegalArgumentException("out of bounds");
                    }
                    Object v = BTreeMap.this.get(e.getKey());
                    if (v == null || !e.getValue().equals(v)) {
                        return false;
                    }
                    Object v2 = BTreeMap.this.tree.remove(e.getKey());
                    return v2 != null;
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }
            return false;
        }

        @Override
        public int size() {
            return BTreeMap.this.size();
        }

        @Override
        public void clear() {
            if (BTreeMap.this.fromKey != null || BTreeMap.this.toKey != null) {
                super.clear();
            } else {
                try {
                    BTreeMap.this.tree.clear();
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
    };

    public BTreeMap(BTree<K, V> tree, boolean readonly) {
        this(tree, readonly, null, false, null, false);
    }

    protected BTreeMap(BTree<K, V> tree, boolean readonly, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        this.tree = tree;
        this.fromKey = fromKey;
        this.fromInclusive = fromInclusive;
        this.toKey = toKey;
        this.toInclusive = toInclusive;
        this.readonly = readonly;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    public boolean inBounds(K e) {
        int compare;
        if (this.fromKey == null && this.toKey == null) {
            return true;
        }
        Comparator comp = this.comparator();
        if (comp == null) {
            comp = Utils.COMPARABLE_COMPARATOR;
        }
        if (this.fromKey != null) {
            compare = comp.compare(e, this.fromKey);
            if (compare < 0) {
                return false;
            }
            if (!this.fromInclusive && compare == 0) {
                return false;
            }
        }
        if (this.toKey != null) {
            compare = comp.compare(e, this.toKey);
            if (compare > 0) {
                return false;
            }
            if (!this.toInclusive && compare == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public V get(Object key) {
        try {
            if (key == null) {
                return null;
            }
            if (!this.inBounds(key)) {
                return null;
            }
            return this.tree.get(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || this.tree.get(key) == null) {
                return null;
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.remove(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || value == null) {
                throw new NullPointerException("Null key or value");
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.insert(key, value, true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        try {
            if (!this.inBounds(key)) {
                return false;
            }
            V v = this.tree.get(key);
            return v != null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.tree._comparator;
    }

    @Override
    public K firstKey() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            BTree.BTreeTupleBrowser b = this.fromKey == null ? this.tree.browse() : this.tree.browse(this.fromKey, this.fromInclusive);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getNext(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public K lastKey() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            BTree.BTreeTupleBrowser b = this.toKey == null ? this.tree.browse(null, true) : this.tree.browse(this.toKey, false);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getPrevious(t);
            if (!this.toInclusive && this.toKey != null) {
                Comparator c = this.comparator();
                if (c == null) {
                    c = Utils.COMPARABLE_COMPARATOR;
                }
                if (c.compare(t.key, this.toKey) == 0) {
                    b.getPrevious(t);
                }
            }
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey2, boolean inclusive) {
        K toKey3 = Utils.min(this.toKey, toKey2, this.comparator());
        boolean inclusive2 = toKey3 == this.toKey ? this.toInclusive : inclusive;
        return new BTreeMap<K, V>(this.tree, this.readonly, this.fromKey, this.fromInclusive, toKey3, inclusive2);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        K k = this.lowerKey(key);
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public K lowerKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        K key2 = Utils.min(key, this.toKey, this.comparator());
        try {
            BTree.BTreeTupleBrowser b = this.tree.browse(key2, true);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getPrevious(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        K k = this.floorKey(key);
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public K floorKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        K key2 = Utils.max(key, this.fromKey, this.comparator());
        try {
            BTree.BTreeTupleBrowser b = this.tree.browse(key2, true);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getNext(t);
            Comparator comp = this.comparator();
            if (comp == null) {
                comp = Utils.COMPARABLE_COMPARATOR;
            }
            if (comp.compare(t.key, key2) == 0) {
                return t.key;
            }
            b.getPrevious(t);
            b.getPrevious(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        K k = this.ceilingKey(key);
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public K ceilingKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        K key2 = Utils.min(key, this.toKey, this.comparator());
        try {
            BTree.BTreeTupleBrowser b = this.tree.browse(key2, true);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getNext(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        K k = this.higherKey(key);
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public K higherKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        K key2 = Utils.max(key, this.fromKey, this.comparator());
        try {
            BTree.BTreeTupleBrowser b = this.tree.browse(key2, false);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getNext(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        K k = this.firstKey();
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        K k = this.lastKey();
        return k == null ? null : new AbstractMap.SimpleEntry<K, V>(k, this.get(k));
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> first = this.firstEntry();
        if (first != null) {
            this.remove(first.getKey());
        }
        return first;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> last = this.lastEntry();
        if (last != null) {
            this.remove(last.getKey());
        }
        return last;
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        if (this.keySet2 == null) {
            this.keySet2 = new BTreeSet<K>(this);
        }
        return this.keySet2;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey2, boolean inclusive) {
        K fromKey3 = Utils.max(this.fromKey, fromKey2, this.comparator());
        boolean inclusive2 = fromKey3 == this.toKey ? this.toInclusive : inclusive;
        return new BTreeMap<K, V>(this.tree, this.readonly, fromKey3, inclusive2, this.toKey, this.toInclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        Comparator comp = this.comparator();
        if (comp == null) {
            comp = Utils.COMPARABLE_COMPARATOR;
        }
        if (comp.compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException("fromKey is bigger then toKey");
        }
        return new BTreeMap<K, V>(this.tree, this.readonly, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    public BTree<K, V> getTree() {
        return this.tree;
    }

    public void addRecordListener(RecordListener<K, V> listener) {
        this.tree.addRecordListener(listener);
    }

    public DBAbstract getRecordManager() {
        return this.tree.getRecordManager();
    }

    public void removeRecordListener(RecordListener<K, V> listener) {
        this.tree.removeRecordListener(listener);
    }

    @Override
    public int size() {
        if (this.fromKey == null && this.toKey == null) {
            return this.tree.size();
        }
        Iterator iter = this.keySet().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.tree.lock.writeLock().lock();
        try {
            if (!this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = this.get(key);
            return v;
        }
        finally {
            this.tree.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.tree.lock.writeLock().lock();
        try {
            if (this.containsKey(key) && this.get(key).equals(value)) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.tree.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.tree.lock.writeLock().lock();
        try {
            if (this.containsKey(key) && this.get(key).equals(oldValue)) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.tree.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.tree.lock.writeLock().lock();
        try {
            if (this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.tree.lock.writeLock().unlock();
        }
    }
}

