/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeLazyRecord<E> {
    private E value = null;
    private DBAbstract db;
    private Serializer<E> serializer;
    final long recid;
    static final Serializer FAKE_SERIALIZER = new Serializer(){

        public void serialize(DataOutput out, Object obj) throws IOException {
            byte[] data = (byte[])obj;
            out.write(data);
        }

        public Object deserialize(DataInput in) throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException();
        }
    };
    static final int MAX_INTREE_RECORD_SIZE = 32;
    static final int NULL = 255;
    static final int LAZY_RECORD = 254;

    BTreeLazyRecord(DBAbstract db, long recid, Serializer<E> serializer) {
        this.db = db;
        this.recid = recid;
        this.serializer = serializer;
    }

    E get() {
        if (this.value != null) {
            return this.value;
        }
        try {
            this.value = this.db.fetch(this.recid, this.serializer);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.value;
    }

    void delete() {
        try {
            this.db.delete(this.recid);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.value = null;
        this.serializer = null;
        this.db = null;
    }

    static Object fastDeser(DataInputOutput in, Serializer serializer, int expectedSize) throws IOException, ClassNotFoundException {
        int origAvail = in.available();
        if (origAvail == 0) {
            throw new InternalError();
        }
        Object ret = serializer.deserialize(in);
        int readed = origAvail - in.available();
        if (readed > expectedSize) {
            throw new IOException("Serializer readed more bytes than is record size.");
        }
        if (readed != expectedSize) {
            for (int ii = 0; ii < expectedSize - readed; ++ii) {
                in.readUnsignedByte();
            }
        }
        return ret;
    }
}

