/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.File;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import net.kotek.jdbm.DB;
import net.kotek.jdbm.DBMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.KeyLock;
import net.tomp2p.storage.StorageGeneric;

public class StorageDisk
extends StorageGeneric {
    private final DB db;
    private final NavigableMap<Number480, Data> dataMap;
    private final Map<Number480, Long> timeoutMap;
    private final SortedMap<Long, Set<Number480>> timeoutMapRev;
    private final Map<Number320, byte[]> protectedMap;
    private final Map<Number160, Number160> responsibilityMap;
    private final Map<Number160, Set<Number160>> responsibilityMapRev;
    private final KeyLock<Number160> responsibilityLock = new KeyLock();
    private final KeyLock<Long> timeoutLock = new KeyLock();

    public StorageDisk(String fileName) {
        this.db = new DBMaker(fileName + File.separator + "tomp2p").build();
        this.dataMap = this.db.createTreeMap("dataMap");
        this.timeoutMap = this.db.createHashMap("timeoutMap");
        this.timeoutMapRev = this.db.createTreeMap("timeoutMapRev");
        this.protectedMap = this.db.createHashMap("protectedMap");
        this.responsibilityMap = this.db.createHashMap("responsibilityMap");
        this.responsibilityMapRev = this.db.createHashMap("responsibilityMapRev");
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public boolean put(Number160 locationKey, Number160 domainKey, Number160 contentKey, Data value) {
        this.dataMap.put(new Number480(locationKey, domainKey, contentKey), value);
        this.db.commit();
        return true;
    }

    @Override
    public Data get(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        return (Data)this.dataMap.get(new Number480(locationKey, domainKey, contentKey));
    }

    @Override
    public boolean contains(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        return this.dataMap.containsKey(new Number480(locationKey, domainKey, contentKey));
    }

    @Override
    public Data remove(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Data retVal = (Data)this.dataMap.remove(new Number480(locationKey, domainKey, contentKey));
        this.db.commit();
        return retVal;
    }

    @Override
    public SortedMap<Number480, Data> subMap(Number160 locationKey, Number160 domainKey, Number160 fromContentKey, Number160 toContentKey) {
        return this.dataMap.subMap(new Number480(locationKey, domainKey, fromContentKey), new Number480(locationKey, domainKey, toContentKey));
    }

    @Override
    public Map<Number480, Data> subMap(Number160 locationKey) {
        return this.dataMap.subMap(new Number480(locationKey, Number160.ZERO, Number160.ZERO), new Number480(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    @Override
    public NavigableMap<Number480, Data> map() {
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeout(Number160 locationKey, Number160 domainKey, Number160 contentKey, long expiration) {
        Number480 key = new Number480(locationKey, domainKey, contentKey);
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        Lock lock1 = this.timeoutLock.lock(expiration);
        try {
            Set<Number480> tmp = this.putIfAbsent2(expiration, new HashSet<Number480>());
            tmp.add(key);
        }
        finally {
            this.timeoutLock.unlock(expiration, lock1);
        }
        if (oldExpiration == null) {
            return;
        }
        Lock lock2 = this.timeoutLock.lock(oldExpiration);
        try {
            this.removeRevTimeout(key, oldExpiration);
        }
        finally {
            this.timeoutLock.unlock(oldExpiration, lock2);
        }
        this.db.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeout(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Number480 key = new Number480(locationKey, domainKey, contentKey);
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        Lock lock = this.timeoutLock.lock(expiration);
        try {
            this.removeRevTimeout(key, expiration);
        }
        finally {
            this.timeoutLock.unlock(expiration, lock);
        }
        this.db.commit();
    }

    private void removeRevTimeout(Number480 key, Long expiration) {
        Set tmp2;
        if (expiration != null && (tmp2 = (Set)this.timeoutMapRev.get(expiration)) != null) {
            tmp2.remove(key);
            if (tmp2.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number480> subMapTimeout(long to) {
        SortedMap<Long, Set<Number480>> tmp = this.timeoutMapRev.subMap(0L, to);
        ArrayList<Number480> toRemove = new ArrayList<Number480>();
        for (Map.Entry<Long, Set<Number480>> entry : tmp.entrySet()) {
            Lock lock = this.timeoutLock.lock(entry.getKey());
            try {
                toRemove.addAll((Collection<Number480>)entry.getValue());
            }
            finally {
                this.timeoutLock.unlock(entry.getKey(), lock);
            }
        }
        return toRemove;
    }

    @Override
    public boolean protectDomain(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        byte[] encodedPublicKey = publicKey.getEncoded();
        this.protectedMap.put(new Number320(locationKey, domainKey), encodedPublicKey);
        this.db.commit();
        return true;
    }

    @Override
    public boolean isDomainProtectedByOthers(Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        byte[] encodedOther = this.protectedMap.get(new Number320(locationKey, domainKey));
        if (encodedOther == null) {
            return false;
        }
        if (publicKey == null) {
            return true;
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encodedOther);
        try {
            String alg = publicKey.getAlgorithm();
            KeyFactory keyFactory = KeyFactory.getInstance(alg);
            PublicKey other = keyFactory.generatePublic(pubKeySpec);
            return !publicKey.equals(other);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        Collection contentIDs = this.responsibilityMapRev.get(peerID);
        if (contentIDs == null) {
            return Collections.emptyList();
        }
        Lock lock = this.responsibilityLock.lock(peerID);
        try {
            ArrayList<Number160> arrayList = new ArrayList<Number160>(contentIDs);
            return arrayList;
        }
        finally {
            this.responsibilityLock.unlock(peerID, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        boolean isNew = true;
        Number160 oldPeerId = this.responsibilityMap.put(locationKey, peerId);
        Lock lock1 = this.responsibilityLock.lock(peerId);
        try {
            Set<Number160> contentIDs = this.putIfAbsent1(peerId, new HashSet<Number160>());
            contentIDs.add(locationKey);
        }
        finally {
            this.responsibilityLock.unlock(peerId, lock1);
        }
        if (oldPeerId != null) {
            isNew = !oldPeerId.equals(peerId);
            Lock lock2 = this.responsibilityLock.lock(oldPeerId);
            try {
                this.removeRevResponsibility(oldPeerId, locationKey);
            }
            finally {
                this.responsibilityLock.unlock(oldPeerId, lock2);
            }
        }
        this.db.commit();
        return isNew;
    }

    private Set<Number160> putIfAbsent1(Number160 peerId, Set<Number160> hashSet) {
        Set<Number160> contentIDs = ((ConcurrentMap)this.responsibilityMapRev).putIfAbsent(peerId, hashSet);
        return contentIDs == null ? hashSet : contentIDs;
    }

    private Set<Number480> putIfAbsent2(long expiration, Set<Number480> hashSet) {
        Set<Number480> timeouts = ((ConcurrentMap)((Object)this.timeoutMapRev)).putIfAbsent(expiration, hashSet);
        return timeouts == null ? hashSet : timeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponsibility(Number160 locationKey) {
        Number160 peerId = this.responsibilityMap.remove(locationKey);
        if (peerId == null) {
            return;
        }
        Lock lock = this.responsibilityLock.lock(peerId);
        try {
            this.removeRevResponsibility(peerId, locationKey);
        }
        finally {
            this.responsibilityLock.unlock(peerId, lock);
        }
        this.db.commit();
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        if (peerId == null || locationKey == null) {
            throw new IllegalArgumentException("both keys must not be null");
        }
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            }
        }
    }
}

