/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class KeyLock<K> {
    private final ReentrantLock lockInternal = new ReentrantLock();
    private final HashMap<K, RefCounterLock> cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock(K key) {
        RefCounterLock cur;
        this.lockInternal.lock();
        try {
            if (!this.cache.containsKey(key)) {
                cur = new RefCounterLock();
                this.cache.put(key, cur);
            } else {
                cur = this.cache.get(key);
            }
            cur.counter++;
        }
        finally {
            this.lockInternal.unlock();
        }
        cur.sem.lock();
        return cur.sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(K key, Lock lock) {
        RefCounterLock cur = null;
        this.lockInternal.lock();
        try {
            if (this.cache.containsKey(key)) {
                cur = this.cache.get(key);
                if (lock != cur.sem) {
                    throw new IllegalArgumentException("lock does not matches the stored lock");
                }
                cur.counter--;
                cur.sem.unlock();
                if (cur.counter == 0) {
                    this.cache.remove(key);
                }
            }
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheSize() {
        this.lockInternal.lock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    private class RefCounterLock {
        public final ReentrantLock sem = new ReentrantLock();
        private volatile int counter = 0;

        private RefCounterLock() {
        }
    }
}

