/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;

public class QuitRPC
extends ReplyHandler {
    public QuitRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.QUIT);
    }

    public FutureResponse quit(PeerAddress remotePeer, ChannelCreator channelCreator, boolean forceTCP) {
        Message message = this.createMessage(remotePeer, Message.Command.QUIT, Message.Type.REQUEST_FF_1);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceTCP) {
            RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return requestHandler.fireAndForgetUDP(channelCreator);
        }
        RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return requestHandler.fireAndForgetTCP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (message.getType() != Message.Type.REQUEST_FF_1 || message.getCommand() != Message.Command.QUIT) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        this.getPeerBean().getPeerMap().peerOffline(message.getSender(), true);
        return message;
    }
}

