/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(NeighborRPC.class);
    public static final int NEIGHBOR_SIZE = 20;

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.NEIGHBORS);
    }

    public FutureResponse closeNeighbors(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, Message.Type type, ChannelCreator channelCreator, boolean forceTCP) {
        this.nullCheck(remotePeer, locationKey);
        Message message = this.createMessage(remotePeer, Message.Command.NEIGHBORS, type);
        if (!message.isRequest()) {
            throw new IllegalArgumentException("The type must be a request");
        }
        message.setKeyKey(locationKey, domainKey == null ? Number160.ZERO : domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        if (!forceTCP) {
            FutureResponse futureResponse = new FutureResponse(message);
            NeighborsRequestUDP request = new NeighborsRequestUDP(this, futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendUDP(channelCreator);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        NeighborsRequestTCP request = new NeighborsRequestTCP(this, futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendTCP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws IOException {
        boolean isDigest;
        this.nullCheck(message.getKeyKey1(), message.getKeyKey2());
        if (message.getContentType1() != Message.Content.KEY_KEY || message.getContentType2() != Message.Content.EMPTY && message.getContentType2() != Message.Content.SET_KEYS || message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 && message.getType() != Message.Type.REQUEST_3 && message.getType() != Message.Type.REQUEST_4 || message.getCommand() != Message.Command.NEIGHBORS) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        SortedSet<PeerAddress> neighbors = this.getPeerBean().getPeerMap().closePeers(locationKey, 20);
        responseMessage.setNeighbors(neighbors, 20);
        Collection<Number160> contentKeys = message.getKeys();
        boolean bl = isDigest = message.getType() != Message.Type.REQUEST_1;
        if (isDigest) {
            if (message.getType() == Message.Type.REQUEST_2) {
                DigestInfo digestInfo = this.getPeerBean().getStorage().digest(locationKey, domainKey, contentKeys);
                responseMessage.setInteger(digestInfo.getSize());
                responseMessage.setKey(digestInfo.getKeyDigest());
            } else if (message.getType() == Message.Type.REQUEST_3) {
                DigestInfo digestInfo = this.getPeerBean().getTrackerStorage().digest(locationKey, domainKey, null);
                if (logger.isDebugEnabled() && digestInfo.getSize() == 0) {
                    logger.debug("No entry found on peer " + message.getRecipient());
                }
                responseMessage.setInteger(digestInfo.getSize());
            } else if (message.getType() == Message.Type.REQUEST_4) {
                DigestInfo digestInfo = this.getPeerBean().getTaskManager().digest();
                responseMessage.setInteger(digestInfo.getSize());
            }
        }
        return responseMessage;
    }

    private void preHandleMessage(Message message, PeerMap peerMap, PeerAddress referrer) {
        if (message.getType() != Message.Type.OK || message.getCommand() != Message.Command.NEIGHBORS) {
            if (logger.isDebugEnabled()) {
                logger.debug("Message not of type Neighbor, ignoring " + message);
            }
            return;
        }
        Collection<PeerAddress> tmp = message.getNeighbors();
        if (tmp != null) {
            Iterator<PeerAddress> iterator = tmp.iterator();
            while (iterator.hasNext()) {
                PeerAddress addr = iterator.next();
                if (peerMap.isPeerRemovedTemporarly(addr)) {
                    iterator.remove();
                    continue;
                }
                peerMap.peerFound(addr, referrer);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Neighbor message received, but does not contain any neighbors.");
        }
    }

    private static class NeighborsRequestUDP<K extends FutureResponse>
    extends RequestHandlerUDP<K> {
        private final Message message;
        final /* synthetic */ NeighborRPC this$0;

        public NeighborsRequestUDP(K futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
            this.this$0 = var1_1;
            super(futureResponse, peerBean, connectionBean, message);
            this.message = message;
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Object object = e.getMessage();
            if (object instanceof Message) {
                this.this$0.preHandleMessage((Message)object, this.getPeerMap(), this.message.getRecipient());
            } else {
                logger.error("Response received, but not a message: " + object);
            }
            super.messageReceived(ctx, e);
        }
    }

    private static class NeighborsRequestTCP<K extends FutureResponse>
    extends RequestHandlerTCP<K> {
        private final Message message;
        final /* synthetic */ NeighborRPC this$0;

        public NeighborsRequestTCP(K futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
            this.this$0 = var1_1;
            super(futureResponse, peerBean, connectionBean, message);
            this.message = message;
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent ce) throws Exception {
            this.this$0.preHandleMessage(this.message, this.getPeerMap(), this.message.getRecipient());
            super.handleUpstream(ctx, ce);
        }
    }
}

