/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.storage.ReplicationStorage;

public class Replication
implements PeerMapChangeListener {
    private final List<ResponsibilityListener> listeners = new ArrayList<ResponsibilityListener>();
    private final PeerMap peerMap;
    private final PeerAddress selfAddress;
    private final ReplicationStorage replicationStorage;

    public Replication(ReplicationStorage replicationStorage, PeerAddress selfAddress, PeerMap peerMap) {
        this.replicationStorage = replicationStorage;
        this.selfAddress = selfAddress;
        this.peerMap = peerMap;
        peerMap.addPeerMapChangeListener(this);
    }

    public boolean isReplicationEnabled() {
        return this.peerMap != null && this.selfAddress != null;
    }

    public void addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.add(responsibilityListener);
    }

    public void removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.remove(responsibilityListener);
    }

    public void checkResponsibility(Number160 locationKey) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        PeerAddress closest = this.closest(locationKey);
        if (closest.getID().equals(this.selfAddress.getID())) {
            if (this.replicationStorage.updateResponsibilities(locationKey, closest.getID())) {
                this.notifyMeResponsible(locationKey);
            }
        } else if (this.replicationStorage.updateResponsibilities(locationKey, closest.getID())) {
            this.notifyOtherResponsible(locationKey, closest);
        }
    }

    public void updatePeerMapIfCloser(Number160 locationKey, Number160 current) {
        if (!this.isReplicationEnabled() || current.equals(this.selfAddress.getID())) {
            return;
        }
        Number160 test = this.replicationStorage.findPeerIDForResponsibleContent(locationKey);
        if (test == null || this.peerMap.isCloser(locationKey, current, test) == -1) {
            this.replicationStorage.updateResponsibilities(locationKey, current);
        }
    }

    @Override
    public void peerInserted(PeerAddress peerAddress) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        Collection<Number160> myResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(this.selfAddress.getID());
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            PeerAddress closest = this.closest(myResponsibleLocation);
            if (closest.getID().equals(this.selfAddress.getID()) || !this.replicationStorage.updateResponsibilities(myResponsibleLocation, closest.getID())) continue;
            this.notifyOtherResponsible(myResponsibleLocation, closest);
        }
    }

    @Override
    public void peerRemoved(PeerAddress peerAddress) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        Collection<Number160> otherResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(peerAddress.getID());
        if (otherResponsibleLocations == null) {
            return;
        }
        for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
            PeerAddress closest = this.closest(otherResponsibleLocation);
            if (!closest.getID().equals(this.selfAddress.getID()) || !this.replicationStorage.updateResponsibilities(otherResponsibleLocation, closest.getID())) continue;
            this.notifyMeResponsible(otherResponsibleLocation);
        }
    }

    @Override
    public void peerUpdated(PeerAddress peerAddress) {
    }

    private void notifyMeResponsible(Number160 locationKey) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey);
        }
    }

    private void notifyOtherResponsible(Number160 locationKey, PeerAddress other) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.otherResponsible(locationKey, other);
        }
    }

    private PeerAddress closest(Number160 locationKey) {
        SortedSet<PeerAddress> tmp = this.peerMap.closePeers(locationKey, 1);
        tmp.add(this.selfAddress);
        return (PeerAddress)tmp.iterator().next();
    }
}

