/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.p2p.ConnectionConfiguration;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTask;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.IdentityManagement;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapKadImpl;
import net.tomp2p.replication.DefaultStorageReplication;
import net.tomp2p.replication.Replication;
import net.tomp2p.replication.TrackerStorageReplication;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TaskRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.StorageGeneric;
import net.tomp2p.storage.StorageMemory;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.task.AsyncTask;
import net.tomp2p.task.TaskManager;
import net.tomp2p.utils.Utils;

public class PeerMaker {
    private static final KeyPair EMPTY_KEYPAIR = new KeyPair(null, null);
    private final Number160 peerId;
    private int p2pID = 1;
    private KeyPair keyPair = EMPTY_KEYPAIR;
    private int workerThreads = Runtime.getRuntime().availableProcessors() + 1;
    private int maintenanceThreads = 5;
    private int replicationThreads = 5;
    private int replicationRefreshMillis = 60000;
    private int tcpPort = 7700;
    private int udpPort = 7700;
    private Peer masterPeer = null;
    private File fileMessageLogger = null;
    private Bindings bindings = new Bindings();
    private ConnectionConfiguration configuration = new ConnectionConfiguration();
    private StorageGeneric storage = new StorageMemory();
    private int maxMessageSize = 0x200000;
    private int bagSize = 2;
    private int cacheTimeoutMillis = 60000;
    private int maxNrBeforeExclude = 2;
    private int[] waitingTimeBetweenNodeMaintenenceSeconds = new int[]{5, 10, 20, 40, 80, 160};
    private int cacheSize = 100;
    private boolean isBehindFirewallPeerMap = false;
    private boolean enableHandShakeRPC = true;
    private boolean enableStorageRPC = true;
    private boolean enableNeighborRPC = true;
    private boolean enableQuitRPC = true;
    private boolean enablePeerExchangeRPC = true;
    private boolean enableDirectDataRPC = true;
    private boolean enableTrackerRPC = true;
    private boolean enableTaskRPC = true;
    private boolean enableRouting = true;
    private boolean enableDHT = true;
    private boolean enableTracker = true;
    private boolean enableTask = false;
    private boolean enableMaintenance = true;
    private boolean enableIndirectReplication = false;

    public PeerMaker(Number160 peerId) {
        this.peerId = peerId;
    }

    public PeerMaker(KeyPair keyPair) {
        this.peerId = Utils.makeSHAHash(keyPair.getPublic().getEncoded());
        this.keyPair = keyPair;
    }

    public Peer buildAndListen() throws IOException {
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.getBagSize(), this.getCacheTimeoutMillis(), this.getMaxNrBeforeExclude(), this.getWaitingTimeBetweenNodeMaintenenceSeconds(), this.getCacheSize(), this.isBehindFirewallPeerMap());
        Peer peer = new Peer(this.getP2PId(), this.peerId, this.keyPair, this.getMaintenanceThreads(), this.getReplicationThreads(), this.getConfiguration(), peerMap, this.getMaxMessageSize());
        ConnectionHandler connectionHandler = this.getMasterPeer() != null ? peer.listen(this.getMasterPeer()) : peer.listen(this.udpPort, this.tcpPort, this.bindings, this.fileMessageLogger);
        this.init(peer, connectionHandler, peerMap.getStatistics());
        return peer;
    }

    private void init(Peer peer, ConnectionHandler connectionHandler, Statistics statistics) {
        PeerBean peerBean = connectionHandler.getPeerBean();
        peerBean.setStatistics(statistics);
        ConnectionBean connectionBean = connectionHandler.getConnectionBean();
        PeerAddress selfAddress = peerBean.getServerPeerAddress();
        PeerMap peerMap = peerBean.getPeerMap();
        peerBean.setStorage(this.getStorage());
        Replication replicationStorage = new Replication(this.getStorage(), selfAddress, peerMap);
        peerBean.setReplicationStorage(replicationStorage);
        IdentityManagement identityManagement = new IdentityManagement(selfAddress);
        Maintenance maintenance = new Maintenance();
        TrackerStorage storageTracker = new TrackerStorage(identityManagement, this.configuration.getTrackerTimoutSeconds(), peerBean, maintenance);
        peerBean.setTrackerStorage(storageTracker);
        Replication replicationTracker = new Replication(storageTracker, selfAddress, peerMap);
        peerBean.setReplicationTracker(replicationTracker);
        peerMap.addPeerOfflineListener(storageTracker);
        if (this.isEnableHandShakeRPC()) {
            HandshakeRPC handshakeRCP = new HandshakeRPC(peerBean, connectionBean, peer.getListeners());
            peer.setHandshakeRPC(handshakeRCP);
        }
        if (this.isEnableStorageRPC()) {
            StorageRPC storageRPC = new StorageRPC(peerBean, connectionBean);
            peer.setStorageRPC(storageRPC);
        }
        if (this.isEnableNeighborRPC()) {
            NeighborRPC neighborRPC = new NeighborRPC(peerBean, connectionBean);
            peer.setNeighborRPC(neighborRPC);
        }
        if (this.isEnableQuitRPC()) {
            QuitRPC quitRCP = new QuitRPC(peerBean, connectionBean);
            peer.setQuitRPC(quitRCP);
        }
        if (this.isEnablePeerExchangeRPC()) {
            PeerExchangeRPC peerExchangeRPC = new PeerExchangeRPC(peerBean, connectionBean);
            peer.setPeerExchangeRPC(peerExchangeRPC);
        }
        if (this.isEnableDirectDataRPC()) {
            DirectDataRPC directDataRPC = new DirectDataRPC(peerBean, connectionBean);
            peer.setDirectDataRPC(directDataRPC);
        }
        if (this.isEnableTrackerRPC()) {
            TrackerRPC trackerRPC = new TrackerRPC(peerBean, connectionBean, this.configuration);
            peer.setTrackerRPC(trackerRPC);
        }
        if (this.isEnableTaskRPC()) {
            peerBean.setTaskManager(new TaskManager(peerBean, connectionBean, this.workerThreads));
            TaskRPC taskRPC = new TaskRPC(peerBean, connectionBean);
            peer.setTaskRPC(taskRPC);
        }
        if (this.isEnablePeerExchangeRPC()) {
            TrackerStorageReplication trackerStorageReplication = new TrackerStorageReplication(peer, peer.getPeerExchangeRPC(), peer.getPendingFutures(), storageTracker, this.configuration.isForceTrackerTCP());
            replicationTracker.addResponsibilityListener(trackerStorageReplication);
        }
        if (this.isEnableRouting() && this.isEnableNeighborRPC()) {
            DistributedRouting routing = new DistributedRouting(peerBean, peer.getNeighborRPC());
            peer.setDistributedRouting(routing);
        }
        if (this.isEnableRouting() && this.isEnableStorageRPC() && this.isEnableDirectDataRPC()) {
            DistributedHashTable dht = new DistributedHashTable(peer.getDistributedRouting(), peer.getStoreRPC(), peer.getDirectDataRPC());
            peer.setDistributedHashMap(dht);
        }
        if (this.isEnableRouting() && this.isEnableTrackerRPC() && this.isEnablePeerExchangeRPC()) {
            DistributedTracker tracker = new DistributedTracker(peerBean, peer.getDistributedRouting(), peer.getTrackerRPC(), peer.getPeerExchangeRPC());
            peer.setDistributedTracker(tracker);
        }
        if (this.isEnableTaskRPC() && this.isEnableTask() && this.isEnableRouting()) {
            peerBean.getTaskManager().init(peer.getTaskRPC());
            AsyncTask asyncTask = new AsyncTask(peer.getTaskRPC(), connectionBean.getScheduler(), peerBean);
            peer.setAsyncTask(asyncTask);
            peerBean.getTaskManager().addListener(asyncTask);
            connectionBean.getScheduler().startTracking(peer.getTaskRPC(), connectionBean.getConnectionReservation());
            DistributedTask distributedTask = new DistributedTask(peer.getDistributedRouting(), peer.getAsyncTask());
            peer.setDistributedTask(distributedTask);
        }
        if (this.isEnableMaintenance()) {
            connectionHandler.getConnectionBean().getScheduler().startMaintainance(peerBean.getPeerMap(), peer.getHandshakeRPC(), connectionBean.getConnectionReservation(), 5);
        }
        if (this.isEnableIndirectReplication() && this.isEnableStorageRPC()) {
            DefaultStorageReplication defaultStorageReplication = new DefaultStorageReplication(peer, peerBean.getStorage(), peer.getStoreRPC(), peer.getPendingFutures(), this.configuration.isForceStorageUDP());
            peer.getScheduledFutures().add(connectionBean.getScheduler().getScheduledExecutorServiceReplication().scheduleWithFixedDelay(defaultStorageReplication, this.replicationRefreshMillis, this.replicationRefreshMillis, TimeUnit.MILLISECONDS));
            replicationStorage.addResponsibilityListener(defaultStorageReplication);
        }
        connectionBean.getScheduler().startDelayedChannelCreator();
    }

    public PeerMaker setPeerMapConfiguration(int bagSize, int cacheTimeoutMillis, int maxNrBeforeExclude, int[] waitingTimeBetweenNodeMaintenenceSeconds, int cacheSize, boolean isBehindFirewall) {
        this.setBagSize(bagSize);
        this.setCacheTimeoutMillis(cacheTimeoutMillis);
        this.setMaxNrBeforeExclude(maxNrBeforeExclude);
        this.setWaitingTimeBetweenNodeMaintenenceSeconds(waitingTimeBetweenNodeMaintenenceSeconds);
        this.setCacheSize(cacheSize);
        this.setBehindFirewallPeerMap(isBehindFirewall);
        return this;
    }

    public PeerMaker setP2PId(int p2pID) {
        this.p2pID = p2pID;
        return this;
    }

    public int getP2PId() {
        return this.p2pID;
    }

    public PeerMaker setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public PeerMaker setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    public int getMaintenanceThreads() {
        return this.maintenanceThreads;
    }

    public PeerMaker setMaintenanceThreads(int maintenanceThreads) {
        this.maintenanceThreads = maintenanceThreads;
        return this;
    }

    public int getReplicationThreads() {
        return this.replicationThreads;
    }

    public PeerMaker setReplicationThreads(int replicationThreads) {
        this.replicationThreads = replicationThreads;
        return this;
    }

    public int getReplicationRefreshMillis() {
        return this.replicationRefreshMillis;
    }

    public PeerMaker setReplicationRefreshMillis(int replicationRefreshMillis) {
        this.replicationRefreshMillis = replicationRefreshMillis;
        return this;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public PeerMaker setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
        return this;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public PeerMaker setUdpPort(int udpPort) {
        this.udpPort = udpPort;
        return this;
    }

    public PeerMaker setPorts(int port) {
        this.udpPort = port;
        this.tcpPort = port;
        return this;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public PeerMaker setBindings(Bindings bindings) {
        this.bindings = bindings;
        return this;
    }

    public File getFileMessageLogger() {
        return this.fileMessageLogger;
    }

    public PeerMaker setFileMessageLogger(File fileMessageLogger) {
        this.fileMessageLogger = fileMessageLogger;
        return this;
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public PeerMaker setConfiguration(ConnectionConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public StorageGeneric getStorage() {
        return this.storage;
    }

    public PeerMaker setStorage(StorageGeneric storage) {
        this.storage = storage;
        return this;
    }

    public int getBagSize() {
        return this.bagSize;
    }

    public PeerMaker setBagSize(int bagSize) {
        this.bagSize = bagSize;
        return this;
    }

    public int getCacheTimeoutMillis() {
        return this.cacheTimeoutMillis;
    }

    public PeerMaker setCacheTimeoutMillis(int cacheTimeoutMillis) {
        this.cacheTimeoutMillis = cacheTimeoutMillis;
        return this;
    }

    public int getMaxNrBeforeExclude() {
        return this.maxNrBeforeExclude;
    }

    public PeerMaker setMaxNrBeforeExclude(int maxNrBeforeExclude) {
        this.maxNrBeforeExclude = maxNrBeforeExclude;
        return this;
    }

    public int[] getWaitingTimeBetweenNodeMaintenenceSeconds() {
        return this.waitingTimeBetweenNodeMaintenenceSeconds;
    }

    public PeerMaker setWaitingTimeBetweenNodeMaintenenceSeconds(int[] waitingTimeBetweenNodeMaintenenceSeconds) {
        this.waitingTimeBetweenNodeMaintenenceSeconds = waitingTimeBetweenNodeMaintenenceSeconds;
        return this;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public PeerMaker setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public boolean isBehindFirewallPeerMap() {
        return this.isBehindFirewallPeerMap;
    }

    public PeerMaker setBehindFirewallPeerMap(boolean isBehindFirewallPeerMap) {
        this.isBehindFirewallPeerMap = isBehindFirewallPeerMap;
        return this;
    }

    public boolean isEnableHandShakeRPC() {
        return this.enableHandShakeRPC;
    }

    public PeerMaker setEnableHandShakeRPC(boolean enableHandShakeRPC) {
        this.enableHandShakeRPC = enableHandShakeRPC;
        return this;
    }

    public boolean isEnableStorageRPC() {
        return this.enableStorageRPC;
    }

    public PeerMaker setEnableStorageRPC(boolean enableStorageRPC) {
        this.enableStorageRPC = enableStorageRPC;
        return this;
    }

    public boolean isEnableNeighborRPC() {
        return this.enableNeighborRPC;
    }

    public PeerMaker setEnableNeighborRPC(boolean enableNeighborRPC) {
        this.enableNeighborRPC = enableNeighborRPC;
        return this;
    }

    public boolean isEnableQuitRPC() {
        return this.enableQuitRPC;
    }

    public PeerMaker setEnableQuitRPC(boolean enableQuitRPC) {
        this.enableQuitRPC = enableQuitRPC;
        return this;
    }

    public boolean isEnablePeerExchangeRPC() {
        return this.enablePeerExchangeRPC;
    }

    public PeerMaker setEnablePeerExchangeRPC(boolean enablePeerExchangeRPC) {
        this.enablePeerExchangeRPC = enablePeerExchangeRPC;
        return this;
    }

    public boolean isEnableDirectDataRPC() {
        return this.enableDirectDataRPC;
    }

    public PeerMaker setEnableDirectDataRPC(boolean enableDirectDataRPC) {
        this.enableDirectDataRPC = enableDirectDataRPC;
        return this;
    }

    public boolean isEnableTrackerRPC() {
        return this.enableTrackerRPC;
    }

    public PeerMaker setEnableTrackerRPC(boolean enableTrackerRPC) {
        this.enableTrackerRPC = enableTrackerRPC;
        return this;
    }

    public boolean isEnableTaskRPC() {
        return this.enableTaskRPC;
    }

    public PeerMaker setEnableTaskRPC(boolean enableTaskRPC) {
        this.enableTaskRPC = enableTaskRPC;
        return this;
    }

    public boolean isEnableRouting() {
        return this.enableRouting;
    }

    public PeerMaker setEnableRouting(boolean enableRouting) {
        this.enableRouting = enableRouting;
        return this;
    }

    public boolean isEnableDHT() {
        return this.enableDHT;
    }

    public PeerMaker setEnableDHT(boolean enableDHT) {
        this.enableDHT = enableDHT;
        return this;
    }

    public boolean isEnableTracker() {
        return this.enableTracker;
    }

    public PeerMaker setEnableTracker(boolean enableTracker) {
        this.enableTracker = enableTracker;
        return this;
    }

    public boolean isEnableTask() {
        return this.enableTask;
    }

    public PeerMaker setEnableTask(boolean enableTask) {
        this.enableTask = enableTask;
        return this;
    }

    public boolean isEnableMaintenance() {
        return this.enableMaintenance;
    }

    public PeerMaker setEnableMaintenance(boolean enableMaintenance) {
        this.enableMaintenance = enableMaintenance;
        return this;
    }

    public Peer getMasterPeer() {
        return this.masterPeer;
    }

    public PeerMaker setMasterPeer(Peer masterPeer) {
        this.masterPeer = masterPeer;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public PeerMaker setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public boolean isEnableIndirectReplication() {
        return this.enableIndirectReplication;
    }

    public PeerMaker setEnableIndirectReplication(boolean enableIndirectReplication) {
        this.enableIndirectReplication = enableIndirectReplication;
        return this;
    }
}

