/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.tomp2p.utils.CacheMap;

public class ConcurrentCacheMap<K, V>
implements ConcurrentMap<K, V> {
    public static final int SEGMENT_NR = 16;
    public static final int MAX_ENTRIES = 1024;
    public static final int DEFAULT_TIME_TO_LIVE = 60;
    private final CacheMap<K, ExpiringObject>[] segments = new CacheMap[16];
    private final int timeToLive;

    public ConcurrentCacheMap() {
        this(60, 1024);
    }

    public ConcurrentCacheMap(int timeToLive) {
        this(timeToLive, 1024);
    }

    public ConcurrentCacheMap(int timeToLive, int maxEntries) {
        int maxEntriesPerSegment = maxEntries / 16;
        for (int i = 0; i < 16; ++i) {
            this.segments[i] = new CacheMap(maxEntriesPerSegment);
        }
        this.timeToLive = timeToLive;
    }

    private CacheMap<K, ExpiringObject> segment(Object key) {
        return this.segments[(key.hashCode() & Integer.MAX_VALUE) % 16];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue = segment.put(key, newValue);
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        ExpiringObject oldValue = null;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue = !segment.containsKey(key) ? segment.put(key, newValue) : (ExpiringObject)segment.get(key);
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
        }
        if (oldValue != null) {
            if (oldValue.isExpired()) {
                cacheMap = segment;
                synchronized (cacheMap) {
                    segment.remove(key);
                }
                return null;
            }
            return oldValue.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.remove(key);
        }
        if (oldValue == null || oldValue.isExpired()) {
            return null;
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        boolean removed = false;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
            if (oldValue != null && oldValue.equals(value) && !oldValue.isExpired()) {
                removed = segment.remove(key) != null;
            }
        }
        if (oldValue != null && oldValue.isExpired()) {
            cacheMap = segment;
            synchronized (cacheMap) {
                segment.remove(key);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
        }
        if (oldValue != null) {
            if (!oldValue.isExpired()) {
                return true;
            }
            cacheMap = segment;
            synchronized (cacheMap) {
                segment.remove(key);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.expireAll();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                if (segment.containsValue(value)) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.expireAll();
        int size = 0;
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                size += segment.size();
                continue;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.expireAll();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                if (!segment.isEmpty()) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                segment.clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.expireAll();
        int hashCode = 0;
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                hashCode += segment.hashCode();
                continue;
            }
        }
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.expireAll();
        HashSet retVal = new HashSet();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                retVal.addAll(segment.keySet());
                continue;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConcurrentCacheMap)) {
            return false;
        }
        int len = this.segments.length;
        ConcurrentCacheMap m = (ConcurrentCacheMap)obj;
        if (len != m.segments.length) {
            return false;
        }
        this.expireAll();
        m.expireAll();
        for (int i = 0; i < len; ++i) {
            CacheMap<K, ExpiringObject> cacheMap = this.segments[i];
            synchronized (cacheMap) {
                CacheMap<K, ExpiringObject> cacheMap2 = m.segments[i];
                synchronized (cacheMap2) {
                    if (!this.segments[i].equals(m.segments[i])) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> inMap) {
        for (Map.Entry<K, V> e : inMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        ArrayList retVal = new ArrayList();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                Iterator iterator = segment.values().iterator();
                while (iterator.hasNext()) {
                    ExpiringObject expiringObject = (ExpiringObject)iterator.next();
                    if (expiringObject.isExpired()) {
                        iterator.remove();
                        continue;
                    }
                    retVal.add(expiringObject.getValue());
                }
                continue;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> retVal = new HashSet<Map.Entry<K, V>>();
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                Iterator iterator = segment.entrySet().iterator();
                while (iterator.hasNext()) {
                    final Map.Entry entry = iterator.next();
                    if (((ExpiringObject)entry.getValue()).isExpired()) {
                        iterator.remove();
                        continue;
                    }
                    retVal.add(new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((ExpiringObject)entry.getValue()).getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException("not supported");
                        }
                    });
                }
                continue;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ExpiringObject oldValue3;
        ExpiringObject oldValue2 = new ExpiringObject(oldValue, 0L);
        ExpiringObject newValue2 = new ExpiringObject(newValue, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> segment = this.segment(key);
        boolean replaced = false;
        CacheMap<K, ExpiringObject> cacheMap = segment;
        synchronized (cacheMap) {
            oldValue3 = (ExpiringObject)segment.get(key);
            if (oldValue3 != null && !oldValue3.isExpired() && oldValue2.equals(oldValue3.getValue())) {
                segment.put(key, newValue2);
                replaced = true;
            }
        }
        if (oldValue3 != null && oldValue3.isExpired()) {
            cacheMap = segment;
            synchronized (cacheMap) {
                segment.remove(key);
            }
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        ExpiringObject oldValue;
        CacheMap<K, ExpiringObject> segment;
        ExpiringObject newValue = new ExpiringObject(value, System.currentTimeMillis());
        CacheMap<K, ExpiringObject> cacheMap = segment = this.segment(key);
        synchronized (cacheMap) {
            oldValue = (ExpiringObject)segment.get(key);
            if (oldValue != null) {
                oldValue = segment.put(key, newValue);
            }
        }
        if (oldValue == null) {
            return null;
        }
        if (oldValue.isExpired()) {
            cacheMap = segment;
            synchronized (cacheMap) {
                segment.remove(key);
                return null;
            }
        }
        return oldValue.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireAll() {
        CacheMap<K, ExpiringObject>[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CacheMap<K, ExpiringObject> segment;
            CacheMap<K, ExpiringObject> cacheMap = segment = arr$[i$];
            synchronized (cacheMap) {
                ExpiringObject expiringObject;
                Iterator iterator = segment.values().iterator();
                while (iterator.hasNext() && (expiringObject = (ExpiringObject)iterator.next()).isExpired()) {
                    iterator.remove();
                }
                continue;
            }
        }
    }

    private class ExpiringObject {
        private final V value;
        private final long lastAccessTime;

        ExpiringObject(V value, long lastAccessTime) {
            if (value == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.value = value;
            this.lastAccessTime = lastAccessTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.lastAccessTime + (long)(ConcurrentCacheMap.this.timeToLive * 1000);
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

