/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.peers.Number160;

public class DigestInfo {
    private volatile Number160 keyDigest = null;
    private volatile int size = -1;
    private final List<Number160> keyDigests = new ArrayList<Number160>();

    public DigestInfo() {
    }

    public DigestInfo(int size) {
        this.size = size;
    }

    public DigestInfo(Number160 keyDigest, int size) {
        this.keyDigest = keyDigest;
        this.size = size;
    }

    public Number160 getKeyDigest() {
        if (this.keyDigest == null) {
            Number160 hash = Number160.ZERO;
            for (Number160 key2 : this.keyDigests) {
                hash = hash.xor(key2);
            }
            this.keyDigest = hash;
        }
        return this.keyDigest;
    }

    public List<Number160> getKeyDigests() {
        return this.keyDigests;
    }

    public int getSize() {
        if (this.size == -1) {
            this.size = this.keyDigests.size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestInfo)) {
            return false;
        }
        DigestInfo other = (DigestInfo)obj;
        return this.getKeyDigest().equals(other.getKeyDigest()) && this.getSize() == other.getSize();
    }

    public int hashCode() {
        return this.getKeyDigest().hashCode() ^ this.getSize();
    }
}

