/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStat;
import net.tomp2p.utils.Timings;

public class PeerMapStat {
    private final Map<PeerAddress, PeerStat> mapStat = new HashMap<PeerAddress, PeerStat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStat(PeerAddress peerAddress) {
        Map<PeerAddress, PeerStat> map = this.mapStat;
        synchronized (map) {
            this.mapStat.remove(peerAddress);
        }
    }

    public void setSeenOnlineTime(PeerAddress peerAddress) {
        PeerStat peerStat = this.getOrCreate(peerAddress);
        peerStat.setLastSeenOnline(Timings.currentTimeMillis());
    }

    public long getLastSeenOnlineTime(PeerAddress peerAddress) {
        PeerStat peerStat = this.getOrCreate(peerAddress);
        return peerStat.getLastSeenOnline();
    }

    public void incChecked(PeerAddress peerAddress) {
        PeerStat peerStat = this.getOrCreate(peerAddress);
        peerStat.incChecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerStat getOrCreate(PeerAddress peerAddress) {
        PeerStat peerStat;
        Map<PeerAddress, PeerStat> map = this.mapStat;
        synchronized (map) {
            peerStat = this.mapStat.get(peerAddress);
            if (peerStat == null) {
                peerStat = new PeerStat();
                peerStat.setCreated(Timings.currentTimeMillis());
                this.mapStat.put(peerAddress, peerStat);
            }
        }
        return peerStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChecked(PeerAddress peerAddress) {
        PeerStat peerStat;
        Map<PeerAddress, PeerStat> map = this.mapStat;
        synchronized (map) {
            peerStat = this.mapStat.get(peerAddress);
        }
        if (peerStat == null) {
            return 0;
        }
        return peerStat.getChecked();
    }

    public long online(PeerAddress peerAddress) {
        PeerStat peerStat = this.getOrCreate(peerAddress);
        return peerStat.onlineTime();
    }
}

