/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.futures.FutureData;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.ConnectionConfiguration;
import net.tomp2p.p2p.DistributedHashTable;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTask;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.config.ConfigurationBaseDHT;
import net.tomp2p.p2p.config.ConfigurationBootstrap;
import net.tomp2p.p2p.config.ConfigurationDirect;
import net.tomp2p.p2p.config.ConfigurationGet;
import net.tomp2p.p2p.config.ConfigurationRemove;
import net.tomp2p.p2p.config.ConfigurationStore;
import net.tomp2p.p2p.config.ConfigurationTrackerGet;
import net.tomp2p.p2p.config.ConfigurationTrackerStore;
import net.tomp2p.p2p.config.Configurations;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapKadImpl;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TaskRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.task.AsyncTask;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    private ConnectionHandler connectionHandler;
    private final Number160 peerId;
    private final int p2pID;
    private final KeyPair keyPair;
    private DistributedHashTable distributedHashMap;
    private DistributedTracker distributedTracker;
    private DistributedRouting distributedRouting;
    private DistributedTask distributedTask;
    private AsyncTask asyncTask;
    private HandshakeRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private PeerExchangeRPC peerExchangeRPC;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private TaskRPC taskRPC;
    private Bindings bindings;
    private final ConnectionConfiguration configuration;
    private final Map<BaseFuture, Long> pendingFutures = Collections.synchronizedMap(new CacheMap(1000));
    private boolean masterFlag = true;
    private List<ScheduledFuture<?>> scheduledFutures = Collections.synchronizedList(new ArrayList());
    private final List<PeerListener> listeners = new ArrayList<PeerListener>();
    private Timer timer;
    public static final int BLOOMFILTER_SIZE = 1024;
    private final int maintenanceThreads;
    private final int replicationThreads;
    private final PeerMapKadImpl peerMap;
    private final int maxMessageSize;

    Peer(int p2pID, Number160 nodeId, KeyPair keyPair, int maintenanceThreads, int replicationThreads, ConnectionConfiguration configuration, PeerMapKadImpl peerMap, int maxMessageSize) {
        this.p2pID = p2pID;
        this.peerId = nodeId;
        this.configuration = configuration;
        this.keyPair = keyPair;
        this.maintenanceThreads = maintenanceThreads;
        this.replicationThreads = replicationThreads;
        this.peerMap = peerMap;
        this.maxMessageSize = maxMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerListener(PeerListener listener) {
        if (this.isRunning()) {
            listener.notifyOnStart();
        }
        List<PeerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerListener(PeerListener listener) {
        List<PeerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public List<PeerListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info("begin shutdown in progres at " + System.nanoTime());
        List<Object> list = this.scheduledFutures;
        synchronized (list) {
            for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        if (this.masterFlag) {
            this.getConnectionBean().getSender().shutdown();
        }
        if (this.masterFlag && this.timer != null) {
            this.timer.stop();
        }
        this.getConnectionHandler().shutdown();
        list = this.listeners;
        synchronized (list) {
            for (PeerListener listener : this.listeners) {
                listener.notifyOnShutdown();
            }
        }
        this.getPeerBean().getStorage().close();
        this.connectionHandler = null;
    }

    ConnectionHandler listen(int udpPort, int tcpPort, Bindings bindings, File fileMessageLogger) throws IOException {
        this.masterFlag = true;
        this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS, 10);
        this.bindings = bindings;
        ConnectionHandler connectionHandler = new ConnectionHandler(udpPort, tcpPort, this.peerId, bindings, this.getP2PID(), this.configuration, fileMessageLogger, this.keyPair, this.peerMap, this.timer, this.maxMessageSize, this.maintenanceThreads, this.replicationThreads);
        logger.debug("listen done");
        this.connectionHandler = connectionHandler;
        return connectionHandler;
    }

    ConnectionHandler listen(Peer master) throws IOException {
        this.masterFlag = false;
        this.timer = master.timer;
        this.bindings = master.bindings;
        ConnectionHandler connectionHandler = new ConnectionHandler(master.getConnectionHandler(), this.peerId, this.keyPair, this.peerMap);
        logger.debug("listen done");
        this.connectionHandler = connectionHandler;
        return connectionHandler;
    }

    public Map<BaseFuture, Long> getPendingFutures() {
        return this.pendingFutures;
    }

    public boolean isRunning() {
        return this.connectionHandler != null;
    }

    public boolean isListening() {
        if (!this.isRunning()) {
            return false;
        }
        return this.connectionHandler.isListening();
    }

    public void customLoggerMessage(String customMessage) {
        this.getConnectionHandler().customLoggerMessage(customMessage);
    }

    public HandshakeRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.handshakeRCP;
    }

    public void setHandshakeRPC(HandshakeRPC handshakeRPC) {
        this.handshakeRCP = handshakeRPC;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.storageRPC;
    }

    public void setStorageRPC(StorageRPC storageRPC) {
        this.storageRPC = storageRPC;
    }

    public NeighborRPC getNeighborRPC() {
        if (this.neighborRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.neighborRPC;
    }

    public void setNeighborRPC(NeighborRPC neighborRPC) {
        this.neighborRPC = neighborRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.quitRCP;
    }

    public void setQuitRPC(QuitRPC quitRCP) {
        this.quitRCP = quitRCP;
    }

    public PeerExchangeRPC getPeerExchangeRPC() {
        if (this.peerExchangeRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.peerExchangeRPC;
    }

    public void setPeerExchangeRPC(PeerExchangeRPC peerExchangeRPC) {
        this.peerExchangeRPC = peerExchangeRPC;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.directDataRPC;
    }

    public void setDirectDataRPC(DirectDataRPC directDataRPC) {
        this.directDataRPC = directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.trackerRPC;
    }

    public void setTrackerRPC(TrackerRPC trackerRPC) {
        this.trackerRPC = trackerRPC;
    }

    public TaskRPC getTaskRPC() {
        if (this.taskRPC == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.taskRPC;
    }

    public void setTaskRPC(TaskRPC taskRPC) {
        this.taskRPC = taskRPC;
    }

    public DistributedRouting getDistributedRouting() {
        if (this.distributedRouting == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedRouting;
    }

    public void setDistributedRouting(DistributedRouting distributedRouting) {
        this.distributedRouting = distributedRouting;
    }

    public DistributedHashTable getDistributedHashMap() {
        if (this.distributedHashMap == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedHashMap;
    }

    public void setDistributedHashMap(DistributedHashTable distributedHashMap) {
        this.distributedHashMap = distributedHashMap;
    }

    public DistributedTracker getDistributedTracker() {
        if (this.distributedTracker == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedTracker;
    }

    public void setDistributedTracker(DistributedTracker distributedTracker) {
        this.distributedTracker = distributedTracker;
    }

    public AsyncTask getAsyncTask() {
        if (this.asyncTask == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.asyncTask;
    }

    public void setAsyncTask(AsyncTask asyncTask) {
        this.asyncTask = asyncTask;
    }

    public DistributedTask getDistributedTask() {
        if (this.distributedTask == null) {
            throw new RuntimeException("Not enabled, please enable this RPC in PeerMaker");
        }
        return this.distributedTask;
    }

    public void setDistributedTask(DistributedTask task) {
        this.distributedTask = task;
    }

    public List<ScheduledFuture<?>> getScheduledFutures() {
        return this.scheduledFutures;
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.connectionHandler;
    }

    public PeerBean getPeerBean() {
        return this.getConnectionHandler().getPeerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.getConnectionHandler().getConnectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public PeerConnection createPeerConnection(PeerAddress destination, int idleTCPMillis) {
        FutureChannelCreator fcc = this.getConnectionBean().getConnectionReservation().reserve(1, true, "PeerConnection");
        fcc.awaitUninterruptibly();
        if (fcc.isFailed()) {
            return null;
        }
        ChannelCreator cc = fcc.getChannelCreator();
        PeerConnection peerConnection = new PeerConnection(destination, this.getConnectionBean().getConnectionReservation(), cc, idleTCPMillis);
        return peerConnection;
    }

    public FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer) {
        return this.send(remotePeer, requestBuffer, true);
    }

    public FutureData send(PeerConnection connection, ChannelBuffer requestBuffer) {
        return this.send(connection, requestBuffer, true);
    }

    public FutureData send(PeerAddress remotePeer, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(remotePeer, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    public FutureData send(PeerConnection connection, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(connection, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    private FutureData send(final PeerConnection connection, ChannelBuffer requestBuffer, boolean raw) {
        RequestHandlerTCP<FutureData> request = this.getDirectDataRPC().prepareSend(connection.getDestination(), requestBuffer.slice(), raw);
        request.setKeepAlive(true);
        try {
            connection.aquireSingleConnection();
        }
        catch (InterruptedException e) {
            request.getFutureResponse().setFailed("Interupted " + e);
        }
        request.sendTCP(connection.getChannelCreator(), connection.getIdleTCPMillis());
        request.getFutureResponse().addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                connection.releaseSingleConnection();
            }
        });
        return request.getFutureResponse();
    }

    private FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer, boolean raw) {
        final RequestHandlerTCP<FutureData> request = this.getDirectDataRPC().prepareSend(remotePeer, requestBuffer.slice(), raw);
        this.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureData futureData = (FutureData)request.sendTCP(future.getChannelCreator());
                    Utils.addReleaseListenerAll(futureData, Peer.this.getConnectionBean().getConnectionReservation(), future.getChannelCreator());
                } else {
                    ((FutureData)request.getFutureResponse()).setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }

    public FutureBootstrap bootstrapBroadcast() {
        return this.bootstrapBroadcast(7700);
    }

    public FutureBootstrap bootstrapBroadcast(int port) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureLateJoin<FutureResponse> tmp = this.pingBroadcast(port);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureLateJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureLateJoin<FutureResponse> future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = future.getLastSuceessFuture();
                    if (futureResponse == null) {
                        result.setFailed("no futures found");
                        return;
                    }
                    PeerAddress sender = futureResponse.getResponse().getSender();
                    ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                    bootstrapTo.add(sender);
                    result.setBootstrapTo(bootstrapTo);
                    result.waitFor(Peer.this.bootstrap(sender));
                } else {
                    result.setFailed("could not reach anyone with the broadcast (1)");
                }
            }
        });
        return result;
    }

    FutureLateJoin<FutureResponse> pingBroadcast(final int port) {
        final int size = this.bindings.getBroadcastAddresses().size();
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(size, 1);
        if (size > 0) {
            this.getConnectionBean().getConnectionReservation().reserve(size).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse validBroadcast = null;
                        for (int i = 0; i < size; ++i) {
                            InetAddress broadcastAddress = Peer.this.bindings.getBroadcastAddresses().get(i);
                            PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                            validBroadcast = Peer.this.getHandshakeRPC().pingBroadcastUDP(peerAddress, future.getChannelCreator());
                            Utils.addReleaseListener(validBroadcast, Peer.this.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                            if (logger.isDebugEnabled()) {
                                logger.debug("ping broadcast to " + broadcastAddress);
                            }
                            if (futureLateJoin.add(validBroadcast)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        futureLateJoin.setFailed(future);
                    }
                }
            });
        } else {
            futureLateJoin.setFailed("No broadcast address found. Cannot ping nothing");
        }
        return futureLateJoin;
    }

    public FutureResponse ping(InetSocketAddress address) {
        return this.ping(address, true);
    }

    public FutureResponse ping(InetSocketAddress address, boolean isUDP) {
        if (isUDP) {
            final RequestHandlerUDP<FutureResponse> request = this.getHandshakeRPC().pingUDP(new PeerAddress(Number160.ZERO, address));
            this.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        Object futureResponse = request.sendUDP(future.getChannelCreator());
                        Utils.addReleaseListener(futureResponse, Peer.this.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                    } else {
                        ((BaseFutureImpl)request.getFutureResponse()).setFailed(future);
                    }
                }
            });
            return request.getFutureResponse();
        }
        final RequestHandlerTCP<FutureResponse> request = this.getHandshakeRPC().pingTCP(new PeerAddress(Number160.ZERO, address));
        this.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Object futureResponse = request.sendTCP(future.getChannelCreator());
                    Utils.addReleaseListener(futureResponse, Peer.this.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                } else {
                    ((BaseFutureImpl)request.getFutureResponse()).setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }

    public FutureBootstrap bootstrap(InetSocketAddress address) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureResponse tmp = this.ping(address, true);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    PeerAddress sender = future.getResponse().getSender();
                    ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                    bootstrapTo.add(sender);
                    result.setBootstrapTo(bootstrapTo);
                    result.waitFor(Peer.this.bootstrap(sender));
                } else {
                    result.setFailed("could not reach anyone with the broadcast (2)");
                }
            }
        });
        return result;
    }

    public FutureBootstrap bootstrap(PeerAddress peerAddress) {
        if (peerAddress.getID() == Number160.ZERO) {
            if (logger.isWarnEnabled()) {
                logger.warn("The peer ID is Number160.ZERO, which cannot be used to bootstrap. If the ID is unknown, use bootstrap(InetSocketAddress)");
            }
            throw new IllegalArgumentException("The peer ID is Number160.ZERO, which cannot be used to bootstrap. If the ID is unknown, use bootstrap(InetSocketAddress)");
        }
        ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
        bootstrapTo.add(peerAddress);
        return this.bootstrap(peerAddress, bootstrapTo, Configurations.defaultBootstrapConfiguration());
    }

    public FutureBootstrap bootstrap(PeerAddress discoveryPeerAddress, final Collection<PeerAddress> bootstrapTo, final ConfigurationBootstrap config) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        result.setBootstrapTo(bootstrapTo);
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        this.getConnectionBean().getConnectionReservation().reserve(conn).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator futureChannelCreator) throws Exception {
                if (futureChannelCreator.isSuccess()) {
                    FutureRouting futureBootstrap = Peer.this.distributedRouting.bootstrap(bootstrapTo, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getMaxSuccess(), config.getRoutingConfiguration().getParallel(), false, config.isForceRoutingOnlyToSelf(), futureChannelCreator.getChannelCreator());
                    Utils.addReleaseListenerAll(futureBootstrap, Peer.this.getConnectionBean().getConnectionReservation(), futureChannelCreator.getChannelCreator());
                    result.waitFor(futureBootstrap);
                } else {
                    result.setFailed(futureChannelCreator);
                }
            }
        });
        return result;
    }

    public boolean setupPortForwanding(String internalHost) {
        int portUDP = this.bindings.getOutsideUDPPort();
        int portTCP = this.bindings.getOutsideTCPPort();
        boolean success = false;
        try {
            success = this.connectionHandler.getNATUtils().mapUPNP(internalHost, this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!success) {
            logger.warn("cannot find UPNP devices");
            try {
                success = this.connectionHandler.getNATUtils().mapPMP(this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
                if (!success) {
                    logger.warn("cannot find NAT-PMP devices");
                }
            }
            catch (NatPmpException e1) {
                logger.warn("cannot find NAT-PMP devices " + e1);
            }
        }
        return success;
    }

    public FutureDiscover discover(InetAddress inetAddress, int portUDP, int portTCP) {
        PeerAddress peerAddress = new PeerAddress(Number160.ZERO, inetAddress, portTCP, portUDP);
        return this.discover(peerAddress);
    }

    public FutureDiscover discover(final PeerAddress peerAddress) {
        final FutureDiscover futureDiscover = new FutureDiscover();
        this.getConnectionBean().getConnectionReservation().reserve(3).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Peer.this.discover(futureDiscover, peerAddress, future.getChannelCreator());
                } else {
                    futureDiscover.setFailed(future);
                }
            }
        });
        return futureDiscover;
    }

    private void discover(final FutureDiscover futureDiscover, final PeerAddress peerAddress, final ChannelCreator cc) {
        final FutureResponse futureResponseTCP = this.getHandshakeRPC().pingTCPDiscover(peerAddress, cc);
        Utils.addReleaseListener(futureResponseTCP, this.getConnectionBean().getConnectionReservation(), cc, 1);
        this.addPeerListener(new PeerListener(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void serverAddressChanged(PeerAddress peerAddress, PeerAddress reporter, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                    futureDiscover.setDiscoveredTCP();
                } else {
                    this.changedUDP = true;
                    futureDiscover.setDiscoveredUDP();
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress, reporter);
                }
            }

            @Override
            public void notifyOnStart() {
            }

            @Override
            public void notifyOnShutdown() {
            }
        });
        futureResponseTCP.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = Peer.this.getPeerBean().getServerPeerAddress();
                if (futureResponseTCP.isSuccess()) {
                    Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighbors();
                    if (tmp.size() == 1) {
                        PeerAddress seenAs = tmp.iterator().next();
                        logger.info("I'm seen as " + seenAs + " by peer " + peerAddress + " I see myself as " + Peer.this.getPeerAddress().getInetAddress());
                        if (!Peer.this.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                            Bindings bindings2 = new Bindings(seenAs.getInetAddress());
                            String status = DiscoverNetworks.discoverInterfaces(bindings2);
                            logger.info("2nd interface discovery: " + status);
                            if (bindings2.getFoundAddresses().size() > 0 && bindings2.getFoundAddresses().contains(seenAs.getInetAddress())) {
                                serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                Peer.this.getPeerBean().setServerPeerAddress(serverAddress);
                            } else if (Peer.this.bindings.isSetExternalPortsManually() || Peer.this.setupPortForwanding(futureResponseTCP.getResponse().getRecipient().getInetAddress().getHostAddress())) {
                                serverAddress = serverAddress.changePorts(Peer.this.bindings.getOutsideUDPPort(), Peer.this.bindings.getOutsideTCPPort());
                                serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                Peer.this.getPeerBean().setServerPeerAddress(serverAddress);
                            }
                        }
                        FutureResponse fr1 = Peer.this.getHandshakeRPC().pingTCPProbe(peerAddress, cc);
                        FutureResponse fr2 = Peer.this.getHandshakeRPC().pingUDPProbe(peerAddress, cc);
                        Utils.addReleaseListener(fr1, Peer.this.getConnectionBean().getConnectionReservation(), cc, 1);
                        Utils.addReleaseListener(fr2, Peer.this.getConnectionBean().getConnectionReservation(), cc, 1);
                        futureDiscover.setTimeout(Peer.this.timer, Peer.this.configuration.getDiscoverTimeoutSec());
                        return;
                    }
                    Peer.this.getConnectionBean().getConnectionReservation().release(cc, 2);
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                Peer.this.getConnectionBean().getConnectionReservation().release(cc, 2);
                futureDiscover.setFailed("FutureDiscover: We need at least the TCP connection: " + futureResponseTCP.getFailedReason());
            }
        });
    }

    public FutureDHT put(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.put(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config) {
        return this.put(locationKey, data, config, this.reserve(config));
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
        dataMap.put(config.getContentKey(), data);
        return this.put(locationKey, dataMap, config, channelCreator);
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config) {
        return this.put(locationKey, dataMap, config, this.reserve(config));
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config, FutureChannelCreator channelCreator) {
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDistributedHashMap().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getConnectionReservation());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.schedulePut(locationKey, dataMap, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> schedulePut(final Number160 locationKey, final Map<Number160, Data> dataMap, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDistributedHashMap().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation());
                futureDHT.repeated(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT add(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.add(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config) {
        return this.add(locationKey, data, config, this.reserve(config));
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        ArrayList<Data> dataCollection = new ArrayList<Data>();
        dataCollection.add(data);
        return this.add(locationKey, dataCollection, config, channelCreator);
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config) {
        return this.add(locationKey, dataCollection, config, this.reserve(config));
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        if (config.getContentKey() != null && !config.getContentKey().equals(Number160.ZERO)) {
            logger.warn("Warning, setting a content key in add() does not have any effect");
        }
        if (!config.isSignMessage()) {
            for (Data data : dataCollection) {
                if (!data.isProtectedEntry()) continue;
                config.setSignMessage(true);
                break;
            }
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDistributedHashMap().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getConnectionReservation());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.scheduleAdd(locationKey, dataCollection, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleAdd(final Number160 locationKey, final Collection<Data> dataCollection, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDistributedHashMap().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation());
                futureDHT.repeated(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT getAll(Number160 locationKey) {
        return this.get(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, null, config, this.reserve(config));
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        return this.get(locationKey, null, config, channelCreator);
    }

    public FutureDHT get(Number160 locationKey) {
        return this.get(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, config, this.reserve(config));
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.get(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        return this.get(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDistributedHashMap().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage(), false, config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getConnectionReservation());
        return futureDHT;
    }

    public FutureDHT parallelRequests(Number160 locationKey, ConfigurationBaseDHT config, boolean cancleOnFinish, NavigableSet<PeerAddress> queue, DistributedHashTable.Operation operation) {
        return this.parallelRequests(locationKey, config, this.reserve(config), cancleOnFinish, queue, operation);
    }

    public FutureDHT parallelRequests(Number160 locationKey, ConfigurationBaseDHT config, FutureChannelCreator channelCreator, boolean cancleOnFinish, NavigableSet<PeerAddress> queue, DistributedHashTable.Operation operation) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDistributedHashMap().parallelRequests(config.getRequestP2PConfiguration(), queue, cancleOnFinish, channelCreator, this.getConnectionBean().getConnectionReservation(), config.isAutomaticCleanup(), operation);
        return futureDHT;
    }

    public FutureDHT digestAll(Number160 locationKey) {
        return this.digest(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT digestAll(Number160 locationKey, ConfigurationGet config) {
        return this.digestAll(locationKey, config, this.reserve(config));
    }

    public FutureDHT digestAll(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        return this.digest(locationKey, null, config, channelCreator);
    }

    public FutureDHT digest(Number160 locationKey) {
        return this.digest(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT digest(Number160 locationKey, ConfigurationGet config) {
        return this.digest(locationKey, config, this.reserve(config));
    }

    public FutureDHT digest(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.digest(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT digest(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        return this.digest(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT digest(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDistributedHashMap().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage(), true, config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getConnectionReservation());
        return futureDHT;
    }

    public FutureDHT removeAll(Number160 locationKey) {
        return this.removeAll(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config) {
        return this.removeAll(locationKey, config, this.reserve(config));
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        return this.remove(locationKey, null, config, channelCreator);
    }

    public FutureDHT remove(Number160 locationKey) {
        return this.remove(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config) {
        return this.remove(locationKey, config, this.reserve(config));
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.remove(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT remove(Number160 locationKey, Number160 contentKey) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(contentKey);
        return this.remove(locationKey, keyCollection, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config) {
        return this.remove(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        if (keyCollection != null) {
            for (Number160 contentKey : keyCollection) {
                this.getPeerBean().getStorage().remove(locationKey, config.getDomain(), contentKey, this.keyPair.getPublic());
            }
        } else {
            this.getPeerBean().getStorage().remove(locationKey, config.getDomain(), Number160.ZERO, Number160.MAX_VALUE, this.keyPair.getPublic());
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDistributedHashMap().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getConnectionReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleRemove(locationKey, keyCollection, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleRemove(final Number160 locationKey, final Set<Number160> keyCollection, final ConfigurationRemove config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDistributedHashMap().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation());
                futureDHT.repeated(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, buffer, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config) {
        return this.send(locationKey, buffer, config, this.reserve(config));
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDistributedHashMap().direct(locationKey, buffer, true, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getConnectionReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    public FutureDHT send(Number160 locationKey, Object object) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, object, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config) throws IOException {
        return this.send(locationKey, object, config, this.reserve(config));
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config, FutureChannelCreator channelCreator) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        byte[] me = Utils.encodeJavaObject(object);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])me);
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDistributedHashMap().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getConnectionReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleSend(final Number160 locationKey, final ChannelBuffer buffer, final ConfigurationDirect config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), Peer.this.getPeerBean().getPeerMap()));
                FutureDHT futureDHT2 = Peer.this.getDistributedHashMap().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), true, futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation());
                futureDHT.repeated(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config) {
        return this.getFromTracker(locationKey, config, new SimpleBloomFilter<Number160>(1024, 200));
    }

    public FutureTracker getFromTrackerCreateBloomfilter1(Number160 locationKey, ConfigurationTrackerGet config, Collection<PeerAddress> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (PeerAddress peerAddress : knownPeers) {
                bloomFilter.add(peerAddress.getID());
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTrackerCreateBloomfilter2(Number160 locationKey, ConfigurationTrackerGet config, Collection<Number160> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (Number160 number160 : knownPeers) {
                bloomFilter.add(number160);
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config, Set<Number160> knownPeers) {
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        FutureChannelCreator futureChannelCreator = this.getConnectionBean().getConnectionReservation().reserve(conn);
        FutureTracker futureTracker = this.getDistributedTracker().getFromTracker(locationKey, config.getDomain(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isExpectAttachement(), config.getEvaluationScheme(), config.isSignMessage(), config.isUseSecondaryTrackers(), knownPeers, futureChannelCreator, this.getConnectionBean().getConnectionReservation());
        return futureTracker;
    }

    public FutureTracker addToTracker(Number160 locationKey, ConfigurationTrackerStore config) {
        ScheduledFuture<?> tmp;
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
        this.getPeerBean().getTrackerStorage().put(locationKey, config.getDomain(), this.getPeerAddress(), this.getPeerBean().getKeyPair().getPublic(), config.getAttachement());
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        FutureChannelCreator futureChannelCreator = this.getConnectionBean().getConnectionReservation().reserve(conn);
        FutureTracker futureTracker = this.getDistributedTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, futureChannelCreator, this.getConnectionBean().getConnectionReservation());
        if (this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() > 0) {
            tmp = this.scheduleAddTracker(locationKey, config, futureTracker);
            this.setupCancel(futureTracker, tmp);
        }
        if (config.getWaitBeforeNextSendSeconds() > 0) {
            tmp = this.schedulePeerExchange(locationKey, config, futureTracker);
            this.setupCancel(futureTracker, tmp);
        }
        return futureTracker;
    }

    private void setupCancel(FutureCleanup futureTracker, final ScheduledFuture<?> tmp) {
        this.scheduledFutures.add(tmp);
        futureTracker.addCleanup(new Cancellable(){

            @Override
            public void cancel() {
                tmp.cancel(true);
                Peer.this.scheduledFutures.remove(tmp);
            }
        });
    }

    private ScheduledFuture<?> scheduleAddTracker(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
                FutureChannelCreator futureChannelCreator = Peer.this.getConnectionBean().getConnectionReservation().reserve(conn);
                FutureTracker futureTracker2 = Peer.this.getDistributedTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation());
                futureTracker.repeated(futureTracker2);
            }
        };
        int refresh = this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() * 3 / 4;
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    private ScheduledFuture<?> schedulePeerExchange(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.getConnectionBean().getConnectionReservation().reserve(35);
                FutureLateJoin<FutureResponse> futureLateJoin = Peer.this.getDistributedTracker().startPeerExchange(locationKey, config.getDomain(), futureChannelCreator, Peer.this.getConnectionBean().getConnectionReservation(), config.getTrackerConfiguration().isForceTCP());
                futureTracker.repeated(futureLateJoin);
            }
        };
        int refresh = config.getWaitBeforeNextSendSeconds();
        ScheduledFuture<?> tmp = this.getConnectionBean().getScheduler().getScheduledExecutorServiceReplication().scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    private static RequestP2PConfiguration adjustConfiguration(RequestP2PConfiguration p2pConfiguration, PeerMap peerMap) {
        int requested;
        int size = peerMap.size() + 1;
        if (size >= (requested = p2pConfiguration.getMinimumResults())) {
            return p2pConfiguration;
        }
        return new RequestP2PConfiguration(size, p2pConfiguration.getMaxFailure(), p2pConfiguration.getParallelDiff());
    }

    public FutureChannelCreator reserve(ConfigurationBaseDHT configurationBaseDHT, String name) {
        return this.reserve(configurationBaseDHT.getRoutingConfiguration(), configurationBaseDHT.getRequestP2PConfiguration(), name);
    }

    public FutureChannelCreator reserve(ConfigurationBaseDHT configurationBaseDHT) {
        return this.reserve(configurationBaseDHT, "default");
    }

    public FutureChannelCreator reserve(RoutingConfiguration routingConfiguration, RequestP2PConfiguration requestP2PConfiguration, String name) {
        if (routingConfiguration == null && requestP2PConfiguration == null) {
            throw new IllegalArgumentException("Both routingConfiguration and requestP2PConfiguration cannot be null");
        }
        int nrConnections = routingConfiguration == null ? requestP2PConfiguration.getParallel() : (requestP2PConfiguration == null ? routingConfiguration.getParallel() : Math.max(routingConfiguration.getParallel(), requestP2PConfiguration.getParallel()));
        return this.getConnectionBean().getConnectionReservation().reserve(nrConnections, name);
    }

    public void release(ChannelCreator channelCreator) {
        this.getConnectionBean().getConnectionReservation().release(channelCreator);
    }

    public void setFutureTimeout(BaseFuture baseFuture, int millis, String reason) {
        this.getConnectionBean().getScheduler().scheduleTimeout(baseFuture, millis, reason);
    }
}

