/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Storage;

class StorageZip
implements Storage {
    private String zip;
    private String zip2;
    private ZipFile z;

    StorageZip(String zipFile) throws IOException {
        this.zip = zipFile.substring(0, zipFile.indexOf("!/"));
        this.z = new ZipFile(this.zip);
        this.zip2 = zipFile.substring(zipFile.indexOf("!/") + 2);
    }

    public void write(long pageNumber, ByteBuffer data) throws IOException {
        throw new UnsupportedOperationException("readonly");
    }

    public ByteBuffer read(long pageNumber) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(4096);
        ZipEntry e = this.z.getEntry(this.zip2 + pageNumber);
        if (e == null) {
            return ByteBuffer.wrap(RecordFile.CLEAN_DATA).asReadOnlyBuffer();
        }
        InputStream i = this.z.getInputStream(e);
        new DataInputStream(i).readFully(data.array());
        i.close();
        return data;
    }

    public void forceClose() throws IOException {
        this.z.close();
        this.z = null;
    }

    public DataInputStream readTransactionLog() {
        throw new UnsupportedOperationException("readonly");
    }

    public void deleteTransactionLog() {
        throw new UnsupportedOperationException("readonly");
    }

    public void sync() throws IOException {
        throw new UnsupportedOperationException("readonly");
    }

    public DataOutputStream openTransactionLog() throws IOException {
        throw new UnsupportedOperationException("readonly");
    }

    public void deleteAllFiles() throws IOException {
    }

    public boolean isReadonly() {
        return true;
    }
}

