/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Storage;
import net.kotek.jdbm.StorageDiskMapped;

class StorageDisk
implements Storage {
    private ArrayList<RandomAccessFile> rafs = new ArrayList();
    private ArrayList<RandomAccessFile> rafsTranslation = new ArrayList();
    private String fileName;
    private long lastPageNumber = Long.MIN_VALUE;
    private boolean readonly;
    static final String transaction_log_file_extension = ".t";

    public StorageDisk(String fileName, boolean readonly) throws IOException {
        this.fileName = fileName;
        this.readonly = readonly;
        try {
            if (!readonly) {
                this.getRaf(0L).getChannel().tryLock();
            }
        }
        catch (IOException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
    }

    RandomAccessFile getRaf(long pageNumber) throws IOException {
        int fileNumber = (int)(Math.abs(pageNumber) / 262144L);
        ArrayList<RandomAccessFile> c = pageNumber >= 0L ? this.rafs : this.rafsTranslation;
        for (int i = c.size(); i <= fileNumber; ++i) {
            c.add(null);
        }
        RandomAccessFile ret = (RandomAccessFile)c.get(fileNumber);
        if (ret == null) {
            String name = StorageDiskMapped.makeFileName(this.fileName, pageNumber, fileNumber);
            ret = new RandomAccessFile(name, this.readonly ? "r" : "rw");
            c.set(fileNumber, ret);
        }
        return ret;
    }

    public void write(long pageNumber, ByteBuffer data) throws IOException {
        if (data.capacity() != 4096) {
            throw new IllegalArgumentException();
        }
        long offset = pageNumber * 4096L;
        RandomAccessFile file = this.getRaf(pageNumber);
        file.seek(Math.abs(offset % 0x40000000L));
        file.write(data.array());
        this.lastPageNumber = pageNumber;
    }

    public ByteBuffer read(long pageNumber) throws IOException {
        long offset = pageNumber * 4096L;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        RandomAccessFile file = this.getRaf(pageNumber);
        file.seek(Math.abs(offset % 0x40000000L));
        int remaining = buffer.limit();
        int pos = 0;
        while (remaining > 0) {
            int read = file.read(buffer.array(), pos, remaining);
            if (read == -1) {
                System.arraycopy(RecordFile.CLEAN_DATA, 0, buffer.array(), pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
        this.lastPageNumber = pageNumber;
        return buffer;
    }

    public DataOutputStream openTransactionLog() throws IOException {
        String logName = this.fileName + transaction_log_file_extension;
        final FileOutputStream fileOut = new FileOutputStream(logName);
        return new DataOutputStream(new BufferedOutputStream(fileOut)){

            public void flush() throws IOException {
                super.flush();
                fileOut.flush();
                fileOut.getFD().sync();
            }
        };
    }

    public void deleteAllFiles() {
        this.deleteTransactionLog();
        StorageDiskMapped.deleteFiles(this.fileName);
    }

    public void sync() throws IOException {
        for (RandomAccessFile file : this.rafs) {
            if (file == null) continue;
            file.getFD().sync();
        }
        for (RandomAccessFile file : this.rafsTranslation) {
            if (file == null) continue;
            file.getFD().sync();
        }
    }

    public void forceClose() throws IOException {
        for (RandomAccessFile f : this.rafs) {
            if (f == null) continue;
            f.close();
        }
        this.rafs = null;
        for (RandomAccessFile f : this.rafsTranslation) {
            if (f == null) continue;
            f.close();
        }
        this.rafsTranslation = null;
    }

    public DataInputStream readTransactionLog() {
        File logFile = new File(this.fileName + transaction_log_file_extension);
        if (!logFile.exists()) {
            return null;
        }
        if (logFile.length() == 0L) {
            logFile.delete();
            return null;
        }
        DataInputStream ois = null;
        try {
            ois = new DataInputStream(new BufferedInputStream(new FileInputStream(logFile)));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            if (ois.readShort() != 4960) {
                throw new Error("Bad magic on log file");
            }
        }
        catch (IOException e) {
            logFile.delete();
            return null;
        }
        return ois;
    }

    public void deleteTransactionLog() {
        File logFile = new File(this.fileName + transaction_log_file_extension);
        if (logFile.exists()) {
            logFile.delete();
        }
    }

    public boolean isReadonly() {
        return false;
    }
}

