/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.kotek.jdbm.BTree;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.HTree;
import net.kotek.jdbm.LinkedList2;
import net.kotek.jdbm.LongPacker;
import net.kotek.jdbm.SerialClassInfo;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Serialization
extends SerialClassInfo
implements Serializer {
    static final boolean DEBUG = false;
    private static final String UTF8 = "UTF-8";

    Serialization(DBAbstract db, long serialClassInfoRecid, ArrayList<SerialClassInfo.ClassInfo> info) throws IOException {
        super(db, serialClassInfoRecid, info);
    }

    public Serialization() {
        super(null, 0L, new ArrayList<SerialClassInfo.ClassInfo>());
    }

    byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        DataOutputStream da = new DataOutputStream(ba);
        this.serialize((DataOutput)da, obj);
        da.close();
        return ba.toByteArray();
    }

    boolean isSerializable(Object obj) {
        try {
            this.serialize((DataOutput)new DataOutputStream(new ByteArrayOutputStream()), obj);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void serialize(DataOutput out, Object obj) throws IOException {
        this.serialize(out, obj, null);
    }

    @Override
    public void serialize(DataOutput out, Object obj, FastArrayList objectStack) throws IOException {
        Class<?> clazz;
        if (objectStack != null) {
            int indexInObjectStack = objectStack.identityIndexOf(obj);
            if (indexInObjectStack != -1) {
                out.write(166);
                LongPacker.packInt(out, indexInObjectStack);
                return;
            }
            objectStack.add(obj);
        }
        Class<?> clazz2 = clazz = obj != null ? obj.getClass() : null;
        if (obj == null) {
            out.write(0);
            return;
        }
        if (clazz == Boolean.class) {
            if (((Boolean)obj).booleanValue()) {
                out.write(2);
            } else {
                out.write(3);
            }
            return;
        }
        if (clazz == Integer.class) {
            int val = (Integer)obj;
            this.writeInteger(out, val);
            return;
        }
        if (clazz == Double.class) {
            double v = (Double)obj;
            if (v == -1.0) {
                out.write(47);
            } else if (v == 0.0) {
                out.write(48);
            } else if (v == 1.0) {
                out.write(49);
            } else if (v >= 0.0 && v <= 255.0 && (double)((int)v) == v) {
                out.write(50);
                out.write((int)v);
            } else if (v >= -32768.0 && v <= 32767.0 && (double)((short)v) == v) {
                out.write(51);
                out.writeShort((int)v);
            } else {
                out.write(52);
                out.writeDouble(v);
            }
            return;
        }
        if (clazz == Float.class) {
            float v = ((Float)obj).floatValue();
            if (v == -1.0f) {
                out.write(41);
            } else if (v == 0.0f) {
                out.write(42);
            } else if (v == 1.0f) {
                out.write(43);
            } else if (v >= 0.0f && v <= 255.0f && (float)((int)v) == v) {
                out.write(44);
                out.write((int)v);
            } else if (v >= -32768.0f && v <= 32767.0f && (float)((short)v) == v) {
                out.write(45);
                out.writeShort((int)v);
            } else {
                out.write(46);
                out.writeFloat(v);
            }
            return;
        }
        if (clazz == BigInteger.class) {
            out.write(55);
            byte[] buf = ((BigInteger)obj).toByteArray();
            this.serializeByteArrayInt(out, buf);
            return;
        }
        if (clazz == BigDecimal.class) {
            out.write(54);
            BigDecimal d = (BigDecimal)obj;
            this.serializeByteArrayInt(out, d.unscaledValue().toByteArray());
            LongPacker.packInt(out, d.scale());
            return;
        }
        if (clazz == Long.class) {
            long val = (Long)obj;
            this.writeLong(out, val);
            return;
        }
        if (clazz == Short.class) {
            short val = (Short)obj;
            if (val == -1) {
                out.write(31);
            } else if (val == 0) {
                out.write(32);
            } else if (val == 1) {
                out.write(33);
            } else if (val > 0 && val < 255) {
                out.write(34);
                out.write(val);
            } else {
                out.write(35);
                out.writeShort(val);
            }
            return;
        }
        if (clazz == Byte.class) {
            byte val = (Byte)obj;
            if (val == -1) {
                out.write(36);
            } else if (val == 0) {
                out.write(37);
            } else if (val == 1) {
                out.write(38);
            } else {
                out.write(35);
                out.writeByte(val);
            }
            return;
        }
        if (clazz == Character.class) {
            out.write(40);
            out.writeChar(((Character)obj).charValue());
            return;
        }
        if (clazz == String.class) {
            String s = (String)obj;
            if (s.length() == 0) {
                out.write(101);
            } else {
                out.write(103);
                Serialization.serializeString(out, s);
            }
            return;
        }
        if (obj instanceof Class) {
            out.write(126);
            this.serialize(out, ((Class)obj).getName());
            return;
        }
        if (obj instanceof int[]) {
            this.writeIntArray(out, (int[])obj);
            return;
        }
        if (obj instanceof long[]) {
            this.writeLongArray(out, (long[])obj);
            return;
        }
        if (obj instanceof short[]) {
            out.write(58);
            short[] a = (short[])obj;
            LongPacker.packInt(out, a.length);
            for (short s : a) {
                out.writeShort(s);
            }
            return;
        }
        if (obj instanceof boolean[]) {
            out.write(59);
            boolean[] a = (boolean[])obj;
            LongPacker.packInt(out, a.length);
            for (boolean s : a) {
                out.writeBoolean(s);
            }
            return;
        }
        if (obj instanceof double[]) {
            out.write(53);
            double[] a = (double[])obj;
            LongPacker.packInt(out, a.length);
            for (double s : a) {
                out.writeDouble(s);
            }
            return;
        }
        if (obj instanceof float[]) {
            out.write(56);
            float[] a = (float[])obj;
            LongPacker.packInt(out, a.length);
            for (float s : a) {
                out.writeFloat(s);
            }
            return;
        }
        if (obj instanceof char[]) {
            out.write(70);
            char[] a = (char[])obj;
            LongPacker.packInt(out, a.length);
            for (char s : a) {
                out.writeChar(s);
            }
            return;
        }
        if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            out.write(71);
            this.serializeByteArrayInt(out, b);
            return;
        }
        if (clazz == Date.class) {
            out.write(127);
            out.writeLong(((Date)obj).getTime());
            return;
        }
        if (clazz == BTree.class) {
            out.write(161);
            ((BTree)obj).writeExternal(out);
            return;
        }
        if (clazz == HTree.class) {
            out.write(160);
            ((HTree)obj).serialize(out);
            return;
        }
        if (clazz == LinkedList2.class) {
            out.write(159);
            ((LinkedList2)obj).serialize(out);
            return;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList<Object>();
            objectStack.add(obj);
        }
        if (obj instanceof Object[]) {
            boolean packableLongs;
            Object[] b = (Object[])obj;
            boolean bl = packableLongs = b.length <= 255;
            if (packableLongs) {
                for (Object o : b) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
            }
            if (packableLongs) {
                out.write(74);
                out.write(b.length);
                for (Object o : b) {
                    if (o == null) {
                        LongPacker.packLong(out, 0L);
                        continue;
                    }
                    LongPacker.packLong(out, (Long)o + 1L);
                }
            } else {
                out.write(73);
                LongPacker.packInt(out, b.length);
                for (Object o : b) {
                    this.serialize(out, o, objectStack);
                }
            }
        } else if (clazz == ArrayList.class) {
            boolean packableLongs;
            ArrayList l = (ArrayList)obj;
            boolean bl = packableLongs = l.size() < 255;
            if (packableLongs) {
                for (Object o : l) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
            }
            if (packableLongs) {
                out.write(75);
                out.write(l.size());
                for (Object o : l) {
                    if (o == null) {
                        LongPacker.packLong(out, 0L);
                        continue;
                    }
                    LongPacker.packLong(out, (Long)o + 1L);
                }
            } else {
                this.serializeCollection(105, out, obj, objectStack);
            }
        } else if (clazz == LinkedList.class) {
            this.serializeCollection(119, out, obj, objectStack);
        } else if (clazz == Vector.class) {
            this.serializeCollection(121, out, obj, objectStack);
        } else if (clazz == TreeSet.class) {
            TreeSet l = (TreeSet)obj;
            out.write(113);
            LongPacker.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l) {
                this.serialize(out, o, objectStack);
            }
        } else if (clazz == HashSet.class) {
            this.serializeCollection(115, out, obj, objectStack);
        } else if (clazz == LinkedHashSet.class) {
            this.serializeCollection(117, out, obj, objectStack);
        } else if (clazz == TreeMap.class) {
            TreeMap l = (TreeMap)obj;
            out.write(107);
            LongPacker.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l.keySet()) {
                this.serialize(out, o, objectStack);
                this.serialize(out, l.get(o), objectStack);
            }
        } else if (clazz == HashMap.class) {
            this.serializeMap(109, out, obj, objectStack);
        } else if (clazz == LinkedHashMap.class) {
            this.serializeMap(111, out, obj, objectStack);
        } else if (clazz == Hashtable.class) {
            this.serializeMap(123, out, obj, objectStack);
        } else if (clazz == Properties.class) {
            this.serializeMap(125, out, obj, objectStack);
        } else {
            out.write(1);
            this.writeObject(out, obj, objectStack);
        }
    }

    static void serializeString(DataOutput out, String obj) throws IOException {
        int len = obj.length();
        LongPacker.packInt(out, len);
        for (int i = 0; i < len; ++i) {
            char c = obj.charAt(i);
            LongPacker.packInt(out, c);
        }
    }

    private void serializeMap(int header, DataOutput out, Object obj, FastArrayList objectStack) throws IOException {
        Map l = (Map)obj;
        out.write(header);
        LongPacker.packInt(out, l.size());
        for (Object o : l.keySet()) {
            this.serialize(out, o, objectStack);
            this.serialize(out, l.get(o), objectStack);
        }
    }

    private void serializeCollection(int header, DataOutput out, Object obj, FastArrayList objectStack) throws IOException {
        Collection l = (Collection)obj;
        out.write(header);
        LongPacker.packInt(out, l.size());
        for (Object o : l) {
            this.serialize(out, o, objectStack);
        }
    }

    private void serializeByteArrayInt(DataOutput out, byte[] b) throws IOException {
        LongPacker.packInt(out, b.length);
        out.write(b);
    }

    private void writeLongArray(DataOutput da, long[] obj) throws IOException {
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (long i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        if (0L <= min && max <= 255L) {
            da.write(65);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.write((int)l);
            }
        } else if (0L <= min && max <= Long.MAX_VALUE) {
            da.write(69);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                LongPacker.packLong(da, l);
            }
        } else if (-32768L <= min && max <= 32767L) {
            da.write(66);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeShort((short)l);
            }
        } else if (Integer.MIN_VALUE <= min && max <= Integer.MAX_VALUE) {
            da.write(67);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeInt((int)l);
            }
        } else {
            da.write(68);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeLong(l);
            }
        }
    }

    private void writeIntArray(DataOutput da, int[] obj) throws IOException {
        boolean fitsInShort;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        boolean fitsInByte = 0 <= min && max <= 255;
        boolean bl = fitsInShort = Short.MIN_VALUE >= min && max <= Short.MAX_VALUE;
        if (obj.length <= 255 && fitsInByte) {
            da.write(60);
            da.write(obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (fitsInByte) {
            da.write(61);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (0 <= min && max <= Integer.MAX_VALUE) {
            da.write(64);
            LongPacker.packInt(da, obj.length);
            for (int l : obj) {
                LongPacker.packInt(da, l);
            }
        } else if (fitsInShort) {
            da.write(62);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeShort(i);
            }
        } else {
            da.write(63);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeInt(i);
            }
        }
    }

    private void writeInteger(DataOutput da, int val) throws IOException {
        if (val == -1) {
            da.write(4);
        } else if (val == 0) {
            da.write(5);
        } else if (val == 1) {
            da.write(6);
        } else if (val == 2) {
            da.write(7);
        } else if (val == 3) {
            da.write(8);
        } else if (val == 4) {
            da.write(9);
        } else if (val == 5) {
            da.write(10);
        } else if (val == 6) {
            da.write(11);
        } else if (val == 7) {
            da.write(12);
        } else if (val == 8) {
            da.write(13);
        } else if (val == Integer.MIN_VALUE) {
            da.write(57);
        } else if (val > 0 && val < 255) {
            da.write(14);
            da.write(val);
        } else if (val < 0) {
            da.write(15);
            LongPacker.packInt(da, -val);
        } else {
            da.write(16);
            LongPacker.packInt(da, val);
        }
    }

    private void writeLong(DataOutput da, long val) throws IOException {
        if (val == -1L) {
            da.write(17);
        } else if (val == 0L) {
            da.write(18);
        } else if (val == 1L) {
            da.write(19);
        } else if (val == 2L) {
            da.write(20);
        } else if (val == 3L) {
            da.write(21);
        } else if (val == 4L) {
            da.write(22);
        } else if (val == 5L) {
            da.write(23);
        } else if (val == 6L) {
            da.write(24);
        } else if (val == 7L) {
            da.write(25);
        } else if (val == 8L) {
            da.write(26);
        } else if (val == Long.MIN_VALUE) {
            da.write(30);
        } else if (val > 0L && val < 255L) {
            da.write(29);
            da.write((int)val);
        } else if (val < 0L) {
            da.write(27);
            LongPacker.packLong(da, -val);
        } else {
            da.write(28);
            LongPacker.packLong(da, val);
        }
    }

    Object deserialize(byte[] buf) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bs = new ByteArrayInputStream(buf);
        DataInputStream das = new DataInputStream(bs);
        Object ret = this.deserialize(das);
        if (bs.available() != 0) {
            throw new InternalError("bytes left: " + bs.available());
        }
        return ret;
    }

    static String deserializeString(DataInput buf) throws IOException {
        int len = LongPacker.unpackInt(buf);
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)LongPacker.unpackInt(buf);
        }
        return new String(b);
    }

    public Object deserialize(DataInput is) throws IOException, ClassNotFoundException {
        return this.deserialize(is, null);
    }

    @Override
    public Object deserialize(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        Object ret = null;
        int head = is.readUnsignedByte();
        switch (head) {
            case 0: {
                break;
            }
            case 2: {
                ret = Boolean.TRUE;
                break;
            }
            case 3: {
                ret = Boolean.FALSE;
                break;
            }
            case 4: {
                ret = -1;
                break;
            }
            case 5: {
                ret = 0;
                break;
            }
            case 6: {
                ret = 1;
                break;
            }
            case 7: {
                ret = 2;
                break;
            }
            case 8: {
                ret = 3;
                break;
            }
            case 9: {
                ret = 4;
                break;
            }
            case 10: {
                ret = 5;
                break;
            }
            case 11: {
                ret = 6;
                break;
            }
            case 12: {
                ret = 7;
                break;
            }
            case 13: {
                ret = 8;
                break;
            }
            case 57: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 14: {
                ret = is.readUnsignedByte();
                break;
            }
            case 15: {
                ret = -LongPacker.unpackInt(is);
                break;
            }
            case 16: {
                ret = LongPacker.unpackInt(is);
                break;
            }
            case 17: {
                ret = -1L;
                break;
            }
            case 18: {
                ret = 0L;
                break;
            }
            case 19: {
                ret = 1L;
                break;
            }
            case 20: {
                ret = 2L;
                break;
            }
            case 21: {
                ret = 3L;
                break;
            }
            case 22: {
                ret = 4L;
                break;
            }
            case 23: {
                ret = 5L;
                break;
            }
            case 24: {
                ret = 6L;
                break;
            }
            case 25: {
                ret = 7L;
                break;
            }
            case 26: {
                ret = 8L;
                break;
            }
            case 29: {
                ret = (long)is.readUnsignedByte();
                break;
            }
            case 27: {
                ret = -LongPacker.unpackLong(is);
                break;
            }
            case 28: {
                ret = LongPacker.unpackLong(is);
                break;
            }
            case 30: {
                ret = Long.MIN_VALUE;
                break;
            }
            case 31: {
                ret = (short)-1;
                break;
            }
            case 32: {
                ret = (short)0;
                break;
            }
            case 33: {
                ret = (short)1;
                break;
            }
            case 34: {
                ret = (short)is.readUnsignedByte();
                break;
            }
            case 35: {
                ret = is.readShort();
                break;
            }
            case 36: {
                ret = (byte)-1;
                break;
            }
            case 37: {
                ret = (byte)0;
                break;
            }
            case 38: {
                ret = (byte)1;
                break;
            }
            case 39: {
                ret = is.readByte();
                break;
            }
            case 58: {
                int size = LongPacker.unpackInt(is);
                ret = new short[size];
                for (int i = 0; i < size; ++i) {
                    ((short[])ret)[i] = is.readShort();
                }
                break;
            }
            case 59: {
                int size = LongPacker.unpackInt(is);
                ret = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ((boolean[])ret)[i] = is.readBoolean();
                }
                break;
            }
            case 53: {
                int size = LongPacker.unpackInt(is);
                ret = new double[size];
                for (int i = 0; i < size; ++i) {
                    ((double[])ret)[i] = is.readDouble();
                }
                break;
            }
            case 56: {
                int size = LongPacker.unpackInt(is);
                ret = new float[size];
                for (int i = 0; i < size; ++i) {
                    ((float[])ret)[i] = is.readFloat();
                }
                break;
            }
            case 70: {
                int size = LongPacker.unpackInt(is);
                ret = new char[size];
                for (int i = 0; i < size; ++i) {
                    ((char[])ret)[i] = is.readChar();
                }
                break;
            }
            case 40: {
                ret = Character.valueOf(is.readChar());
                break;
            }
            case 41: {
                ret = Float.valueOf(-1.0f);
                break;
            }
            case 42: {
                ret = Float.valueOf(0.0f);
                break;
            }
            case 43: {
                ret = Float.valueOf(1.0f);
                break;
            }
            case 44: {
                ret = Float.valueOf(is.readUnsignedByte());
                break;
            }
            case 45: {
                ret = Float.valueOf(is.readShort());
                break;
            }
            case 46: {
                ret = Float.valueOf(is.readFloat());
                break;
            }
            case 47: {
                ret = -1.0;
                break;
            }
            case 48: {
                ret = 0.0;
                break;
            }
            case 49: {
                ret = 1.0;
                break;
            }
            case 50: {
                ret = (double)is.readUnsignedByte();
                break;
            }
            case 51: {
                ret = (double)is.readShort();
                break;
            }
            case 52: {
                ret = is.readDouble();
                break;
            }
            case 55: {
                ret = new BigInteger(this.deserializeArrayByteInt(is));
                break;
            }
            case 54: {
                ret = new BigDecimal(new BigInteger(this.deserializeArrayByteInt(is)), LongPacker.unpackInt(is));
                break;
            }
            case 103: {
                ret = Serialization.deserializeString(is);
                break;
            }
            case 101: {
                ret = "";
                break;
            }
            case 126: {
                ret = this.deserializeClass(is);
                break;
            }
            case 127: {
                ret = new Date(is.readLong());
                break;
            }
            case 60: {
                ret = this.deserializeArrayIntB255(is);
                break;
            }
            case 61: {
                ret = this.deserializeArrayIntBInt(is);
                break;
            }
            case 62: {
                ret = this.deserializeArrayIntSInt(is);
                break;
            }
            case 63: {
                ret = this.deserializeArrayIntIInt(is);
                break;
            }
            case 64: {
                ret = this.deserializeArrayIntPack(is);
                break;
            }
            case 65: {
                ret = this.deserializeArrayLongB(is);
                break;
            }
            case 66: {
                ret = this.deserializeArrayLongS(is);
                break;
            }
            case 67: {
                ret = this.deserializeArrayLongI(is);
                break;
            }
            case 68: {
                ret = this.deserializeArrayLongL(is);
                break;
            }
            case 69: {
                ret = this.deserializeArrayLongPack(is);
                break;
            }
            case 75: {
                ret = this.deserializeArrayListPackedLong(is);
                break;
            }
            case 71: {
                ret = this.deserializeArrayByteInt(is);
                break;
            }
            case 159: {
                ret = LinkedList2.deserialize(is, this);
                break;
            }
            case 160: {
                ret = HTree.deserialize(is, this);
                break;
            }
            case 161: {
                ret = BTree.readExternal(is, this);
                break;
            }
            case 162: {
                throw new InternalError("BPage header, wrong serializer used");
            }
            case 163: {
                throw new InternalError("BPage header, wrong serializer used");
            }
            case 172: {
                throw new InternalError("Wrong header, data were probably serialized with OutputStream, not with JDBM serialization");
            }
            case -1: {
                throw new EOFException();
            }
        }
        if (ret != null || head == 0) {
            if (objectStack != null) {
                objectStack.add((Object[])ret);
            }
            return ret;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList<Object[]>();
        }
        int oldObjectStackSize = objectStack.size();
        switch (head) {
            case 1: {
                ret = this.readObject(is, objectStack);
                break;
            }
            case 166: {
                ret = objectStack.get(LongPacker.unpackInt(is));
                break;
            }
            case 105: {
                ret = this.deserializeArrayList(is, objectStack);
                break;
            }
            case 73: {
                ret = this.deserializeArrayObject(is, objectStack);
                break;
            }
            case 74: {
                ret = this.deserializeArrayObjectPackedLong(is);
                break;
            }
            case 119: {
                ret = this.deserializeLinkedList(is, objectStack);
                break;
            }
            case 113: {
                ret = this.deserializeTreeSet(is, objectStack);
                break;
            }
            case 115: {
                ret = this.deserializeHashSet(is, objectStack);
                break;
            }
            case 117: {
                ret = this.deserializeLinkedHashSet(is, objectStack);
                break;
            }
            case 121: {
                ret = this.deserializeVector(is, objectStack);
                break;
            }
            case 107: {
                ret = this.deserializeTreeMap(is, objectStack);
                break;
            }
            case 109: {
                ret = this.deserializeHashMap(is, objectStack);
                break;
            }
            case 111: {
                ret = this.deserializeLinkedHashMap(is, objectStack);
                break;
            }
            case 123: {
                ret = this.deserializeHashtable(is, objectStack);
                break;
            }
            case 125: {
                ret = this.deserializeProperties(is, objectStack);
                break;
            }
            default: {
                throw new InternalError("Unknown serialization header: " + head);
            }
        }
        if (head != 166 && objectStack.size() == oldObjectStackSize) {
            objectStack.add((Object[])ret);
        }
        return ret;
    }

    private Class deserializeClass(DataInput is) throws IOException, ClassNotFoundException {
        String className = (String)this.deserialize(is);
        Class<?> cls = Class.forName(className);
        return cls;
    }

    private byte[] deserializeArrayByteInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        byte[] b = new byte[size];
        is.readFully(b);
        return b;
    }

    private long[] deserializeArrayLongL(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readLong();
        }
        return ret;
    }

    private long[] deserializeArrayLongI(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private long[] deserializeArrayLongS(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private long[] deserializeArrayLongB(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0L) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntIInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private int[] deserializeArrayIntSInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private int[] deserializeArrayIntBInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntPack(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackInt(is);
        }
        return ret;
    }

    private long[] deserializeArrayLongPack(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackLong(is);
        }
        return ret;
    }

    private int[] deserializeArrayIntB255(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private Object[] deserializeArrayObject(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Object[] s = new Object[size];
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s[i] = this.deserialize(is, objectStack);
        }
        return s;
    }

    private Object[] deserializeArrayObjectPackedLong(DataInput is) throws IOException, ClassNotFoundException {
        int size = is.readUnsignedByte();
        Object[] s = new Object[size];
        for (int i = 0; i < size; ++i) {
            long l = LongPacker.unpackLong(is);
            s[i] = l == 0L ? null : Long.valueOf(l - 1L);
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayList(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        ArrayList<Object> s = new ArrayList<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayListPackedLong(DataInput is) throws IOException, ClassNotFoundException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        ArrayList<Object> s = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            long l = LongPacker.unpackLong(is);
            if (l == 0L) {
                s.add(null);
                continue;
            }
            s.add(l - 1L);
        }
        return s;
    }

    private LinkedList deserializeLinkedList(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedList<Object> s = new LinkedList<Object>();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private Vector<Object> deserializeVector(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Vector<Object> s = new Vector<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashSet<Object> deserializeHashSet(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        HashSet<Object> s = new HashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashSet<Object> deserializeLinkedHashSet(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeSet<Object> deserializeTreeSet(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        TreeSet<Object> s = new TreeSet<Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeMap<Object, Object> deserializeTreeMap(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashMap<Object, Object> deserializeHashMap(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashMap<Object, Object> deserializeLinkedHashMap(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private Hashtable<Object, Object> deserializeHashtable(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Hashtable<Object, Object> s = new Hashtable<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private Properties deserializeProperties(DataInput is, FastArrayList objectStack) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Properties s = new Properties();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FastArrayList<K> {
        private int size = 0;
        private K[] elementData = new Object[8];

        FastArrayList() {
        }

        K get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.elementData[index];
        }

        void add(K o) {
            if (this.elementData.length == this.size) {
                this.elementData = Arrays.copyOf(this.elementData, this.elementData.length * 2);
            }
            this.elementData[this.size] = o;
            ++this.size;
        }

        int size() {
            return this.size;
        }

        int identityIndexOf(Object obj) {
            for (int i = 0; i < this.size; ++i) {
                if (obj != this.elementData[i]) continue;
                return i;
            }
            return -1;
        }
    }
}

